<?php
add_action('admin_menu', 'ssb_register_admin_page');
function ssb_register_admin_page() {
    add_menu_page(
        'Stripe Customers',
        'Stripe Billing',
        'manage_options',
        'ssb-stripe-customers',
        'ssb_render_admin_page',
        'dashicons-credit-card',
        56
    );
}

function ssb_render_admin_page() {
    global $wpdb;
    $table = $wpdb->prefix . 'ssb_customers';
    $results = $wpdb->get_results("SELECT * FROM $table ORDER BY id DESC");
    ?>

    <div class="wrap">
        <h1>Stripe Saved Customers</h1>
        <table class="widefat striped">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Customer ID</th>
                    <th>Payment Method</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($results as $row): ?>
                <tr>
                    <td><?php echo esc_html($row->name); ?></td>
                    <td><?php echo esc_html($row->email); ?></td>
                    <td><?php echo esc_html($row->stripe_customer_id); ?></td>
                    <td><?php echo esc_html($row->payment_method_id); ?></td>
                    <td>
                        <button class="button ssb-charge-btn" data-id="<?php echo $row->id; ?>" data-customer="<?php echo $row->stripe_customer_id; ?>" data-payment="<?php echo $row->payment_method_id; ?>">Charge</button>
                        <button class="button ssb-subscribe-btn" data-id="<?php echo $row->id; ?>" data-customer="<?php echo $row->stripe_customer_id; ?>" data-payment="<?php echo $row->payment_method_id; ?>">Subscribe</button>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div id="ssb-charge-modal" style="display:none;">
        <h2>One-Time Charge</h2>
        <input type="number" id="ssb_charge_amount" placeholder="Amount in USD">
        <button class="button button-primary" id="ssb_confirm_charge">Charge Now</button>
    </div>

    <div id="ssb-subscribe-modal" style="display:none;">
        <h2>Create Subscription</h2>
        <input type="text" id="ssb_price_id" placeholder="Stripe Price ID">
        <button class="button button-primary" id="ssb_confirm_subscribe">Start Subscription</button>
    </div>

    <script>
    let selectedCustomer = '', selectedPayment = '';

    document.querySelectorAll('.ssb-charge-btn').forEach(btn => {
        btn.addEventListener('click', () => {
            selectedCustomer = btn.dataset.customer;
            selectedPayment = btn.dataset.payment;
            tb_show('Charge Customer', '#TB_inline?inlineId=ssb-charge-modal&height=200&width=300');
        });
    });

    document.querySelectorAll('.ssb-subscribe-btn').forEach(btn => {
        btn.addEventListener('click', () => {
            selectedCustomer = btn.dataset.customer;
            selectedPayment = btn.dataset.payment;
            tb_show('Subscribe Customer', '#TB_inline?inlineId=ssb-subscribe-modal&height=200&width=300');
        });
    });

    document.getElementById('ssb_confirm_charge').addEventListener('click', async () => {
        const amount = document.getElementById('ssb_charge_amount').value;

        const res = await fetch(ajaxurl + '?action=ssb_charge_customer', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ customer_id: selectedCustomer, payment_method: selectedPayment, amount })
        });
        const data = await res.json();
        alert(data.message);
        tb_remove();
    });

    document.getElementById('ssb_confirm_subscribe').addEventListener('click', async () => {
        const price_id = document.getElementById('ssb_price_id').value;

        const res = await fetch(ajaxurl + '?action=ssb_subscribe_customer', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ customer_id: selectedCustomer, payment_method: selectedPayment, price_id })
        });
        const data = await res.json();
        alert(data.message);
        tb_remove();
    });
    </script>

    <?php add_thickbox(); ?>
