<?php
register_activation_hook(__FILE__, 'ssb_create_customer_table');
function ssb_create_customer_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ssb_customers';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id INT NOT NULL AUTO_INCREMENT,
        name VARCHAR(191) NOT NULL,
        email VARCHAR(191) NOT NULL,
        stripe_customer_id VARCHAR(100),
        payment_method_id VARCHAR(100),
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
