<?php
/*
Plugin Name: Stripe Subscription Billing
Description: Save card details and manage subscriptions or one-time charges via Stripe.
Version: 1.0
Author: Malik Ubaid
*/

defined('ABSPATH') || exit;

// Add Stripe JS and CSS
function ssb_enqueue_stripe_scripts() {
    wp_enqueue_script('stripe-js', 'https://js.stripe.com/v3/');
}
add_action('wp_enqueue_scripts', 'ssb_enqueue_stripe_scripts');

// Create shortcode [stripe_card_form]
function ssb_card_form_shortcode() {
    ob_start(); ?>
    <style>
      .ssb-container {
        max-width: 500px;
        margin: 40px auto;
        padding: 30px;
        background-color: #fff;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        font-family: 'Helvetica Neue', sans-serif;
        background: #fff8f9;
      }

      .ssb-container h2 {
        color: #d99ba8;
        font-weight: bold;
        text-align: center;
        margin-bottom: 20px;
      }

      .ssb-container input,
      .StripeElement {
       
        border-radius: 10px;
        border: 1px solid #ddd;
        padding: 10px 15px;
      }

      .ssb-container button {
        background-color: #d99ba8;
        color: white;
        border: none;
        font-weight: bold;
        border-radius: 10px;
        height: 45px;
      }

      .ssb-container button:hover {
        background-color: #c58695;
      }

      .ssb-container .alert {
        border-radius: 10px;
      }

      .ssb-container #ssb-card-element {
        padding: 10px;
        border-radius: 10px;
        border: 1px solid #ddd;
        background: white;
      }
      .mt-3{
          margin-top:5px;
      }
      .mb-3{
          margin-bottom:5px;
      }
    </style>

    <div class="ssb-container">
      <h2>Secure Your Payment</h2>
      <form id="ssb-card-form">
        <div class="mb-3">
          <input type="text" id="ssb_name" class="form-control" placeholder="Full Name" required>
        </div>
        <div class="mb-3">
          <input type="email" id="ssb_email" class="form-control" placeholder="Email Address" required>
        </div>
        <div class="mb-3">
          <div id="ssb-card-element"></div>
        </div>
        <div id="ssb-card-errors" class="text-danger mb-3"></div>
        <button type="submit" class="btn w-100">Save Card</button>
        <div id="ssb-success-message" class="alert alert-success mt-3 d-none"></div>
      </form>
    </div>

    <script>
      document.addEventListener("DOMContentLoaded", async () => {
        const stripe = Stripe("pk_test_51HoV0JFFWbjoruwt8TbFsfFe71woYakmZEeNqqCNk3BFTrVphrefaXRuVh95JEvJx0IcF6ikd5ZjaflU7uFWPBuC001B1Y4p8a"); // Replace with your publishable key
        const elements = stripe.elements();
        const card = elements.create("card");
        card.mount("#ssb-card-element");

        document.getElementById("ssb-card-form").addEventListener("submit", async (e) => {
          e.preventDefault();
          const name = document.getElementById("ssb_name").value;
          const email = document.getElementById("ssb_email").value;

          const response = await fetch("<?php echo admin_url('admin-ajax.php'); ?>?action=ssb_create_setup_intent", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ name, email })
          });
          const data = await response.json();

          const { setupIntent, error } = await stripe.confirmCardSetup(data.client_secret, {
            payment_method: {
              card: card,
              billing_details: { name, email },
            },
          });

          if (error) {
            document.getElementById("ssb-card-errors").textContent = error.message;
          } else {
            const msg = document.getElementById("ssb-success-message");
            msg.classList.remove("d-none");
            msg.innerHTML = "✅ Card saved successfully!<br><strong>Payment Method ID:</strong> " + setupIntent.payment_method;
            // Save to WordPress DB
            fetch("<?php echo admin_url('admin-ajax.php'); ?>?action=ssb_save_payment_data", {
              method: "POST",
              headers: { "Content-Type": "application/json" },
              body: JSON.stringify({
                name,
                email,
                customer_id: data.customer_id,
                payment_method_id: setupIntent.payment_method
              })
            });

          }
        });
      });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('stripe_card_form', 'ssb_card_form_shortcode');
add_action('wp_ajax_ssb_create_setup_intent', 'ssb_create_setup_intent');
add_action('wp_ajax_nopriv_ssb_create_setup_intent', 'ssb_create_setup_intent');

function ssb_create_setup_intent() {
    require_once __DIR__ . '/stripe/init.php'; // Load Stripe SDK

    \Stripe\Stripe::setApiKey('sk_test_51HoV0JFFWbjoruwtfBBBwHo6QCMIOM7LE7u7SAOKZdr9DvePVWs3jqtcx2cijSKCwoh3WWYi4gT3vFcAu7YdzNe9006Q4YL0S5'); // Your Secret Key

    $data = json_decode(file_get_contents('php://input'), true);
    $name = sanitize_text_field($data['name']);
    $email = sanitize_email($data['email']);

    $customer = \Stripe\Customer::create([
        'name' => $name,
        'email' => $email,
    ]);

    $intent = \Stripe\SetupIntent::create([
        'customer' => $customer->id,
    ]);

    echo json_encode([
        'client_secret' => $intent->client_secret,
        'customer_id' => $customer->id
    ]);
    wp_die();
}
add_action('wp_ajax_ssb_save_payment_data', 'ssb_save_payment_data');
add_action('wp_ajax_nopriv_ssb_save_payment_data', 'ssb_save_payment_data');

function ssb_save_payment_data() {
    global $wpdb;
    $table = $wpdb->prefix . 'ssb_customers';

    $data = json_decode(file_get_contents('php://input'), true);

    $name = sanitize_text_field($data['name']);
    $email = sanitize_email($data['email']);
    $customer_id = sanitize_text_field($data['customer_id']);
    $payment_method_id = sanitize_text_field($data['payment_method_id']);

    $wpdb->insert($table, [
        'name' => $name,
        'email' => $email,
        'stripe_customer_id' => $customer_id,
        'payment_method_id' => $payment_method_id,
    ]);

    echo json_encode(['status' => 'success']);
    wp_die();
}

register_activation_hook(__FILE__, 'ssb_create_customer_table');
function ssb_create_customer_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ssb_customers';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id INT NOT NULL AUTO_INCREMENT,
        name VARCHAR(191) NOT NULL,
        email VARCHAR(191) NOT NULL,
        stripe_customer_id VARCHAR(100),
        payment_method_id VARCHAR(100),
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
