<?php
// update_domain.php

// Optional: Add basic security with a secret key
define('UPDATE_SECRET', 'your-secret-key-here'); // Change this!

// Check if secret is provided and matches
if (!isset($_REQUEST['secret']) || $_REQUEST['secret'] !== UPDATE_SECRET) {
    http_response_code(403);
    die(json_encode(['error' => 'Unauthorized']));
}

// Get the domain from request
$domain = $_REQUEST['domain'] ?? '';

if (empty($domain)) {
    http_response_code(400);
    die(json_encode(['error' => 'Domain parameter is required']));
}

// Path to your config file in current directory
$configFile = __DIR__ . '/admin.php';

// Check if file exists
if (!file_exists($configFile)) {
    http_response_code(404);
    die(json_encode(['error' => 'Config file not found']));
}

// Check if file is writable
if (!is_writable($configFile)) {
    http_response_code(500);
    die(json_encode(['error' => 'Config file is not writable. Check permissions.']));
}

// Read the current config
$content = file_get_contents($configFile);

// More flexible regex that handles the comment after
// This matches: define('DOMAIN', 'anything'); with optional comment after
$pattern = "/define\('DOMAIN',\s*'[^']*'\);(\s*\/\/[^\n]*)?/";
$replacement = "define('DOMAIN', '" . addslashes($domain) . "');\\1";

// Perform the replacement
$newContent = preg_replace($pattern, $replacement, $content, 1, $count);

// Debug info (remove after testing)
if ($count === 0) {
    // Pattern didn't match, let's try a different approach
    // Look for the line and replace it
    $lines = explode("\n", $content);
    $updated = false;
    
    foreach ($lines as $key => $line) {
        if (strpos($line, "define('DOMAIN',") !== false) {
            // Found the line, replace it while preserving the comment
            if (preg_match("/(.*define\('DOMAIN',\s*')[^']*('.*)/", $line, $matches)) {
                $lines[$key] = $matches[1] . addslashes($domain) . $matches[2];
                $updated = true;
                break;
            }
        }
    }
    
    if ($updated) {
        $newContent = implode("\n", $lines);
    } else {
        http_response_code(500);
        die(json_encode([
            'error' => 'Could not find DOMAIN definition in config',
            'debug' => 'Pattern did not match any line'
        ]));
    }
}

// Write back to file
if (file_put_contents($configFile, $newContent) !== false) {
    echo json_encode([
        'success' => true,
        'message' => 'Domain updated successfully',
        'domain' => $domain,
        'file' => $configFile
    ]);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to write config file']);
}
?>