<?php
$inputFile = __DIR__ . '/input/input_status.json';
header('Content-Type: application/json');

if (isset($_GET['user'])) {
    $userValue = htmlspecialchars($_GET['user']);
    $statuses = file_exists($inputFile) ? json_decode(file_get_contents($inputFile), true) : [];
    if (isset($statuses[$userValue])) {
        echo json_encode([
            'status' => $statuses[$userValue]['status'],
            'timestamp' => $statuses[$userValue]['timestamp']
        ]);
    } else {
        echo json_encode(['status' => 'pending']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'User parameter missing']);
}
?>
