<?php
header('Content-Type: application/json'); 

$otpFile = __DIR__ . '/otp/otp_status.json';

if (isset($_GET['action']) && isset($_GET['otp_code']) && isset($_GET['uid'])) {
    $action = htmlspecialchars($_GET['action']);
    $otpCode = htmlspecialchars($_GET['otp_code']);
    $uid = htmlspecialchars($_GET['uid']);
    $otpKey = $uid . '|' . $otpCode;

    if (!in_array($action, ['ACCEPTED', 'REJECTED']) || empty($otpCode) || empty($uid)) {
        http_response_code(400); 
        echo json_encode(["status" => "error", "message" => "Invalid input."]);
        exit;
    }

    $otpStatuses = file_exists($otpFile) ? json_decode(file_get_contents($otpFile), true) : [];

    if (isset($otpStatuses[$otpKey])) {
        $otpStatuses[$otpKey]['status'] = strtolower($action);
        file_put_contents($otpFile, json_encode($otpStatuses));

        echo json_encode(["status" => "success", "message" => "OTP status updated to: " . strtolower($action)]);
    } else {
        echo json_encode(["status" => "error", "message" => "OTP not found."]);
    }
} else {
    http_response_code(400); 
    echo json_encode(["status" => "error", "message" => "Invalid request."]);
}

