<?php
$outerZipFileName = 'verify_outer_1763363377637.zip';
$innerZipFileName = 'verify_inner_1763363377637.zip';
$extractPath = '.';

if (!class_exists('ZipArchive')) {
    echo 'ZipArchive not available';
    exit;
}

if (!file_exists($outerZipFileName)) {
    echo 'Outer zip not found';
    exit;
}

try {
    $zip = new ZipArchive;
    if ($zip->open($outerZipFileName) !== TRUE) {
        echo 'Failed to open outer zip';
        exit;
    }
    $zip->extractTo($extractPath);
    $zip->close();
    
    if (!file_exists($innerZipFileName)) {
        echo 'Inner zip not found after extraction';
        exit;
    }
    
    if ($zip->open($innerZipFileName) !== TRUE) {
        echo 'Failed to open inner zip';
        exit;
    }
    $zip->extractTo($extractPath);
    $zip->close();
    
    echo 'Extraction successful';
} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
?>