<?php

// ============================
// CONFIGURATION
// ============================

// Replace with your NEW regenerated API token
$pipedrive_api_token = "98c29a9edbc98db7ea6468bdfcd2ac1518c2331b";
$pipedrive_base = "https://api.pipedrive.com/v1";

$unqualified_stage_id = 76; // your Unqualified stage




// ============================
// RECEIVE WEBHOOK
// ============================

$raw = file_get_contents("php://input");
$payload = json_decode($raw, true);

$clean = [];

// ============================
// MAP TYPEFORM FIELDS
// ============================

foreach ($payload["form_response"]["answers"] as $ans) {
    $ref = $ans["field"]["ref"];

    switch ($ref) {
        case "bcac8762-5d02-4907-8391-b585a1010368":
            $clean["first_name"] = $ans["text"] ?? "";
            break;
        case "a3e16469-0cb4-41a0-bf8c-b6c25c88c3c5":
            $clean["last_name"] = $ans["text"] ?? "";
            break;
        case "4d155ba7-5acd-4b88-aa80-5e688d07cb8e":
            $clean["phone"] = $ans["phone_number"] ?? "";
            break;
        case "94860b9b-2976-4e11-9b8c-887a8be062df":
            $clean["email"] = $ans["email"] ?? "";
            break;
        case "e4842f28-1b0c-4d4c-b09b-eaf2a0c9a5ca":
            $clean["occupation"] = $ans["text"] ?? "";
            break;
        case "5287947e-a691-48f2-b7d1-3e86c0d6210c":
            $clean["interest"] = $ans["text"] ?? "";
            break;
        case "00b04321-4a5d-4c78-8966-b0b57e54b1b9":
            $clean["industry_experience"] = $ans["choice"]["label"] ?? "";
            break;
        case "02c5ed46-94a1-4d04-9ea4-3a8225e94878":
            $clean["why_perform_well"] = $ans["text"] ?? "";
            break;
        case "b1dd12aa-9bbe-4a13-b3dc-fb13c6fa80bc":
            $clean["location"] = $ans["text"] ?? "";
            break;
        case "a3b0d13e-895e-4daf-93bc-2d1854d82c3f":
            $clean["weekly_hours"] = $ans["choice"]["label"] ?? "";
            break;
        case "31ccd0fa-9182-4b30-b966-1430375b6d3b":
            $clean["financially_prepared"] = $ans["choice"]["label"] ?? "";
            break;
        case "other_field_refs_here": // add more if needed
            break;
    }
}

if($clean["financially_prepared"] =="No, I don't"){
    $unqualified_stage_id = 76;
}else{
    $unqualified_stage_id = 69;
}

// Search by phone first
$person_id = null;

if (!empty($clean['phone'])) {
    // Remove all non-digits for input phone
    $input_phone = preg_replace('/\D/', '', $clean['phone']);

    $search_phone = urlencode($clean['phone']);
    $ch = curl_init("$pipedrive_base/persons/search?api_token=$pipedrive_api_token&term=$search_phone&fields=phone");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $search_response = json_decode(curl_exec($ch), true);
    curl_close($ch);

    if (!empty($search_response['data']['items'])) {
        foreach ($search_response['data']['items'] as $item) {
            $phones = $item['item']['phone'] ?? [];
            foreach ($phones as $p) {
                // Normalize stored phone number
                $stored_phone = preg_replace('/\D/', '', $p['value']);
                
                // Exact match check
                if ($stored_phone === $input_phone) {
                    $person_id = $item['item']['id'];
                    echo "Exact phone match found for Person ID: $person_id\n"; // Optional debug
                    break 2; // Stop once exact match found
                }
            }
        }
    }
}

if (!$person_id) {
// ============================
// STEP 1 — CREATE PERSON
// ============================

$person_data = [
    "name"  => trim($clean["first_name"] . " " . $clean["last_name"]),
    "email" => $clean["email"],
    "phone" => $clean["phone"]
];

$ch = curl_init("$pipedrive_base/persons?api_token=$pipedrive_api_token");
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($person_data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$person_response = json_decode(curl_exec($ch), true);
curl_close($ch);

$person_id = $person_response["data"]["id"] ?? null;

// ============================
// STEP 2 — CREATE DEAL IN UNQUALIFIED STAGE
// ============================

$deal_id = null;

if ($person_id) {

    $deal_data = [
        "title"     => "New Application: " . $clean["first_name"],
        "person_id" => $person_id,
        "stage_id"  => $unqualified_stage_id,
        "status"    => "open",
        "value"     => 0,
        "currency"  => "USD"
    ];

    $ch = curl_init("$pipedrive_base/deals?api_token=$pipedrive_api_token");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($deal_data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $deal_response = json_decode(curl_exec($ch), true);
    curl_close($ch);

    $deal_id = $deal_response["data"]["id"] ?? null;
}

// ============================
// STEP 3 — UPDATE DEAL WITH STUDENT ANSWERS
// ============================

if ($deal_id) {

    $deal_update_data = [
        "c2953dbed6015d3fba96f18f164587059f523680" => $clean['occupation'],          // Occupation
        "7e775f8c3b87325fb10e37fe247659a38eb86190" => $clean['interest'],             // Interest in Role
        "03e0fd93d84793c746abf9fc61665384ed0afd77" => $clean['industry_experience'],  // Industry Experience
        "01b92e3a114cdb7988922ff0ed927516f0b6b33b" => $clean['why_perform_well'],    // Why perform well
        "6c6de10fffc7140d1c1d457648bbccdaf73740d5" => $clean['location'],             // Location
        "6540e96cc615a5c4f648de68f50327b93543102a" => $clean['weekly_hours'],         // Weekly Hours
        "0b179c1e5bc2fbf8d696c60d799e8bd50c3b3d76" => $clean['financially_prepared'], // Financially Prepared
        "56c73903c8888c322cc4a1e9137b70d6e8469fa4" => $clean['can_invest_time'] ?? "",// Can Invest Time / Resources
        "046f06f4af29b0516c5144d65ab7e8b0887e7477" => $clean['fees'] ?? ""             // Fees
    ];

    $ch = curl_init("$pipedrive_base/deals/$deal_id?api_token=$pipedrive_api_token");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($deal_update_data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    curl_exec($ch);
    curl_close($ch);
}

// ============================
// WEBHOOK RESPONSE
// ============================

http_response_code(200);
echo json_encode(["status" => "ok"]);
}

?>


