<?php
require 'stripe/init.php';
\Stripe\Stripe::setApiKey('sk_test_ithxc6SpCVW3LZmFnudwZEHu'); // Replace with your secret key

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$email = $input['email'];
$name = $input['name'];
$paymentMethod = $input['payment_method'];

try {
    // 1️⃣ Create or retrieve customer
    $customers = \Stripe\Customer::all(['email' => $email, 'limit' => 1]);
    $customer = count($customers->data) ? $customers->data[0] : \Stripe\Customer::create([
        'email' => $email,
        'name' => $name,
        'payment_method' => $paymentMethod,
        'invoice_settings' => ['default_payment_method' => $paymentMethod],
    ]);

    // 2️⃣ Create a product & price (only once — ideally store in DB)
    //$priceId = 'price_123456789'; // Replace with your Stripe Price ID
    // OR dynamically create:
    $product = \Stripe\Product::create(['name' => 'Premium Subscription']);
    $price = \Stripe\Price::create([
        'unit_amount' => 39900, // 399 CZK
        'currency' => 'czk',
        'recurring' => ['interval' => 'month'],
        'product' => $product->id,
    ]);
    $priceId = $price->id;
    
    // 3️⃣ Create subscription (with trial)
    $subscription = \Stripe\Subscription::create([
        'customer' => $customer->id,
        'items' => [['price' => $priceId]],
        'trial_period_days' => 7,
        'expand' => ['latest_invoice.payment_intent'],
    ]);

    $paymentIntent = $subscription->latest_invoice->payment_intent;

    if ($paymentIntent && $paymentIntent->status === 'requires_action') {
        echo json_encode([
            'requires_action' => true,
            'payment_intent_client_secret' => $paymentIntent->client_secret
        ]);
    } else {
        echo json_encode(['success' => true]);
    }
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}