<?php
if (!defined('ABSPATH')) exit;

function ssd_start_session() {
    if (!session_id()) {
        session_start();
    }
}
add_action('init', 'ssd_start_session');

function ssd_check_success_param() {
    if (isset($_GET['success']) && $_GET['success'] === 'stripe') {
        $_SESSION['download_ok'] = true;
        wp_redirect(remove_query_arg('success'));
        exit;
    }
}
add_action('template_redirect', 'ssd_check_success_param');

function ssd_download_shortcode() {
    if (!isset($_SESSION['download_ok']) || !$_SESSION['download_ok']) {
        return "<p>Unauthorized access. Please complete your purchase.</p>";
    }

    $file = get_option('ssd_uploaded_zip');
    if (!$file) return "<p>No file available for download.</p>";

    $download_url = admin_url('admin-ajax.php') . "?action=ssd_force_download";

    ob_start(); ?>
    <p>Preparing your download...</p>
    <script>
        setTimeout(function() {
            window.location.href = "<?php echo esc_url($download_url); ?>";
        }, 3000);
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('secure_download', 'ssd_download_shortcode');

function ssd_force_download() {
    if (!isset($_SESSION['download_ok']) || !$_SESSION['download_ok']) {
        wp_die("Unauthorized download.");
    }

    $_SESSION['download_ok'] = false; // prevent reuse

    $file = get_option('ssd_uploaded_zip');
    if (!$file) wp_die("No file found.");

    $upload_dir = wp_upload_dir();
    $filepath = $upload_dir['basedir'] . '/secure/' . $file;

    if (!file_exists($filepath)) wp_die("File not found.");

    header('Content-Description: File Transfer');
    header('Content-Type: application/zip');
    header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');
    header('Content-Length: ' . filesize($filepath));
    flush();
    readfile($filepath);
    exit;
}
add_action('wp_ajax_ssd_force_download', 'ssd_force_download');
add_action('wp_ajax_nopriv_ssd_force_download', 'ssd_force_download');
