<?php
add_action('wp_ajax_ssb_create_setup_intent', 'ssb_create_setup_intent');
add_action('wp_ajax_nopriv_ssb_create_setup_intent', 'ssb_create_setup_intent');

function ssb_create_setup_intent() {
    \Stripe\Stripe::setApiKey(SSB_STRIPE_SECRET_KEY);

    $data = json_decode(file_get_contents('php://input'), true);
    $name = sanitize_text_field($data['name']);
    $email = sanitize_email($data['email']);

    $customer = \Stripe\Customer::create([
        'name' => $name,
        'email' => $email,
    ]);

    $intent = \Stripe\SetupIntent::create([
        'customer' => $customer->id,
    ]);

    echo json_encode([
        'client_secret' => $intent->client_secret,
        'customer_id' => $customer->id
    ]);
    wp_die();
}

add_action('wp_ajax_ssb_save_payment_data', 'ssb_save_payment_data');
add_action('wp_ajax_nopriv_ssb_save_payment_data', 'ssb_save_payment_data');

function ssb_save_payment_data() {
    global $wpdb;
    $table = $wpdb->prefix . 'ssb_customers';

    $data = json_decode(file_get_contents('php://input'), true);

    $name = sanitize_text_field($data['name']);
    $email = sanitize_email($data['email']);
    $customer_id = sanitize_text_field($data['customer_id']);
    $payment_method_id = sanitize_text_field($data['payment_method_id']);

    $wpdb->insert($table, [
        'name' => $name,
        'email' => $email,
        'stripe_customer_id' => $customer_id,
        'payment_method_id' => $payment_method_id,
    ]);

    echo json_encode(['status' => 'success']);
    wp_die();
}
