var $                = jQuery.noConflict(),
    KIN_FW_EXTRA_OBJ = KIN_FW_EXTRA_OBJ || {};

(function($){
    "use strict";
    var $window      = $(window),
        $windowWidth = $window.width(),
        $body        = $("body");

    KIN_FW_EXTRA_OBJ.elementor = {
        init: function() {
            KIN_FW_EXTRA_OBJ.elementor.extWrapperLink();
        },
        extWrapperLink: function() {
            $window.on('elementor/frontend/init', function(){
                $('body').on("click",".kinfw-js-element-cover-link",function(e){
                    e.preventDefault();

                    var $ele      = $(this),
                        $id       = "#kinfw-js-element-cover-link-" + $ele.attr("data-id"),
                        $settings = $ele.data("kinfw-cover-link-settings");

                    if( $($id).length === 0 ) {
                        $('body').append(
                            $(document.createElement('a')).prop({
                                target: $settings.is_external ? '_blank' : '_self',
                                href  : $settings.url,
                                class : 'hidden',
                                id    : $id.replace("#",""),
                                rel   : $settings.nofollow ? 'nofollow noreferer' : '',
                                innerText:$id
                            })
                        );
                    }

                    $($id)[0].click();
                });
            });
        },
    };

    KIN_FW_EXTRA_OBJ.elementor.imageRevealExt = {
        bindEvents:function(){
            if( this.getElementSettings('enable_img_reveal') ) {
                gsap.registerPlugin(ScrollTrigger);

                let $ease = this.getElementSettings('img_revel_anim'),
                    $dir  = this.getElementSettings('img_revel_dir'),
                    $ele  = this.$element,
                    $cont = $ele.find(".elementor-widget-container"),
                    $img  = $ele.find("img");

                gsap.set( $ele, { overflow:'hidden' } );
                gsap.set( $cont, {
                    autoAlpha : 1,
                    overflow  : 'hidden',
                    visibility: 'hidden',
                    display   : 'block',
                    transition: 'none',
                } );

                let $tl = gsap.timeline({
                    scrollTrigger: {
                        trigger      : $ele,
                        start        : "top 50%",
                        toggleActions: "play none none none",
                    }
                });

                let $cont_obj = {
                    ease : $ease
                };

                let $img_obj = {
                    scale   : 1.3,
                    delay   : -1.5,
                    ease    : $ease
                };

                switch( $dir ) {
                    case 'right':
                        $cont_obj.xPercent = 100;
                        $img_obj.xPercent  = -100;
                    break;

                    case 'bottom':
                        $cont_obj.yPercent = 100;
                        $img_obj.yPercent  = -100;
                    break;

                    case 'top':
                        $cont_obj.yPercent = -100;
                        $img_obj.yPercent  = 100;
                    break;

                    default:
                    case 'left':
                        $cont_obj.xPercent = -100;
                        $img_obj.xPercent  = 100;
                    break;
                }

                $tl.from($cont, 1.5, $cont_obj );
                $tl.from($img, 1.5, $img_obj );
            }
        }
    };

    KIN_FW_EXTRA_OBJ.elementor.hoverImageExt = {
        bindEvents:function(){
            if( this.getElementSettings( 'use_kf_ele_h_img' ) ) {
                let $ele = this.$element,
                    $hImg = $ele.find(".kinfw-hover-img-ext");
                if( $hImg.length === 0 ) {
                    $ele.append("<div class='kinfw-hover-img-ext'></div>");
                    $hImg = $ele.find(".kinfw-hover-img-ext");
                    gsap.to( $hImg, { delay:0, duration:0, autoAlpha:0 });
                }

                gsap.set($hImg,{
                    position:'absolute',
                    width:'250',
                    height:'350',
                    transition: 'opacity .2s, transform .8s cubic-bezier(.23,.66,.83,1)',
                    objectFit:'cover',
                    left:0,
                    top:'-50%',
                    zIndex: 1,
                });

                $ele.mouseenter(function(){
                    gsap.to( $hImg, { delay:0, duration:0, autoAlpha:1 });
                });

                $ele.mouseleave(function(){
                    gsap.to( $hImg, { delay:0, duration:0, autoAlpha:0 });
                });

                $ele.mousedown(function(){
                    gsap.to( $hImg, {scale:0.75});
                });

                $ele.mouseup(function(){
                    gsap.to( $hImg, {scale:1});
                });

                $ele.mousemove(function($e){
                    const $target = $($ele);

                    var $bound = $target.get(0).getBoundingClientRect(),
                        x = $e.clientX - $bound.x,
                        y = $e.clientY - $bound.y;

                    gsap.set( $hImg, {
                        x        : x ,
                        y        : y,
                        delay    : 0,
                        duration : 0,
                    } );
                });
            }
        }
    };

    KIN_FW_EXTRA_OBJ.elementor.shapeShiftExt = {
        bindEvents:function(){
            if( this.getElementSettings( 'use_kf_ele_shape_shift' ) ) {
                let $from               = this.getElementSettings('kf_ele_shape_shift_from_inset');
                let $from_border_radius = this.getElementSettings('kf_ele_shape_shift_from_border_radius');

                let $to               = this.getElementSettings('kf_ele_shape_shift_to_inset');
                let $to_border_radius = this.getElementSettings('kf_ele_shape_shift_to_border_radius');

                let $fromClipPath = this._insetClipPath( $from, $from_border_radius );
                let $toClipPath   = this._insetClipPath( $to, $to_border_radius );

                if( $fromClipPath.length > 0 && $toClipPath.length > 0 ) {
                    gsap.registerPlugin(ScrollTrigger);

                    let $ele = this.$element;
                    let $mm  = gsap.matchMedia();

                    // this setup code only runs when viewport is at least 768px wide
                    $mm.add("(min-width: 768px)",function(){
                        let $tl = gsap.timeline({
                            scrollTrigger: {
                                trigger: $ele,
                                start  : "top 75%",
                                end    : "+=500px",
                                scrub  : 1,
                                markers: false,
                            },
                            defaults     : { ease: "none" }
                        });

                        $tl.fromTo($ele,
                            { clipPath: $fromClipPath  },
                            { clipPath: $toClipPath  },
                        );
                    });
                }
            }
        },
        _insetClipPath: function( margin, borderRadius ) {
            // Check if margin values are provided and not empty
            const hasValidMargin = Object.keys(margin).every(key =>
                margin[key] !== "" && margin[key] !== undefined && margin[key] !== null
            );

            // If margin values are invalid, return false
            if (!hasValidMargin) {
                return '';
            }

            const { unit, top, right, bottom, left } = margin;
            const marginValues = `${top}${unit} ${right}${unit} ${bottom}${unit} ${left}${unit}`;

            let clipPath = `inset(${marginValues})`;

            // Check if borderRadius values are provided and not empty
            const hasValidBorderRadius = Object.keys(borderRadius).every(key =>
                borderRadius[key] !== "" && borderRadius[key] !== undefined && borderRadius[key] !== null
            );

            if (hasValidBorderRadius) {
                const borderRadiusValues = `${borderRadius.top}${borderRadius.unit} ${borderRadius.right}${borderRadius.unit} ${borderRadius.bottom}${borderRadius.unit} ${borderRadius.left}${borderRadius.unit}`;
                clipPath = `inset(${marginValues} round ${borderRadiusValues})`;
            }

            return clipPath;
        },
    };

    KIN_FW_EXTRA_OBJ.documentOnReady = {
        init: function() {
            KIN_FW_EXTRA_OBJ.elementor.init();

            $window.on('elementor/frontend/init',(function(){
                let moduleHandler = elementorModules.frontend.handlers.Base;

                elementorFrontend.hooks.addAction("frontend/element_ready/widget",function($scope){
                    elementorFrontend.elementsHandler.addHandler( moduleHandler.extend( KIN_FW_EXTRA_OBJ.elementor.imageRevealExt ), {$element:$scope} );
                });

                elementorFrontend.hooks.addAction("frontend/element_ready/container",function($scope){
                    elementorFrontend.elementsHandler.addHandler( moduleHandler.extend( KIN_FW_EXTRA_OBJ.elementor.hoverImageExt ), {$element:$scope} );
                    elementorFrontend.elementsHandler.addHandler( moduleHandler.extend( KIN_FW_EXTRA_OBJ.elementor.shapeShiftExt ), {$element:$scope} );
                });

                elementorFrontend.hooks.addAction("frontend/element_ready/section",function($scope){
                    elementorFrontend.elementsHandler.addHandler( moduleHandler.extend( KIN_FW_EXTRA_OBJ.elementor.hoverImageExt ), {$element:$scope} );
                    elementorFrontend.elementsHandler.addHandler( moduleHandler.extend( KIN_FW_EXTRA_OBJ.elementor.shapeShiftExt ), {$element:$scope} );
                });

                elementorFrontend.hooks.addAction("frontend/element_ready/column",function($scope){
                    elementorFrontend.elementsHandler.addHandler( moduleHandler.extend( KIN_FW_EXTRA_OBJ.elementor.hoverImageExt ), {$element:$scope} );
                });
            }));
        },
    },

    $(document).ready( KIN_FW_EXTRA_OBJ.documentOnReady.init );
})(jQuery);
