<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Demo_Importer' ) ) {

	/**
	 * Define the demo content importer plugin compatibility.
	 */
    class KinForce_Extra_Demo_Importer {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            if (defined('FW')) {
                return;
            }

            require_once KFE_CONST_DIR . 'libraries/demo-content-importer/unyson/bootstrap.php';

            register_activation_hook( __FILE__, [ $this, '_action_fw_plugin_activate' ] );

            add_action( 'current_screen', [ $this, '_action_fw_plugin_check_if_was_activated' ], 999 );
            add_action( 'delete_blog',[ $this, '_action_fw_delete_blog' ], 10, 2 );
            add_action( 'fw_before_init', [ $this, '_action_fw_textdomain' ], 3 );
            add_filter( 'fw_tmp_dir', [ $this, '_filter_fw_tmp_dir' ] );

            require_once KFE_CONST_DIR . 'libraries/demo-content-importer/class-unyson-update-hooks.php';

        }

		public function _action_fw_plugin_activate() {
			update_option( '_fw_plugin_activated', true, false ); // add special option (is used in another action)

			// @see framework/bootstrap.php
			// must not be loaded
			if ( did_action( 'after_setup_theme' ) && ! did_action( 'fw_init' ) ) {
				_action_init_framework(); // load (prematurely) the plugin
				do_action( 'fw_plugin_activate' );
			}
		}

        public function _action_fw_plugin_check_if_was_activated() {
			if (get_option('_fw_plugin_activated')) {
				delete_option('_fw_plugin_activated');

				do_action('fw_after_plugin_activate');
			}
        }

		/**
		 * @param int $blog_id Blog ID
		 * @param bool $drop True if blog's table should be dropped. Default is false.
		 * @internal
		 */
        public function _action_fw_delete_blog( $blog_id, $drop ) {
			if ($drop) {
				global $wpdb; /** @var WPDB $wpdb */

				// delete old termmeta table
				$wpdb->query("DROP TABLE IF EXISTS `{$wpdb->prefix}fw_termmeta`;");
			}
        }

		/** @internal */
		function _action_fw_textdomain() {
			load_plugin_textdomain( 'fw', false, plugin_basename( dirname( __FILE__ ) ) . '/framework/languages' );
		}

        public function _filter_fw_tmp_dir( $dir ) {
			/**
			 * Some users force WP_Filesystem to use the 'direct' method <?php define( 'FS_METHOD', 'direct' ); ?> and set chmod 777 to the unyson/ plugin.
			 * By default tmp dir is WP_CONTENT_DIR.'/tmp' and WP_Filesystem can't create it with 'direct' method, then users can't download and install extensions.
			 * In order to prevent this situation, create the temporary directory inside the plugin folder.
			 */
			return dirname( __FILE__ ) . '/tmp';
        }
    }
}

if( !function_exists( 'kf_extra_plugin_demo_importer' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_demo_importer() {

        return KinForce_Extra_Demo_Importer::get_instance();
    }
}

kf_extra_plugin_demo_importer();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */