(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_CPT_Project_Template;

        KFW_CPT_Project_Template = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main  : '.kfw-ele-widget-cpt-project-tpl-main',
                    }
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main  : this.$element.find( main ),
                }
            },


            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                let $this = this,
                    $id   = $this.getID();
                    $main = $this.elements.$main;

                let $isotope = $main.hasClass('kfw-ele-widget-cpt-project-tpl-masonry');

                if( $this._isBool( $isotope ) === true ) {
                    let $wrap = $( ".kinfw-project-posts-wrap", $main );

                    if( $this._isBool( $wrap.length ) === true ) {
                        $wrap.isotope({
                            itemSelector   : ".kinfw-masonry-item",
                            percentPosition: true,
                            masonry        : {
                                columnWidth: '.kinfw-project-grid-sizer'
                            },
                        });
                    }
                }
            },

            _isBool($arg ) {
                switch( $arg ) {
                    case true:
                    case "true":
                    case "TRUE":
                    case 1:
                    case "1":
                    case "on":
                    case "ON":
                    case "yes":
                    case "YES":
                    case "right":
                    case "RIGHT":
                        return true;

                    default:
                        return false;
                }
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-cpt-project-template', KFW_CPT_Project_Template );
    });
})( jQuery, window.elementorFrontend );