(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Image_Comparison;

        KFW_Image_Comparison = moduleHandler.extend({

            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                var $wrapper  = this.findElement('.kfw-elementor-widget-image-comparision-wrapper'),
                    $settings = $wrapper.data( 'settings' ) || {};

                $wrapper.imagesLoaded(function(){
                    $wrapper.KinForceTwentyTwenty({
                        show_before_label          : $settings.show_before_label,
                        before_label_position      : $settings.before_label_position,
                        before_label               : $settings.before_label,
                        show_after_label           : $settings.show_after_label,
                        after_label_position       : $settings.after_label_position,
                        after_label                : $settings.after_label,
                        orientation                : $settings.orientation,
                        default_offset_pct         : $settings.offset,
                        move_slider_on_hover       : $settings.slider_on_hover,
                        move_with_handle_only      : $settings.slider_with_handle,
                        click_to_move              : $settings.slider_with_click,
                        show_drag_handle           : $settings.show_drag_handle,
                        show_drag_handle_separator : $settings.show_drag_handle_separator,
                        arrow                      : $settings.arrow,
                    });
                });

            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-image-comparison', KFW_Image_Comparison );
    });
})( jQuery, window.elementorFrontend );