(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){

        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Image_Hotspot;

        KFW_Image_Hotspot = moduleHandler.extend({
            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                var $id       = this.getID(),
                    $main     = this.findElement('.kfw-elementor-widget-image-hotspots-wrapper'),
                    $wrapper  = $('.kfw-elementor-image-hotspots-wrapper', $main ),
                    $hotspots = $('.kfw-elementor-image-hotspot', $wrapper );

                $hotspots.each(function(){
                    var $hotspot  = $(this),
                        $settings = $hotspot.data('settings') || {};

                    if( !$hotspot.hasClass('kfw-elementor-image-hotspot-has-tooltip') ) {
                        return;
                    }

                    var $content = $( ".kfw-elementor-image-tooltip-content", $hotspot );

                    var $item = $hotspot.tooltipster({
                        animation: $settings.animation,
                        arrow: $settings.arrow,
                        content:$content,
                        contentAsHTML:true,
                        delay:100,
                        position:$settings.position,
                        maxWidth: ( $settings.maxwidth ) ? $settings.maxwidth : null,
                        theme: 'tooltipster-kfw-theme-'.concat( $id ),
                        trigger:$settings.trigger,
                        functionReady: function(origin, tooltip ){
                            var $class = $(tooltip.origin).attr('data-kf-class');
                            $(tooltip.tooltip).addClass( $class );
                        },
                    });

                    if( $settings.active ) {
                        setTimeout(function(){
                            $item.tooltipster('show');
                        }, 600);
                    }
                });
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-image-hotspots', KFW_Image_Hotspot );
    });
})( jQuery, window.elementorFrontend );