(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Magnetic_Btn;

        KFW_Magnetic_Btn = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-magnetic-button-main',
                        mainID : '#kfw-ele-widget-magnetic-button-' + this.getID(),
                    },
                    magneticStrength:500
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main: this.$element.find( main )
                }
            },

            bindEvents: function () {
                let $this = this,
                    $id   = this.getID(),
                    $main = this.elements.$main;


                let $mainID           = $this.getSettings( 'selectors.mainID')
                let $magneticStrength = $this.getSettings( 'magneticStrength' );

                const $mainEle = document.querySelector( $mainID );

                $mainEle.addEventListener('mousemove', function(e){
                    const rect      = $mainEle.getBoundingClientRect();
                    const distanceX = e.clientX - (rect.left + rect.width / 2);
                    const distanceY = e.clientY - (rect.top + rect.height / 2);
                    const $distance = Math.sqrt(distanceX ** 2 + distanceY ** 2);

                    if ($distance < $magneticStrength) {
                        gsap.to($main, {
                            x: distanceX / 5,
                            y: distanceY / 5,
                            duration: 0.3,
                            ease: "power2.out"
                        });
                    }
                });

                $mainEle.addEventListener('mouseleave', function(){
                    gsap.to($mainEle, {
                        x: 0,
                        y: 0,
                        duration: 0.3,
                        ease: "power2.out"
                    });
                });
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-magnetic-button', KFW_Magnetic_Btn );
    });
})( jQuery, window.elementorFrontend );
