(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler    = elementorModules.frontend.handlers.Base,
            KFW_Mega_Menu;

            KFW_Mega_Menu = moduleHandler.extend({
                getDefaultSettings() {
                    return {
                        selectors: {
                            body  : $('body'),
                            main  : '.kfw-ele-widget-mega-menu-main',
                            mmItem: '.menu-item-has-kinfw-mega-menu',
                        }
                    }
                },

                getDefaultElements() {
                    const { main, mmItem, body } = this.getSettings( 'selectors' );

                    return {
                        $main  : this.$element.find( main ),
                        $mmItem: mmItem,
                        $body  : body,
                    }
                },

                bindEvents: function () {
                    this._execute();
                },

                _execute: function() {
                    let $main  = this.elements.$main,
                        $body  = this.elements.$body,
                        $mmEle = this.findElement(this.elements.$mmItem);

                    if( $main.length && $mmEle.length  ) {
                        $mmEle.each(function(){
                            let $thisEle = $(this);

                            if( $thisEle.hasClass('kinfw-megamenu-full-width') ) {
                                let $parent = $thisEle.parents(".kfw-ele-kfw-mega-menu");
                                $(".kinfw-mega-menu-wrap.kinfw-megamenu-full-width", $thisEle ).css({
                                    width: $parent.width(),
                                });
                            } else if( $thisEle.hasClass('kinfw-megamenu-stretch-width') ) {
                                $(".kinfw-mega-menu-wrap.kinfw-megamenu-stretch-width", $thisEle ).css({
                                    width: $body.width(),
                                    left: -$thisEle.offset().left + $body.offset().left,
                                });
                            } else if( $thisEle.hasClass('kinfw-megamenu-container-width') ) {
                                let $parent = $thisEle.closest('.container , .elementor-container, .col-full');

                                if( !$parent.length ) {
                                    $parent = $thisEle.parents(".e-con.e-parent .e-con-inner");
                                }

                                $(".kinfw-mega-menu-wrap.kinfw-megamenu-container-width", $thisEle ).css({
                                    width: $parent.width(),
                                    left: -$thisEle.offset().left + $parent.offset().left + parseInt( $parent.css('padding-left') ),
                                });
                            }
                        });
                    }
                }
            });

            elementorFrontend.elementsHandler.attachHandler( 'kfw-mega-menu', KFW_Mega_Menu );
        });
    })( jQuery, window.elementorFrontend );