(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler    = elementorModules.frontend.handlers.Base,
            KFW_Mobile_Menu;

        KFW_Mobile_Menu = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-mobile-menu-main',
                        activeClass: 'kinfw-mobile-menu-has-visibility'
                    }
                }
            },

            getDefaultElements() {
                const { main, activeClass } = this.getSettings( 'selectors' );

                return {
                    $main: this.$element.find( main ),
                    $activeClass: activeClass
                }
            },

            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                let $id          = this.getID(),
                    $main        = this.elements.$main;

                if( $main.length ) {
                    this._bindMobileMenuTrigger();
                    this._bindOverlayClick();
                    this._bindCloseClick();
                    this._bindBackClick();

                    this._bindMobileSubMenuTrigger();
                }
            },

            _bindMobileMenuTrigger() {
                let $activeClass = this.elements.$activeClass,
                    $menuEle     = this.findElement(".kinfw-mobile-menu-nav"),
                    $openerEle   = this.findElement(".kinfw-mobile-navigation-trigger .kinfw-icon");

                if( $openerEle.length ) {
                    $( $openerEle ).on("click",function($e){
                        $e.preventDefault();
                        $menuEle.toggleClass( $activeClass );
                    });
                }
            },

            _bindOverlayClick() {
                let _self        = this,
                    $menuEle     = _self.findElement(".kinfw-mobile-menu-nav"),
                    $overlayEle  = _self.findElement(".kinfw-mobile-menu-overlay"),
                    $activeClass = _self.elements.$activeClass;

                if( $overlayEle.length ) {
                    $( $overlayEle ).on("click",function($e){
                        $e.preventDefault();
                        $menuEle.toggleClass( $activeClass );
                        _self.findElement("ul.sub-menu").addClass("sub-menu-hidden");
                        _self.findElement("li.kinfw-sub-menu-active").removeClass("kinfw-sub-menu-active");
                    });
                }
            },

            _bindCloseClick() {
                const _self = this;

                let $closeEle    = _self.findElement(".kinfw-mobile-menu-close"),
                    $menuEle     = _self.findElement(".kinfw-mobile-menu-nav"),
                    $activeClass = _self.elements.$activeClass;

                if( $closeEle.length ) {
                    $( $closeEle ).on("click",function($e){
                        $e.preventDefault();
                        $menuEle.toggleClass( $activeClass );
                        _self.findElement("ul.sub-menu").addClass("sub-menu-hidden");
                        _self.findElement("li.kinfw-sub-menu-active").removeClass("kinfw-sub-menu-active");
                    });
                }
            },

            _bindBackClick() {
                let $backEle = this.findElement(".kinfw-mobile-menu-back");

                if( $backEle.length ) {
                    $( $backEle ).on("click",function($e){
                        $e.preventDefault();

                        $(this).parent("ul.sub-menu").addClass("sub-menu-hidden");
                        $(this).parent("ul.sub-menu").parent("li.menu-item-has-children").removeClass("kinfw-sub-menu-active");
                    });
                }
            },

            _bindMobileSubMenuTrigger() {
                let $subMenuOpenerEle = this.findElement(".kinfw-sub-menu-trigger");

                if( $subMenuOpenerEle.length ) {
                    $( $subMenuOpenerEle ).on("click",function($e){
                        $e.preventDefault();

                        $(this).next("ul.sub-menu").removeClass("sub-menu-hidden");
                        $(this).parent("li.menu-item-has-children").addClass("kinfw-sub-menu-active");
                    });
                }
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-mobile-menu', KFW_Mobile_Menu );
    });
})( jQuery, window.elementorFrontend );