(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
        KFW_PT;

        KFW_PT = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        numberEle          : '.kfw-ele-pricing-table-price-numeric',
                        fractionalNumberEle: '.kfw-ele-pricing-table-price-fractional',
                    }
                }
            },

            getDefaultElements() {
                const selectors = this.getSettings( 'selectors' );
                return {
                    $numberEle          : this.$element.find( selectors.numberEle ),
                    $fractionalNumberEle: this.$element.find( selectors.fractionalNumberEle ),
                };
            },

            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                const _self = this;

                if( _self.elements.$numberEle.length ) {

                    _self.elements.$numberEle.each(function(){
                        let $ele = $(this);

                        _self.intersectionObserver = elementorModules.utils.Scroll.scrollObserver({
                            callback: ( event ) => {
                                if ( event.isInViewport ) {
                                    _self.intersectionObserver.unobserve( $ele[ 0 ] );

                                    $ele.numerator({
                                        duration: 1000,
                                        toValue : $ele.data('toval'),
                                        rounding: $ele.data('round'),
                                    });
    
                                }
                            },
                        });

                        _self.intersectionObserver.observe( $ele[ 0 ] );
                    });
                }

                if( _self.elements.$fractionalNumberEle.length ) {
                    _self.elements.$fractionalNumberEle.each(function(){
                        let $ele = $(this);

                        _self.intersectionObserver = elementorModules.utils.Scroll.scrollObserver({
                            callback: ( event ) => {
                                if ( event.isInViewport ) {
                                    _self.intersectionObserver.unobserve( $ele[ 0 ] );

                                    $ele.numerator({
                                        duration: 1000,
                                        toValue : $ele.data('toval'),
                                    });
    
                                }
                            },
                        });

                        _self.intersectionObserver.observe( $ele[ 0 ] );
                    });                    
                }
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-pricing-table', KFW_PT );
    });
})( jQuery, window.elementorFrontend );
