(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler        = elementorModules.frontend.handlers.Base,
            KFW_Progressbar_Line;

        KFW_Progressbar_Line = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        wrapper: '.kfw-ele-widget-pbar-line-wrapper'
                    }
                }
            },

            getDefaultElements() {
                const { wrapper } = this.getSettings( 'selectors' );

                return {
                    $wrapper : this.$element.find( wrapper ),
                    $bar: this.findElement('.kfw-ele-widget-pbar-line-bar'),
                }
            },


            bindEvents: function () {
                /**
                 * New elementor 3.24.0 +
                 * Replaced waypoints.js library with the native Intersection Observer API
                 */
                this.elements.$bar.css({'width': '0%'});
                const observer = this._createObserver();
                observer.observe( this.elements.$bar[0] );

                /**
                 * Older Elementor 3.20 uses waypoint script
                 */
                //this._execute();
            },

            _createObserver() {
                var $wrapperSettings = this.elements.$wrapper.data('settings') || {};

                const options = {
                    root      : null,
                    threshold : 0,
                    rootMargin: '0px',
                };

                return new IntersectionObserver( ( entries ) => {
                    entries.forEach( ( entry ) => {
                        if ( entry.isIntersecting ) {
                            this.elements.$bar.css("width", $wrapperSettings.percent);
                        }
                    });
                }, options );
            },

            _execute: function() {
                var $mainSettings    = this.getElementSettings();
                var $wrapperSettings = this.elements.$wrapper.data('settings') || {};

                this.elements.$bar.css({'width': '0%'});

                elementorFrontend.waypoint( this.elements.$bar, function(){
                    var $this = $(this);
                    $this.css("width", $wrapperSettings.percent);
                }, { offset: '90%' });
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-progress-bar-line', KFW_Progressbar_Line );
    });
})( jQuery, window.elementorFrontend );