(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler     = elementorModules.frontend.handlers.Base,
        KFW_Site_Logo;

        KFW_Site_Logo = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-site-logo-main'
                    }
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main             : this.$element.find( main ),
                    $svg              : this.findElement('.kinfw-switch-svg'),
                    $beforeSvgEleClass: "kinfw-switch-svg",
                    $afterSvgEleClass : "kinfw-switched-svg"
                }
            },

            bindEvents: function () {
                let $this   = this,
                    $isEdit = $this.isEdit ? true : false;

                if( $isEdit ) {
                    $this._execute();
                }
            },

            _execute() {
                let $svgEleClass      = this.elements.$beforeSvgEleClass;
                let $afterSvgEleClass = this.elements.$afterSvgEleClass;

                this.elements.$svg.each(function(){
                    let $imgTag = $(this),
                        $id     = $imgTag.attr("id"),
                        $class  = $imgTag.attr('class'),
                        $src    = $imgTag.attr("src");

                    $.get($src, function($data){

                        // Get the SVG tag, ignore the rest
                        let $svg = $($data).find('svg');

                        // Add replaced image's ID to the new SVG
                        if(typeof $id !== 'undefined') {
                            $svg = $svg.attr('id', $id);
                        }

                        // Add replaced image's ID to the new SVG
                        if(typeof $class !== 'undefined') {
                            let $classes = $class.replace($svgEleClass, " ").concat( $afterSvgEleClass );
                            $svg = $svg.attr('class', $classes );
                        }

                        // Remove any invalid XML tags as per http://validator.w3.org
                        $svg = $svg.removeAttr('xmlns:a');

                        // Check if the viewport is set, else we gonna set it if we can.
                        if(!$svg.attr('viewBox') && $svg.attr('height') && $svg.attr('width')) {
                            $svg.attr('viewBox', '0 0 ' + $svg.attr('height') + ' ' + $svg.attr('width'))
                        }

                        // Replace image with new SVG
                        $imgTag.replaceWith($svg);
                    });
                });
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-site-logo', KFW_Site_Logo );
    });
})( jQuery, window.elementorFrontend );
