(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Video_Popup_Button;

            KFW_Video_Popup_Button = moduleHandler.extend({
                getDefaultSettings() {
                    return {
                        selectors: {
                            main : '.kfw-ele-widget-video-popup-button-main',
                        }
                    }
                },
                getDefaultElements() {
                    const { main } = this.getSettings( 'selectors' );

                    return {
                        $main : this.$element.find( main ),
                    }
                },
                bindEvents: function () {
                    if( typeof( $.fn.magnificPopup ) !== 'function' ) {
                        return;
                    }

                    this._execute();
                },
                _execute: function() {
                    let $this  = this,
                        $id    = $this.getID(),
                        $main  = $this.elements.$main,
                        $cta   = $this.findElement(".kfw-ele-widget-video-popup-button-cta"),
                        $popup = $cta.data('popup') || {};

                    if( $cta.hasClass( "kfw-ele-widget-video-popup-button-iframe" ) ) {
                        $popup.callbacks = {
                            open : function(){
                                $("body").find(".mfp-close").addClass("kfw-mfp-close");
                                window.dispatchEvent(new Event("resize"));
                            },
                            close: function(){
                                $("body").find(".mfp-close").removeClass("kfw-mfp-close");
                            },
                        };
                        $popup.iframe    = {
                            markup  : '<div class="mfp-iframe-scaler"><div class="mfp-close"></div><iframe class="mfp-iframe kfw-mfp-iframe" frameborder="0" allowfullscreen></iframe></div>',
                            patterns: {
                                youtube: {
                                    index: "https://youtube.com/",
                                    id   : "v=",
                                    src  : "%id%"
                                }
                            }
                        };

                        $cta.magnificPopup($popup);
                    } else if( $cta.hasClass( "kfw-ele-widget-video-popup-button-inline" ) ) {
                        $cta.magnificPopup($popup);
                    }
                },
            });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-video-popup-button', KFW_Video_Popup_Button );
    });
})( jQuery, window.elementorFrontend );