<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Controls_Manager' ) ) {

	/**
	 * Elementor controls setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Controls_Manager {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'elementor/controls/register', [ $this, 'register_controls' ] );

            do_action( 'kinfw-action/plugin/elementor/controls/loaded' );

		}

        public function register_controls( $controls_manager ) {

			require_once KFE_CONST_DIR . 'libraries/elementor/controls/class-group-control-motion-fx.php';

            $controls_manager->add_group_control(
                \KFW_Elementor\Controls\Group_Control_Motion_Fx::get_type(),
                new \KFW_Elementor\Controls\Group_Control_Motion_Fx()
            );
        }

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_controls_manager' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_controls_manager() {

        return KinForce_Extra_Plugin_Elementor_Controls_Manager::get_instance();
    }
}

kf_extra_plugin_elementor_controls_manager();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */