<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Effects_Image_Reveal' ) ) {
	/**
	 * Elementor Image Reveal Effect setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Effects_Image_Reveal {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        public $elements;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            /**
             * Elements to add Image Revel Effect
             */
            $this->elements = apply_filters( 'kinfw-filter/plugin/elementor/image-reveal-effect/elements', [
                [
                    'name'    => 'image',
                    'section' => 'section_image',
                ]
            ] );

            foreach( $this->elements as $element ) {
                add_action( 'elementor/element/' . $element['name'] . '/' . $element['section'] . '/after_section_end',
                    [ $this, 'register_img_reveal_section' ], 10, 2 );
            }
        }

        public function register_img_reveal_section( $controls_stack, $section_id ) {
            $ele_name = $controls_stack->get_name();

            $controls_stack->start_controls_section( 'kfw_section_img_reveal_effect', [
                'label' => sprintf( __( '%s : Image Reveal Effect', 'onnat-extra'), $ele_name ),
            ] );
                $controls_stack->add_control( 'enable_img_reveal', [
                    'label'              => esc_html__( 'Enable?', 'onnat-extra' ),
                    'type'               => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'           => esc_html__( 'Yes', 'onnat-extra' ),
                    'label_off'          => esc_html__( 'No', 'onnat-extra' ),
                    'frontend_available' => true,
                    'return_value'       => 'yes',
                    'prefix_class'       => 'kfw-ele-img-reveal-',
                ] );
                $controls_stack->add_control( 'img_revel_dir', [
                    'label'              => esc_html__( 'Reveal Direction From?', 'onnat-extra' ),
                    'type'               => \Elementor\Controls_Manager::CHOOSE,
                    'options'            => [
                        'top'    => [
                            'title' => esc_html__( 'Top', 'onnat-extra' ),
                            'icon'  => 'eicon-arrow-down',
                        ],
                        'right'  => [
                            'title' => esc_html__( 'Right', 'onnat-extra' ),
                            'icon'  => 'eicon-arrow-left',
                        ],
                        'bottom' => [
                            'title' => esc_html__( 'Bottom', 'onnat-extra' ),
                            'icon'  => 'eicon-arrow-up',
                        ],
                        'left'   => [
                            'title' => esc_html__( 'Left', 'onnat-extra' ),
                            'icon'  => 'eicon-arrow-right',
                        ],
                    ],
                    'default'            => 'left',
                    'frontend_available' => true,
                    'condition'          => [ 'enable_img_reveal!' => '' ],
                ] );
                $controls_stack->add_control( 'img_revel_anim', [
                    'label'              => esc_html__( 'Animation?', 'onnat-extra' ),
                    'type'               => \Elementor\Controls_Manager::SELECT,
                    'default'            => 'none',
                    'options'            => [
                        'back'       => esc_html__( 'Back', 'onnat-extra' ),
                        'bounce'     => esc_html__( 'Bounce', 'onnat-extra' ),
                        'elastic'    => esc_html__( 'Elastic', 'onnat-extra' ),
                        'expo'       => esc_html__( 'Expo', 'onnat-extra' ),
                        'power1.out' => esc_html__( 'Power 1', 'onnat-extra' ),
                        'power2.out' => esc_html__( 'Power 2', 'onnat-extra' ),
                        'power3.out' => esc_html__( 'Power 3', 'onnat-extra' ),
                        'power4.out' => esc_html__( 'Power 4', 'onnat-extra' ),
                        'sine'       => esc_html__( 'Sine', 'onnat-extra' ),
                        "none"       => esc_html__( 'None', 'onnat-extra' ),
                    ],
                    'frontend_available' => true,
                    'condition'          => [ 'enable_img_reveal!' => '' ],
                ]);
            $controls_stack->end_controls_section();
        }
    }

}

if( !function_exists( 'kf_extra_plugin_elementor_effects_image_reveal' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_effects_image_reveal() {

        return KinForce_Extra_Plugin_Elementor_Effects_Image_Reveal::get_instance();
    }
}

kf_extra_plugin_elementor_effects_image_reveal();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */