<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Modules_Manager' ) ) {

	/**
	 * Elementor modules setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Modules_Manager {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'elementor/init', [ $this, 'init' ] );

			add_action( 'kinfw-action/theme/site-options/elementor/loaded', [ $this, 'settings' ], 100  );

            do_action( 'kinfw-action/plugin/elementor/modules/loaded' );

		}

        public function init() {

			add_action( 'elementor/elements/categories_registered', [ $this, 'register_category' ], 10 );
			add_action( 'elementor/widgets/register', [ $this, 'register_widget' ] );

		}

        /**
         * Add elementor widget category
         */
        public function register_category( $elements_manager  ) {

			$categories     = [];
			$old_categories = $elements_manager->get_categories();

			if( is_singular('kinfw-header') || is_singular('kinfw-footer') ) {
				$categories['_kfw_header_footer_widgets'] = [
					'title' => esc_html__( 'KinForce - Header & Footer Widgets', 'onnat-extra' ),
					'icon'  => 'eicon-font',
				];
			}

			$categories['_kfw_core_widgets'] =[
				'title' => esc_html__( 'KinForce - General', 'onnat-extra' ),
				'icon'  => 'eicon-font',
			];

			$categories['_kfw_theme_widgets'] =[
				'title' => esc_html__( 'KinForce - Theme', 'onnat-extra' ),
				'icon'  => 'eicon-font'
			];

			$categories     = array_merge($categories, $old_categories);
			$set_categories = function ( $categories ) {
				$this->categories = $categories;
			};

			$set_categories->call( $elements_manager, $categories );
		}

		public function widgets_list() {

			$widgets = [];

			/**
			 * Base Widget
			 */
				$widgets[1] = [
					'class'    => 'KFW_Accordion',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-accordion.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_accordion',
						'title'   => esc_html__( 'Accordion', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Custom Accordion elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[2] = [
					'class'    => 'KFW_Airborne_Elements',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-airborne-elements.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_airborne_elements',
						'title'   => esc_html__( 'Airborne Elements', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Custom Airborne elemnts elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[3] = [
					'class'    => 'KFW_Interactive_Accordion',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-interactive-accordion.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_interactive_accordion',
						'title'   => esc_html__( 'Interactive Accordion', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Interactive Accordion elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[4] = [
					'class'    => 'KFW_Button',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-button.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_button',
						'title'   => esc_html__( 'Button', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Custom Button elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[5] = [
					'class'    => 'KFW_Magnetic_Button',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-magnetic-button.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_magnetic_button',
						'title'   => esc_html__( 'Magnetic Button', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Magnetic Button elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[6] = [
					'class'    => 'KFW_Ripple_Button',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-ripple-button.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_ripple_button',
						'title'   => esc_html__( 'Ripple Button', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Custom Ripple Button elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[7] = [
					'class'    => 'KFW_Blockquote',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blockquote.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_blockquote',
						'title'   => esc_html__( 'Blockquote', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Simple Blockquote elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[8] = [
					'class'    => 'KFW_Content_Switch',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-content-switch.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_content_switch',
						'title'   => esc_html__( 'Content Switch', 'onnat-extra'),
						'desc'    => esc_html__( 'Switching content based on the toggle state elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[12] = [
					'class'    => 'KFW_Content_Carousel',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-content-carousel.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_content_carousel',
						'title'   => esc_html__( 'Content Carousel', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Content Carousel elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[13] = [
					'class'    => 'KFW_Custom_List',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-custom-list.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_custom_list',
						'title'   => esc_html__( 'Custom List', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Custom List elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[14] = [
					'class'    => 'KFW_Custom_Heading',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-custom-heading.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_custom_heading',
						'title'   => esc_html__( 'Custom Heading', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Custom Heading elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[15] = [
					'class'    => 'KFW_Custom_Text',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-custom-text.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_custom_text',
						'title'   => esc_html__( 'Custom Text', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Custom Text elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[16] = [
					'class'    => 'KFW_Text_Highlighter',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-text-highlighter.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_text_highlighter',
						'title'   => esc_html__( 'Text Highlighter', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our text highlighter elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[19] = [
					'class'    => 'KFW_Interactive_Image',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-interactive-image.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_interactive_image',
						'title'   => esc_html__( 'Interactive Image', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Interactive Comparison elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[20] = [
					'class'    => 'KFW_Image_Comparison',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-image-comparison.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_image_comparison',
						'title'   => esc_html__( 'Image Comparison', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Image Comparison elementor widgets.', 'onnat-extra' ),
						'default' => true,
					]
				];

				$widgets[30] = [
					'class'    => 'KFW_Image_Hotspots',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-image-hotspots.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_image_hotspots',
						'title'   => esc_html__( 'Image Hotspots', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Image Hotspots elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[40] = [
					'class'    => 'KFW_Image_Accordion',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-image-accordion.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_image_accordion',
						'title'   => esc_html__( 'Image Accordion', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Image Accordion elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[50] = [
					'class'    => 'KFW_Progressbar_Line',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-progressbar-line.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_progressbar_line',
						'title'   => esc_html__( 'Progress Bar Line', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Progress Bar Line elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[60] = [
					'class'    => 'KFW_Progressbar_Circle',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-progressbar-circle.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_progressbar_circle',
						'title'   => esc_html__( 'Progress Bar Circle', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Progress Bar Circle elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[70] = [
					'class'    => 'KFW_Image_Expand',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-image-expand.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_image_expand',
						'title'   => esc_html__( 'Image Expand', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Image Expand elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[80] = [
					'class'    => 'KFW_Counter_Minimal',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-counter-minimal.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_counter_minimal',
						'title'   => esc_html__( 'Counter Minimal', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Minimal Counter elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				/**
				 * Pricing Table
				 */
				$widgets[85] = [
					'class'    => 'KFW_Pricing_Table',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-pricing-table.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_pricing_table',
						'title'   => esc_html__( 'Pricing Table', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Pricing Table elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];				

				/**
				 * Pricing Table 1
				 */
				$widgets[90] = [
					'class'    => 'KFW_Pricing_Table_Basic',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-pricing-table-basic.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_pricing_table_basic',
						'title'   => esc_html__( 'Pricing Table Basic', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Basic Pricing Table elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				/**
				 * Pricing Table 2
				 */
				$widgets[100] = [
					'class'    => 'KFW_Pricing_Table_Simple',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-pricing-table-simple.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_pricing_table_simple',
						'title'   => esc_html__( 'Pricing Table Simple', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Simple Pricing Table elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				/**
				 * Pricing Table 3
				 */
				$widgets[110] = [
					'class'    => 'KFW_Pricing_Table_Shape_Header',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-pricing-table-shape-header.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_pricing_table_shape_header',
						'title'   => esc_html__( 'Pricing Table Shape Header', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Shaped Header Pricing Table elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				/**
				 * Pricing Table 4
				 */
				$widgets[120] = [
					'class'    => 'KFW_Pricing_Table_Clean',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-pricing-table-clean.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_pricing_table_clean',
						'title'   => esc_html__( 'Pricing Table Clean', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Clean Pricing Table elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				/**
				 * Pricing Table 5
				 */
				$widgets[130] = [
					'class'    => 'KFW_Pricing_Table_Unique',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-pricing-table-unique.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_pricing_table_unique',
						'title'   => esc_html__( 'Pricing Table Unique', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Unique Pricing Table elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[140] = [
					'class'    => 'KFW_Flip_Box_Minimal',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-flip-box-minimal.php',
					'enable'   => true,
					'settings' => [
						'type' => 'switcher',
						'id'      => 'kfw_flip_box_minimal',
						'title'   => esc_html__( 'Flip Box Minimal', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Flip Box Minimal elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[150] = [
					'class'    => 'KFW_Flip_Box_Cover',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-flip-box-cover.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_flip_box_cover',
						'title'   => esc_html__( 'Flip Box Cover', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Flip Box Cover elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[160] = [
					'class'    => 'KFW_Flip_Box_Cube',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-flip-box-cube.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_flip_box_cube',
						'title'   => esc_html__( 'Flip Box Cube', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Flip Box Cube elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[170] = [
					'class'    => 'KFW_Icon_Box',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-icon-box.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_icon_box',
						'title'   => esc_html__( 'Icon Box', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Icon Box elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[180] = [
					'class'    => 'KFW_Lottie_Icon_Box',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-lottie-icon-box.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_lottie_icon_box',
						'title'   => esc_html__( 'Icon Box : Lottie', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Lottie Icon Box elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[190] = [
					'class'    => 'KFW_Lordicon_Icon_Box',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-lordicon-icon-box.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_lordicon_icon_box',
						'title'   => esc_html__( 'Icon Box : Lordicon', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Lordicon Icon Box elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[200] = [
					'class'    => 'KFW_Tabs',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-tabs.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_tabs',
						'title'   => esc_html__( 'Tabs', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Tabs elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[210] = [
					'class'    => 'KFW_Rounded_Text',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-rounded-text.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_rounded_text',
						'title'   => esc_html__( 'Rounded Text', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Rounded Text elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[220] = [
					'class'    => 'KFW_Marquee_Text',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-marquee-text.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_marquee_text',
						'title'   => esc_html__( 'Marquee Text', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Marquee Text elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[230] = [
					'class'    => 'KFW_Image_Stack',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-image-stack.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_image_stack',
						'title'   => esc_html__( 'Image Stack', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Image Stack elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[240] = [
					'class'    => 'KFW_Brands_Grid',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-brands-grid.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_brands_grid',
						'title'   => esc_html__( 'Brands Grid', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Brands Grid elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[250] = [
					'class'    => 'KFW_Brands_Carousel',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-brands-carousel.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_brands_carousel',
						'title'   => esc_html__( 'Brands Carousel', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Brands Carousel elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[260] = [
					'class'    => 'KFW_Ad_Banner',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-ad-banner.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_ad_banner',
						'title'   => esc_html__( 'Ad Banner', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Ad Banner elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[270] = [
					'class'    => 'KFW_Instagram',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-instagram.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_instagram',
						'title'   => esc_html__( 'Instagram', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Instagram images elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[280] = [
					'class'    => 'KFW_Mailchimp',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-mailchimp.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_mailchimp',
						'title'   => esc_html__( 'Mailchimp', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Simple Mailchimp subscription form ( Email field only ) elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[290] = [
					'class'    => 'KFW_Mailchimp_Plus',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-mailchimp-plus.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_mailchimp_plus',
						'title'   => esc_html__( 'Mailchimp Plus', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our Mailchimp subscription form ( Name + Email field only ) elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[300] = [
					'class'    => 'KFW_Google_Map',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-google-map.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_google_map',
						'title'   => esc_html__( 'Google Map', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our advanced Google Map elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[310] = [
					'class'    => 'KFW_Video_Popup_Button',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-video-popup-button.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_video_popup',
						'title'   => esc_html__( 'Video Popup Button', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Our video popup button elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[320] = [
					'class'    => 'KFW_Info_List_Minimal',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-info-list-minimal.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_info_list_minimal',
						'title'   => esc_html__( 'Info List Minimal', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Minimal Info List elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[330] = [
					'class'    => 'KFW_Info_Box',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-info-box.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_info_box',
						'title'   => esc_html__( 'Info Box', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Minimal Info Box elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[340] = [
					'class'    => 'KFW_Testimonial_Grid',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-testimonial-grid.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_testimonial_grid',
						'title'   => esc_html__( 'Testimonial Grid', 'onnat-extra'),
						'desc'    => esc_html__( 'Add testimonial grid elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[350] = [
					'class'    => 'KFW_Testimonial_Carousel',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-testimonial-carousel.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_testimonial_carousel',
						'title'   => esc_html__( 'Testimonial Carousel', 'onnat-extra'),
						'desc'    => esc_html__( 'Add testimonial carousel elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[360] = [
					'class'    => 'KFW_Split_Scroll',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-split-scroll.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_split_scroll',
						'title'   => esc_html__( 'Split Scroll Box', 'onnat-extra'),
						'desc'    => esc_html__( 'Add split scroll box elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[370] = [
					'class'    => 'KFW_Split_Scroll_Alt',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-split-scroll-alt.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_split_scroll_alt',
						'title'   => esc_html__( 'Alternate Split Scroll Box', 'onnat-extra'),
						'desc'    => esc_html__( 'Add alternate split scroll box elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[380] = [
					'class'    => 'KFW_Horizontal_Scroll_Element',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-horizontal-scroll-element.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_horiz_scroll_ele',
						'title'   => esc_html__( 'Horizontal Scroll Element', 'onnat-extra'),
						'desc'    => esc_html__( 'Add horizontal scroll element elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

			/**
			 *  Theme Category Widgets
			 */
				$widgets[900] = [
					'class'    => 'KFW_Theme_Button',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-theme-button.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_theme_button',
						'title'   => esc_html__( 'Onnat Button', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Onnat Button elementor widgets.', 'onnat-extra' ),
						'default' => true,
					],
				];

				$widgets[1000] = [
					'class'    => 'KFW_Blog_Grid',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-grid.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_blog_grid',
						'title'   => esc_html__( 'Blog Grid', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Blog Posts in Grid elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[1001] = [
					'class'    => 'KFW_Blog_List',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-list.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_blog_list',
						'title'   => esc_html__( 'Blog List', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Blog Posts in list elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[1010] = [
					'class'    => 'KFW_Blog_Carousel',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-carousel.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_blog_carousel',
						'title'   => esc_html__( 'Blog Carousel', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Blog Posts Carousel elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[1015] = [
					'class'    => 'KFW_CPT_Service_Grid',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-service-grid.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_cpt_service_grid',
						'title'   => esc_html__( 'Service Grid', 'onnat-extra'),
						'desc'    => esc_html__( 'Add CPT Service in Grid elementor widgets.', 'onnat-extra' ),
						'default' => true,
					],
				];

				$widgets[1016] = [
					'class'    => 'KFW_CPT_Service_Vertical',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-service-vertical.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_cpt_service_vertical',
						'title'   => esc_html__( 'Service Vertical', 'onnat-extra'),
						'desc'    => esc_html__( 'Add CPT Service in Vertical elementor widgets.', 'onnat-extra' ),
						'default' => true,
					],
				];

				$widgets[1020] = [
					'class'    => 'KFW_CPT_Team_Member_Grid',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-team-member-grid.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_cpt_team_member_grid',
						'title'   => esc_html__( 'Team Member Grid', 'onnat-extra'),
						'desc'    => esc_html__( 'Add CPT Team Members in Grid elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[1030] = [
					'class'    => 'KFW_CPT_Team_Member_Carousel',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-team-member-carousel.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_cpt_team_member_carousel',
						'title'   => esc_html__( 'Team Member Carousel', 'onnat-extra'),
						'desc'    => esc_html__( 'Add CPT Team Members in Carousel elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[1040] = [
					'class'    => 'KFW_Testimonial_Large_Carousel',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-testimonial-large-carousel.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_large_testimonial_large_carousel',
						'title'   => esc_html__( 'Testimonial Large Carousel', 'onnat-extra'),
						'desc'    => esc_html__( 'Add testimonial carousel elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[1050] = [
					'class'    => 'KFW_Blog_Template',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-template.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_blog_template',
						'title'   => esc_html__( 'Blog Template', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Blog Template in elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[1055] = [
					'class'    => 'KFW_Project_Item',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-project-item.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_project_item',
						'title'   => esc_html__( 'Project Item', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Project Item in elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];				

				$widgets[1060] = [
					'class'    => 'KFW_Project_Template',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-project-template.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_project_template',
						'title'   => esc_html__( 'Project Template', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Project Template in elementor widgets.', 'onnat-extra' ),
						'default' => true
					]
				];

			/**
			 * Header & Footer Widgets
			 */
				$widgets[10000] = [
					'class'    => 'KFW_Site_Logo',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-site-logo.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_site_logo',
						'title'   => esc_html__( 'Site Logo', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Site Logo elementor widgets for Custom Header or Footer.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[10010] = [
					'class'    => 'KFW_Mega_Menu',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-mega-menu.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_mega_menu',
						'title'   => esc_html__( 'Mega Menu', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Mega Menu elementor widgets for Custom Header.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[10050] = [
					'class'    => 'KFW_Header_Action_Icons',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-header-action-icons.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_header_action_icons',
						'title'   => esc_html__( 'Action Icons', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Header Action Icons elementor widgets for Custom Header.', 'onnat-extra' ),
						'default' => true
					]
				];

				$widgets[10100] = [
					'class'    => 'KFW_Mobile_Menu',
					'file'     => KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-mobile-menu.php',
					'enable'   => true,
					'settings' => [
						'type'    => 'switcher',
						'id'      => 'kfw_mobile_menu',
						'title'   => esc_html__( 'Mobile Menu', 'onnat-extra'),
						'desc'    => esc_html__( 'Add Mobile Menu elementor widgets for Custom Header.', 'onnat-extra' ),
						'default' => true
					]
				];

			$widgets = apply_filters( 'kinfw-filter/plugin/elementor/widgets/list', $widgets );

			return $widgets;

		}

        /**
         * Register Widget
         * Load widget files and register KinForce Elementor Widgets
         */
        public function register_widget( $widgets_manager ) {

			$widgets = $this->widgets_list();
			ksort( $widgets );

			foreach ( $widgets as $widget ) {

				if( $widget['enable'] ) {

					if( !empty( $widget['class'] ) && !empty( $widget['file'] ) ) {

						$fileName  = $widget['file'];
						$className = $widget['class'];

						require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';
						require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';

						$WP_Filesystem_Direct = new WP_Filesystem_Direct( false );
						if( $WP_Filesystem_Direct->exists( $fileName ) ) {
							require_once $fileName;

							$widgets_manager->register( new $className() );
						}
					}
				}
			}

		}

		public function settings() {

			$widgets = $this->widgets_list();
			$fields  = [];

			ksort( $widgets );

			foreach( $widgets as $widget ) {
				array_push( $fields, $widget['settings'] );
			}

            CSF::createSection( ONNAT_CONST_THEME_OPTION_PREFIX, [
                'parent' => 'theme_elementor_section',
                'title'  => esc_html__( 'Widgets', 'onnat-extra' ),
                'fields' =>  $fields
			] );

			/**
			 * Settings
			 */

            CSF::createSection( ONNAT_CONST_THEME_OPTION_PREFIX, [
				'parent' => 'theme_elementor_section',
				'title'  => esc_html__( 'API Settings', 'onnat-extra' ),
				'fields' => [

					/**
					 * Google Map API Settings
					 */
					[
                        'type'    => 'submessage',
                        'style'   => 'info',
                        'content' => sprintf(
                            /* translators: 1:H3 Opening Tag 2: H3 Closing Tag */
                            esc_html__('%1$s Google Map Integration.%2$s', 'onnat-extra' ),
                            '<h3>', '</h3>'
                        )
					],
                    [
						'id'       => 'gmap_api_key',
						'type'     => 'text',
						'title'    => esc_html__( 'GMap API Key', 'onnat-extra' ),
						'subtitle' => esc_html__( 'Provide your Google Map API key for integration purposes.', 'onnat-extra' ),
						'desc'     => sprintf(
							esc_html__('Follow the guidelines in the %s for detailed instructions on obtaining the Google Map API from Google Cloud Console.', 'onnat-extra' ),
							sprintf( '<a href="%s" target="_blank">%s</a>', KFE_CONST_THEME_DOC . 'how-to/get-gmap-api-key', esc_html__('documentation', 'onnat-extra') )
						),
                    ],

					/**
					 * Mailchimp Settings
					 */
					[
                        'type'    => 'submessage',
                        'style'   => 'info',
                        'content' => sprintf(
                            /* translators: 1:H3 Opening Tag 2: H3 Closing Tag */
                            esc_html__('%1$s Mailchimp Integration.%2$s', 'onnat-extra' ),
                            '<h3>', '</h3>'
                        )
					],
                    [
						'id'       => 'mailchimp_api_key',
						'type'     => 'text',
						'title'    => esc_html__( 'MailChimp API Key', 'onnat-extra' ),
						'subtitle' => esc_html__( 'Provide your MailChimp API key for authentication and integration purposes.', 'onnat-extra' ),
						'desc'     => sprintf(
							esc_html__('To obtain MailChimp API Key, you need to follow the %s for detailed instructions.', 'onnat-extra' ),
							sprintf( '<a href="%s" target="_blank">%s</a>', KFE_CONST_THEME_DOC . 'how-to/get-mailchimp-api-key', esc_html__('documentation', 'onnat-extra') )
						),
                    ],
                    [
						'id'       => 'mailchimp_audience_id',
						'type'     => 'text',
						'title'    => esc_html__( 'Audience ID', 'onnat-extra' ),
						'subtitle' => esc_html__( 'Include your MailChimp Audience ID for seamless integration and audience management.', 'onnat-extra' ),
						'desc'     => sprintf(
							esc_html__('Follow the guidelines in the %s for detailed instructions on obtaining the MailChimp Audience ID.', 'onnat-extra' ),
							sprintf( '<a href="%s" target="_blank">%s</a>', KFE_CONST_THEME_DOC . 'how-to/get-mailchimp-audience-id', esc_html__('documentation', 'onnat-extra') )
						),
                    ],
				]
			] );

		}

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_modules_manager' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_modules_manager() {

        return KinForce_Extra_Plugin_Elementor_Modules_Manager::get_instance();
    }
}

kf_extra_plugin_elementor_modules_manager();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */