<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Blog_Single_Elementor_Modules_Manager' ) ) {

	/**
	 * CPT Elementor modules setup class.
	 */
    class KinForce_Extra_Plugin_Blog_Single_Elementor_Modules_Manager {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {
			add_action( 'elementor/elements/categories_registered', [ $this, 'register_category' ], 50 );
			add_action( 'elementor/widgets/register', [ $this, 'register_widget' ], 50 );
        }

        /**
         * Add elementor widget category
         */
        public function register_category( $elements_manager  ) {

			$categories     = [];
			$old_categories = $elements_manager->get_categories();

			if( is_singular('kinfw-blog-post-look') || is_singular('elementor_library') ) {

				$categories['_kfw_blog_post_look_widgets'] = [
					'title' => esc_html__( 'KinForce - Blog Post Single', 'onnat-extra' ),
					'icon'  => 'eicon-font',
				];
			}

			$categories     = array_merge($categories, $old_categories);
            $set_categories = function ( $categories ) {
                $this->categories = $categories;
			};

			$set_categories->call( $elements_manager, $categories );
		}

        public function register_widget( $widgets_manager ) {

            /**
             * Post Title
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-title.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Title() );

            /**
             * Post Featured Image
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-featured-image.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Featured_Image() );

            /**
             * Post Format Info
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-format-info.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Format_Info() );

            /**
             * Post Excerpt
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-excerpt.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Excerpt() );

            /**
             * Post Content
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-content.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Content() );

            /**
             * Post Comments
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-comments.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Comments() );

            /**
             * Post Navigation
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-navigation.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Navigation() );

            /**
             * Post Meta
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-meta.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Meta() );

            /**
             * Post Author Box
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-author-box.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Author_Box() );

            /**
             * Post Social Share
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-blog-single-post-social-share.php';
            $widgets_manager->register( new KFW_Blog_Single_Post_Social_Share() );

		}

    }

}

if( !function_exists( 'kf_extra_plugin_blog_single_elementor_modules_manager' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_blog_single_elementor_modules_manager() {

        return KinForce_Extra_Plugin_Blog_Single_Elementor_Modules_Manager::get_instance();
    }
}

kf_extra_plugin_blog_single_elementor_modules_manager();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */