<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extension_Adv_Positioning' ) ) {

	/**
	 * Elementor Extension: Advance Custom Positioning setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extension_Adv_Positioning {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default extension state.
         */
        private $active = true;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'elementor/init', [ $this, 'init' ] );

            do_action( 'kinfw-action/plugin/elementor/extensions/adv-custom-positioning/loaded' );

		}

        public function init() {

            $this->active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/adv-custom-positioning', $this->active );

            if( $this->active ) {

                add_action('elementor/element/after_section_end', [ $this, 'register_section' ], 10, 2 );

			}

		}

        public function register_section( $controls_stack, $section_id ) {

            $target_sections = [
                'section_advanced'
            ];

            if( ! in_array( $section_id, $target_sections ) ){
                return;
            }

            $controls_stack->start_controls_section( 'kfw_section_adv_position', [
                'label' => __( 'Advance Positioning', 'onnat-extra' ),
                'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED
            ] );

                $controls_stack->add_control( 'enable_kfw_position', [
                    'label'        => esc_html__( 'Enable Positioning', 'onnat-extra' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'onnat-extra' ),
                    'label_off'    => esc_html__( 'No', 'onnat-extra' ),
                    'return_value' => 'yes',
                    'default'      => 'yes',
                ] );

                $controls_stack->add_responsive_control( 'kfw_position_type', [
                    'type'      => \Elementor\Controls_Manager::CHOOSE,
                    'label'     => esc_html__( 'Position Type', 'onnat-extra' ),
                    'options'   => [
                        'absolute' => [
                            'title' => esc_html__('Absolute', 'onnat-extra'),
                            'icon'  => 'eicon-justify-center-h'
                        ],
                        'relative' => [
                            'title' => esc_html__('Relative', 'onnat-extra'),
                            'icon'  => 'eicon-justify-end-v'
                        ],
                        'static'   => [
                            'title' => esc_html__('Static', 'onnat-extra'),
                            'icon'  => 'eicon-align-center-h'
                        ],
                    ],
                    'default'   => '',
                    'selectors' => [ '{{WRAPPER}}' => 'position:{{VALUE}};' ],
                    'condition' => [
                        'enable_kfw_position' => 'yes'
                    ]
                ] );

                $controls_stack->start_controls_tabs( 'kfw_positioning_position_tabs', [
                    'condition' => [
                        'enable_kfw_position' => 'yes',
                        'kfw_position_type'   => [ 'absolute', 'relative' ]
                    ]
                ] );
                    $controls_stack->start_controls_tab( 'kfw_positioning_top_position_tab', [
                        'label'     => esc_html__( 'Top', 'onnat-extra' ),
                    ] );
                        $controls_stack->add_responsive_control( 'kfw_positioning_top_position', [
                            'type'       => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', 'em', '%'],
                            'range'      => [
                                'px' => [
                                    'min'  => -1920,
                                    'max'  => 1920,
                                    'step' => 1
                                ],
                                '%' => [
                                    'min'  => -100,
                                    'max'  => 100,
                                    'step' => 1
                                ],
                                'em'  => [
                                    'min'  => -200,
                                    'max'  => 200,
                                    'step' => 1
                                ],
                            ],
                            'selectors'  => [
                                '{{WRAPPER}}' => 'top:{{SIZE}}{{UNIT}};'
                            ],
                            'condition'  => [
                                'enable_kfw_position' => 'yes',
                                'kfw_position_type'   => [ 'absolute', 'relative' ]
                            ]
                        ] );
                    $controls_stack->end_controls_tab();

                    $controls_stack->start_controls_tab( 'kfw_positioning_right_position_tab',[
                        'label'     => esc_html__( 'Right', 'onnat-extra' ),
                    ] );
                        $controls_stack->add_responsive_control( 'kfw_positioning_right_position', [
                            'type'       => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', 'em', '%'],
                            'range'      => [
                                'px' => [
                                    'min'  => -1920,
                                    'max'  => 1920,
                                    'step' => 1
                                ],
                                '%' => [
                                    'min'  => -100,
                                    'max'  => 100,
                                    'step' => 1
                                ],
                                'em'  => [
                                    'min'  => -200,
                                    'max'  => 200,
                                    'step' => 1
                                ],
                            ],
                            'selectors'  => [
                                '{{WRAPPER}}' => 'right:{{SIZE}}{{UNIT}};'
                            ],
                            'condition'  => [
                                'enable_kfw_position' => 'yes',
                                'kfw_position_type'   => [ 'absolute', 'relative' ]
                            ]
                        ] );
                    $controls_stack->end_controls_tab();

                    $controls_stack->start_controls_tab( 'kfw_positioning_bottom_position_tab', [
                        'label'     => esc_html__( 'Bottom', 'onnat-extra' ),
                    ] );
                        $controls_stack->add_responsive_control( 'kfw_positioning_bottom_position', [
                            'type'       => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', 'em', '%'],
                            'range'      => [
                                'px' => [
                                    'min'  => -1920,
                                    'max'  => 1920,
                                    'step' => 1
                                ],
                                '%' => [
                                    'min'  => -100,
                                    'max'  => 100,
                                    'step' => 1
                                ],
                                'em'  => [
                                    'min'  => -200,
                                    'max'  => 200,
                                    'step' => 1
                                ],
                            ],
                            'selectors'  => [
                                '{{WRAPPER}}' => 'bottom:{{SIZE}}{{UNIT}};'
                            ],
                            'condition'  => [
                                'enable_kfw_position' => 'yes',
                                'kfw_position_type'   => [ 'absolute', 'relative' ]
                            ]
                        ] );
                    $controls_stack->end_controls_tab();

                    $controls_stack->start_controls_tab( 'kfw_positioning_left_position_tab', [
                        'label'     => esc_html__( 'Left', 'onnat-extra' ),
                        'condition'    => [
                            'enable_kfw_position'        => 'yes',
                            'kfw_position_type'          => [ 'absolute', 'relative' ],
                            'enable_kfw_center_position' => ['']
                        ]
                    ] );
                        $controls_stack->add_responsive_control( 'kfw_positioning_left_position', [
                            'type'       => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', 'em', '%'],
                            'range'      => [
                                'px' => [
                                    'min'  => -1920,
                                    'max'  => 1920,
                                    'step' => 1
                                ],
                                '%' => [
                                    'min'  => -100,
                                    'max'  => 100,
                                    'step' => 1
                                ],
                                'em'  => [
                                    'min'  => -200,
                                    'max'  => 200,
                                    'step' => 1
                                ],
                            ],
                            'selectors'  => [
                                '{{WRAPPER}}' => 'left:{{SIZE}}{{UNIT}};'
                            ],
                            'condition'  => [
                                'enable_kfw_position' => 'yes',
                                'kfw_position_type'   => [ 'absolute', 'relative' ],
                                'enable_kfw_center_position' => ['']
                            ]
                        ] );
                    $controls_stack->end_controls_tab();
                $controls_stack->end_controls_tabs();

                $controls_stack->add_control( 'enable_kfw_center_position', [
                    'label'        => esc_html__( 'Enable Center Positioning', 'onnat-extra' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'onnat-extra' ),
                    'label_off'    => esc_html__( 'No', 'onnat-extra' ),
                    'return_value' => 'yes',
                    'default'      => '',
                    'condition'    => [
                        'enable_kfw_position' => 'yes',
                        'kfw_position_type'   => [ 'absolute', 'relative' ]
                    ]
                ] );

                $controls_stack->add_responsive_control( 'kfw_positioning_center_position', [
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'em', '%'],
                    'range'      => [
                        'px' => [
                            'min'  => -1920,
                            'max'  => 1920,
                            'step' => 1
                        ],
                        '%' => [
                            'min'  => -100,
                            'max'  => 100,
                            'step' => 1
                        ],
                        'em'  => [
                            'min'  => -200,
                            'max'  => 200,
                            'step' => 1
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}}' => 'left:calc( 50% + {{SIZE}}{{UNIT}} );'
                    ],
                    'condition'  => [
                        'enable_kfw_position' => 'yes',
                        'kfw_position_type'   => [ 'absolute', 'relative' ],
                    ]
                ] );

            $controls_stack->end_controls_section();

        }

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extension_adv_positioning' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extension_adv_positioning() {

        return KinForce_Extra_Plugin_Elementor_Extension_Adv_Positioning::get_instance();
    }
}

kf_extra_plugin_elementor_extension_adv_positioning();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */