<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extension_Hover_Image' ) ) {

	/**
	 * Elementor Extension: For adding hover images for container, section, and column setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extension_Hover_Image {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default extension state.
         */
        private $active = true;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {
            add_action( 'elementor/init', [ $this, 'init' ] );

            do_action( 'kinfw-action/plugin/elementor/extensions/hover-image/loaded' );
        }

        public function init() {
            $this->active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/section-hover-img', $this->active );

            if( $this->active ) {
                add_action('elementor/element/container/section_layout/before_section_start', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/section/section_structure/after_section_end', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/column/section_typo/after_section_end', [ $this, 'register_section' ], 10, 2 );
            }
        }

        public function register_section( $element, $section_id ) {
            $tab      = Elementor\Controls_Manager::TAB_CONTENT;
            $ele_name = $element->get_name();
            $name     = str_replace( ' ', '', ucwords( str_replace( '-', ' ', $ele_name ) ) );

            switch ( $ele_name ) {
                case 'container':
                case 'section':
                case 'column':
                    $tab = Elementor\Controls_Manager::TAB_LAYOUT;
                break;

                default:
                    $name = esc_html__( 'Widget', 'onnat-extra' );
                    $tab  = Elementor\Controls_Manager::TAB_CONTENT;
                break;
            }

            $this->_register_wrapper_hover_img_section( $element, $name, $tab );
        }

        public function _register_wrapper_hover_img_section( $controls_stack, $name, $tab ) {
            $controls_stack->start_controls_section( 'kfw_section_wrapper_hover_image', [
                'label' => sprintf( __( '%s Hover Image', 'onnat-extra'), $name ),
                'tab'   => $tab
            ] );
                $controls_stack->add_control( 'use_kf_ele_h_img', [
                    'label'              => esc_html__( 'Enable Hover Image?', 'onnat-extra' ),
                    'type'               => Elementor\Controls_Manager::SWITCHER,
                    'frontend_available' => true,
                    'return_value'       => 'yes',
                ]);
                $controls_stack->add_responsive_control( 'kf_ele_h_width', [
                    'label'      => esc_html__( 'Width', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%'  => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kinfw-hover-img-ext' => 'width:{{SIZE}}{{UNIT}} !important;'
                    ],
                    'condition'  => [ 'use_kf_ele_h_img!' => '' ],
                ]);
                $controls_stack->add_responsive_control( 'kf_ele_h_height', [
                    'label'      => esc_html__( 'Height', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%'  => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kinfw-hover-img-ext' => 'height:{{SIZE}}{{UNIT}} !important;'
                    ],
                    'condition'  => [ 'use_kf_ele_h_img!' => '' ],
                ]);
                $controls_stack->add_group_control( Elementor\Group_Control_Background::get_type(), [
                    'label'     => esc_html__('Background', 'onnat-extra' ),
                    'name'      => 'kf_ele_h_bg',
                    'selector'  => '{{WRAPPER}} .kinfw-hover-img-ext',
                    'condition' => [ 'use_kf_ele_h_img!' => '' ]
                ]);
                $controls_stack->add_group_control( Elementor\Group_Control_Border::get_type(), [
                    'label'     => esc_html__('Border', 'onnat-extra' ),
                    'name'      => 'kf_ele_h_border',
                    'selector'  => '{{WRAPPER}} .kinfw-hover-img-ext',
                    'condition' => [ 'use_kf_ele_h_img!' => '' ]
                ]);
                $controls_stack->add_responsive_control( 'kf_ele_h_border_radius', [
                    'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}} .kinfw-hover-img-ext' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition'  => [ 'use_kf_ele_h_img!' => '' ],
                ]);
                $controls_stack->add_responsive_control( 'kf_ele_h_margin', [
                    'label'              => esc_html__('Margin', 'onnat-extra' ),
                    'type'               => Elementor\Controls_Manager::DIMENSIONS,
                    'size_units'         => [ 'px', 'em', '%' ],
                    'allowed_dimensions' => [
                        'left',
                    ],
                    'placeholder'        => [
                        'top'    => 'auto',
                        'right'  => 'auto',
                        'bottom' => 'auto',
                        'left'   => '',
                    ],
                    'selectors'          => [
                        '{{WRAPPER}} .kinfw-hover-img-ext' => 'margin-left:{{LEFT}}{{UNIT}};'
                    ],
                    'condition'          => [ 'use_kf_ele_h_img!' => '' ],
                ]);
                $controls_stack->add_control( 'kf_ele_h_zindex', [
                    'label'     => esc_html__( 'Z-index', 'onnat-extra' ),
                    'type'      => Elementor\Controls_Manager::NUMBER,
                    'min'       => -9999,
                    'max'       => 9999,
                    'selectors' => [
                        '{{WRAPPER}} .kinfw-hover-img-ext' => 'z-index: {{VALUE}};',
                    ],
                    'condition' => [ 'use_kf_ele_h_img!' => '' ],
                ]);
            $controls_stack->end_controls_section();
        }
    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extension_hover_image' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extension_hover_image() {

        return KinForce_Extra_Plugin_Elementor_Extension_Hover_Image::get_instance();
    }
}

kf_extra_plugin_elementor_extension_hover_image();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */