<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extension_Shape_Shift' ) ) {

	/**
	 * Elementor Extension: Smoothly transition section shapes with dynamic scroll effect for container and section setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extension_Shape_Shift {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default extension state.
         */
        private $active = true;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {
            add_action( 'elementor/init', [ $this, 'init' ] );

            do_action( 'kinfw-action/plugin/elementor/extensions/shape-shift/loaded' );
        }

        public function init() {
            $this->active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/section-shape-shift', $this->active );

            if( $this->active ) {
                add_action('elementor/element/container/section_shape_divider/after_section_end', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/section/section_shape_divider/after_section_end', [ $this, 'register_section' ], 10, 2 );
            }
        }

        public function register_section( $element, $section_id ) {
            $tab      = Elementor\Controls_Manager::TAB_STYLE;
            $ele_name = $element->get_name();
            $name     = str_replace( ' ', '', ucwords( str_replace( '-', ' ', $ele_name ) ) );

            switch ( $ele_name ) {
                case 'container':
                case 'section':
                    $tab = Elementor\Controls_Manager::TAB_STYLE;
                break;
            }

            $this->_register_wrapper_shape_shift_section( $element, $name, $tab );
        }

        public function _register_wrapper_shape_shift_section( $controls_stack, $name, $tab ) {
            $controls_stack->start_controls_section( 'kfw_section_shape_shift', [
                'label' => sprintf( __( '%s Shape Shift on scroll', 'onnat-extra'), $name ),
                'tab'   => $tab
            ] );
                $controls_stack->add_control( 'use_kf_ele_shape_shift', [
                    'label'              => esc_html__( 'Enable It?', 'onnat-extra' ),
                    'type'               => Elementor\Controls_Manager::SWITCHER,
                    'frontend_available' => true,
                    'return_value'       => 'yes',
                ]);
                $controls_stack->add_control('kf_ele_shape_shift_from_heading',[
                    'label'     => esc_html__( 'From', 'onnat-extra' ),
                    'type'      => Elementor\Controls_Manager::HEADING,
                    'condition' => [
                        'use_kf_ele_shape_shift!' => '',
                    ],
				]);
				$controls_stack->add_control('kf_ele_shape_shift_from_heading_after_hr', [
                    'type'      => Elementor\Controls_Manager::DIVIDER,
                    'condition' => [
                        'use_kf_ele_shape_shift!' => '',
                    ],
				]);
				$controls_stack->add_control( 'kf_ele_shape_shift_from_inset', [
                    'label'              => esc_html__('Inset', 'onnat-extra' ),
                    'type'               => Elementor\Controls_Manager::DIMENSIONS,
                    'frontend_available' => true,
                    'size_units'         => [ 'px', '%' ],
                    'condition'          => [
                        'use_kf_ele_shape_shift!' => '',
                    ],
				]);
                $controls_stack->add_control( 'kf_ele_shape_shift_from_border_radius', [
                    'label'              => esc_html__('Border Radius', 'onnat-extra' ),
                    'type'               => Elementor\Controls_Manager::DIMENSIONS,
                    'frontend_available' => true,
                    'size_units'         => [ 'px', '%' ],
                    'condition'          => [
                        'use_kf_ele_shape_shift!' => '',
                    ],
                ]);
                $controls_stack->add_control('kf_ele_shape_shift_to_heading',[
                    'label'     => esc_html__( 'To', 'onnat-extra' ),
                    'type'      => Elementor\Controls_Manager::HEADING,
                    'condition' => [
                        'use_kf_ele_shape_shift!' => '',
                    ],
				]);
				$controls_stack->add_control('kf_ele_shape_shift_to_heading_after_hr', [
                    'type'      => Elementor\Controls_Manager::DIVIDER,
                    'condition' => [
                        'use_kf_ele_shape_shift!' => '',
                    ],
				]);
				$controls_stack->add_control( 'kf_ele_shape_shift_to_inset', [
                    'label'              => esc_html__('Inset', 'onnat-extra' ),
                    'type'               => Elementor\Controls_Manager::DIMENSIONS,
                    'frontend_available' => true,
                    'size_units'         => [ 'px', '%' ],
                    'condition'          => [
                        'use_kf_ele_shape_shift!' => '',
                    ],
				]);
                $controls_stack->add_control( 'kf_ele_shape_shift_to_border_radius', [
                    'label'              => esc_html__('Border Radius', 'onnat-extra' ),
                    'type'               => Elementor\Controls_Manager::DIMENSIONS,
                    'size_units'         => [ 'px', '%' ],
                    'frontend_available' => true,
                    'condition'          => [
                        'use_kf_ele_shape_shift!' => '',
                    ],
                ]);
            $controls_stack->end_controls_section();
        }
    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extension_shape_shift' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extension_shape_shift() {

        return KinForce_Extra_Plugin_Elementor_Extension_Shape_Shift::get_instance();
    }
}

kf_extra_plugin_elementor_extension_shape_shift();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */