<?php
/**
 * Widget Template : Blog Post Grid
 */

$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-blog-post-grid-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-blog-post-grid-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
    foreach( $items as $index => $item ) {
        $post    = get_post( $item['post'], ARRAY_A );

        if( !is_null( $post ) ) {
            $post_id = $post['ID'];

            $p_item  = $this->get_repeater_setting_key( 'p-item', 'p-items', $index );
            $classes = get_post_class( [
                'kinfw-post-item',
                esc_attr( $settings['layout'] ),
                'kfw-ele-widget-blog-post-grid-item',
                'elementor-repeater-item-' . esc_attr( $item['_id'] ),
            ], $post_id );

            $this->add_render_attribute( $p_item, [
                'id'    => 'post-'.$post_id,
                'class' => array_filter( $classes )
            ] );

            echo '<article '. $this->get_render_attribute_string( $p_item ) .'>';

                switch ( $settings['layout'] ) {
                    case 'kinfw-blog-grid-style-1':
                        $this->blog_post_grid_style_1( $post );
                    break;

                    case 'kinfw-blog-grid-style-2':
                        $this->blog_post_grid_style_2( $post );
                    break;

                    case 'kinfw-blog-grid-style-3':
                        $this->blog_post_grid_style_3( $post );
                    break;

                    case 'kinfw-blog-grid-style-4':
                        $this->blog_post_grid_style_4( $post );
                    break;
                }

            echo '</article>';
        }
    }
echo '</div>';