<?php
/**
 * Widget Template : Brands Grid
 */

$mode     = $this->_is_editor_mode();
$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-brands-grid-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-brands-grid-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    foreach( $items as $index => $item ) {

        $b_item  = $this->get_repeater_setting_key( 'b-item', 'b-items', $index );
        $classes = [
            'elementor-repeater-item-' . esc_attr( $item['_id'] ),
            'kfw-ele-widget-brands-grid-item',
        ];

        if( $item['enable_link'] === 'yes' && !empty( $item['link']['url'] ) ) {
            $link   = $item['link']['url'];
            $target = ( !empty( $item['link']['is_external'] ) ) ? '_blank' : '_self';

            if( !$mode ) {
                $this->add_render_attribute( $b_item, 'onclick', 'window.open("'. esc_url( $link ) .'", "'. $target .'");');
            }

            $classes[] = 'kfw-ele-widget-brands-grid-item-linked';
        }

        $this->add_render_attribute( $b_item, [ 'class' => array_filter( $classes ) ] );

        echo '<div '. $this->get_render_attribute_string( $b_item ) .'>';

            $item_image_wrapper = $this->get_repeater_setting_key( 'image-item-wrap', 'b-items', $index );
            $this->add_render_attribute( $item_image_wrapper, [
                'class' => array_filter([
                    'kfw-ele-widget-brands-grid-image-wrapper',
                    ( $item['hover'] === 'gray' ) ? 'kfw-ele-widget-brands-grid-gray-image' : '',
                    ( $item['hover'] === 'image' ) ? 'kfw-ele-widget-brands-grid-hover-image' : '',
                ])
            ]);

            echo '<div '.$this->get_render_attribute_string( $item_image_wrapper ).'>';

                /**
                 * Image
                 */
                if( !empty( $item['image']['url'] ) ) {

                    $image_src = $this->_get_image_src( $item['image']['id'], 'image_size', $settings );
                    $image_src = empty($image_src) ? $item['image']['url'] : $image_src;

                    $image_title = $this->_get_image_title( $item['image'] );
                    $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                    $image_alt = $this->_get_image_alt( $item['image'] );
                    $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                    $image_attr = $this->get_repeater_setting_key( 'image-item', 'b-items', $index );

                    $this->add_render_attribute( $image_attr, [
                        'class' => 'kfw-ele-widget-brands-grid-image kfw-image-is-loading',
                        'alt'   => esc_attr( $image_alt ),
                        'title' => esc_attr( $image_title ),
                        'src'   => esc_url( $image_src ),
                    ]);

                    echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';

                }

                /**
                 * Hover Image
                 */
                if( $item['hover'] === 'image' && !empty( $item['himage']['url'] ) ) {

                    $image_src = $this->_get_image_src( $item['himage']['id'], 'image_size', $settings );
                    $image_src = empty($image_src) ? $item['himage']['url'] : $image_src;

                    $image_title = $this->_get_image_title( $item['himage'] );
                    $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                    $image_alt = $this->_get_image_alt( $item['himage'] );
                    $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                    $image_attr = $this->get_repeater_setting_key( 'himage-item', 'b-items', $index );

                    $this->add_render_attribute( $image_attr, [
                        'class' => 'kfw-ele-widget-brands-grid-image kfw-ele-widget-brands-grid-hover-image kfw-image-is-loading',
                        'alt'   => esc_attr( $image_alt ),
                        'title' => esc_attr( $image_title ),
                        'src'   => esc_url( $image_src ),
                    ]);

                    echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                }

            echo '</div>';

        echo '</div>';

    }

echo '</div>';