<?php
/**
 * Widget Template : Button
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-button-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-button-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $this->add_render_attribute( 'btn-wrap', [
        'class' => array_filter([
            'kfw-ele-widget-button-wrap',
            !empty( trim( $settings['btn_text'] ) ) ? 'kfw-ele-widget-button-has-txt' : ''
        ])
    ]);
    echo '<div '.$this->get_render_attribute_string( 'btn-wrap' ).'>';

        $this->add_render_attribute( 'btn', [
            'class' => array_filter([
                'kfw-ele-widget-button',
                !empty( $settings['btn_animation_hover'] ) ? 'elementor-animation-'.esc_attr( $settings['btn_animation_hover'] ): '',
            ])
        ]);

        /**
         * Button Icon related classes
         */
            if( $settings['btn_icon']['value'] !== '' ) {
                $this->add_render_attribute( 'btn', [
                    'class' => array_filter([
                        !empty( trim( $settings['btn_text'] ) ) ? 'kfw-ele-widget-button-icon-position-'.$settings['btn_icon_pos'] : '',
                        ( !empty( trim( $settings['btn_text'] ) ) ) && ( $settings['btn_icon_pos'] === 'animated-left' || $settings['btn_icon_pos'] === 'animated-right' ) ? 'kfw-ele-widget-button-animated-icon-position-' . $settings['alr_btn_icon_animation'] : '',
                        ( !empty( trim( $settings['btn_text'] ) ) ) && ( $settings['btn_icon_pos'] === 'toggle' ) ? 'kfw-ele-widget-button-toggle-icon-position-' . $settings['toggle_btn_icon_animation'] : '',
                    ])
                ]);
            }

        /**
         * Link
         */
            $link = array_filter( $settings['btn_link'] );
            if ( ! empty( $link['url'] ) ) {
                $this->add_render_attribute( 'btn', 'href', esc_url( $link['url'] ) );

                if ( ! empty( $link['is_external'] ) ) {
                    $this->add_render_attribute( 'btn', 'target', '_blank' );
                }

                if ( ! empty( $link['nofollow'] ) ) {
                    $this->add_render_attribute( 'btn', 'rel', 'nofollow' );
                }
            }

        echo '<a '.$this->get_render_attribute_string( 'btn' ).'>';
            if( $settings['btn_icon_pos'] === 'left' || $settings['btn_icon_pos'] === 'animated-left' ) {
                $this->_render_icon( $settings['btn_icon'] );
            }

            if( !empty( trim( $settings['btn_text'] ) ) ) {
                printf( '<span class="kfw-elementor-button-text">%s</span>', esc_html( $settings['btn_text'] ) );
            }

            if( $settings['btn_icon_pos'] === 'right'
                || $settings['btn_icon_pos'] === 'animated-right'
                || $settings['btn_icon_pos'] === 'toggle'
                || $settings['btn_icon_pos'] === 'toggle-alt'
            ) {
                $this->_render_icon( $settings['btn_icon'] );
            }
        echo '</a>';

    echo '</div>';

echo '</div>';