<?php
/**
 * Widget Template : Content Switch
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-content-switch-'.esc_attr( $this->get_id() ),
    'class' => [ 'kfw-ele-widget-content-switch-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $primary_active_class = $secondary_active_class = '';
    $switch_class         = $settings['active'];

    if( $switch_class === 'kinfw-primary-switch' ) {
        $primary_active_class   = 'active';
        $secondary_active_class = '';
    } else if( $switch_class === 'kinfw-secondary-switch' ) {
        $primary_active_class   = '';
        $secondary_active_class = 'active';
    }

    /**
     * Header
     */
    echo '<div class="kfw-content-switch-header-wrap">';
        echo '<div class="kfw-primary-title">';
            echo wp_kses( $settings['primary-title'], [ 'strong' => '', 'br' => '' ] );
        echo '</div>';

        echo '<div class="kfw-switch-wrap">';

            $this->add_render_attribute( 'switch', [
                'class' => [
                    'kfw-switch',
                    $settings['switch-size'],
                    $switch_class,
                ],
            ]);
            echo '<div '.$this->get_render_attribute_string( 'switch' ).'>';
                echo '<div class="kfw-switch-toggle"></div>';
            echo '</div>';
        echo '</div>';

        echo '<div class="kfw-secondary-title">';
            echo wp_kses( $settings['secondary-title'], [ 'strong' => '', 'br' => '' ] );
        echo '</div>';
    echo '</div>';

    /**
     * Content
    */
    echo '<div class="kfw-content-switch-content-wrap">';
        /**
         * Primary
         */
        $this->add_render_attribute( 'primary', [
            'class' => [
                'kfw-primary-content',
                $primary_active_class,
            ],
        ]);
        echo '<div '.$this->get_render_attribute_string( 'primary' ).'>';
            if( $settings['primary-template'] != '0' && !empty( $settings['primary-template'] ) ) {
                echo $this->_generate_template_content( $settings['primary-template'] );
            }
        echo '</div>';

        /**
         * Primary
         */
        $this->add_render_attribute( 'secondary', [
            'class' => [
                'kfw-secondary-content',
                $secondary_active_class,
            ],
        ]);
        echo '<div '.$this->get_render_attribute_string( 'secondary' ).'>';
            if( $settings['secondary-template'] != '0' && !empty( $settings['secondary-template'] ) ) {
                echo $this->_generate_template_content( $settings['secondary-template'] );
            }
        echo '</div>';
    echo '</div>';
echo '</div>';