<?php
/**
 * Widget Template : Team Member Carousel
 */

$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
    'id'            => 'kfw-ele-widget-cpt-team-member-carousel-'.esc_attr( $this->get_id() ),
    'class'         => [ 'kfw-ele-widget-cpt-team-member-carousel-main' ],
    'data-settings' => $this->_generate_setting_json( $settings ),
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $this->add_render_attribute( 'swiper', [
        'data-id' => 'kfw-js-swiper-'.esc_attr( $this->get_id() ),
        'class'   => array_filter( [
            'kfw-js-swiper-'.esc_attr( $this->get_id() ),
            'kfw-swiper',
            esc_attr( $settings['layout'] ) . '-swiper',
            'swiper',
            'swiper-container',
        ])
    ]);
    echo '<div '. $this->get_render_attribute_string( 'swiper' ) .'>';

        $this->add_render_attribute( 'list', [
            'class' => array_filter( [
                'kfw-ele-team-member-carousel-list',
                'swiper-wrapper'
            ])
        ]);
        echo '<div '. $this->get_render_attribute_string( 'list' ) .'>';

            foreach( $items as $index => $item ) {
                $member  = get_post( $item['member'], ARRAY_A );

                $post_id    = $member['ID'];
                $post_title = get_the_title( $post_id );
                $post_link  = get_permalink( $post_id );
                $terms_list = get_the_term_list( $post_id, 'kinfw-team-group', '', ', ', '' );

                /**
                 * Social Links
                 */
                $social_links        = $settings['socials'];
                $active_social_links = [];

                foreach( $social_links as $social_link ) {
                    if( 'yes' === $social_link['status'] ) {
                        array_push( $active_social_links, $social_link['social']);
                    }
                }

                $links = [];
                $meta  = get_post_meta( $post_id, '_kinfw_cpt_team_member_options', true );
                $meta  = apply_filters( 'kinfw-filter/theme/util/is-array', $meta );

                foreach( $active_social_links as $social_id ) {
                    if( isset( $meta[ $social_id ] ) && !empty( $meta[ $social_id ] ) ) {
                        $links[ $social_id ] = $meta[ $social_id ];
                    }
                }                

                $t_item  = $this->get_repeater_setting_key( 't-item', 't-items', $index );
                $classes = [
                    'kinfw-team-member-item',
                    'kfw-ele-widget-cpt-team-member-carousel-item',
                    esc_attr( $settings['layout'] ),
                    'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                    'swiper-slide',
                ];

                $this->add_render_attribute( $t_item, [
                    'id'    => 'post-'.$post_id,
                    'class' => array_filter( $classes )
                ] );
                echo '<div '. $this->get_render_attribute_string( $t_item ) .'>';

                    /**
                     * Media
                     */
                        $media = '';

                        if( has_post_thumbnail( $post_id ) ) {
                            $media = get_the_post_thumbnail( $post_id, 'full' );
                        } else {
                            $media = sprintf( '
                                <img src="%1$s" alt="%2$s" class="kinfw-transparent-img"/>',
                                get_theme_file_uri( 'assets/image/public/transparent.jpg' ),
                                $post_title
                            );
                        }

                        echo '<div class="kinfw-team-member-image-wrap">';
                            echo $media;
                            if( count( $links ) ) {
                                if( $settings['layout'] === 'kinfw-team-member-grid-style-4' ) {
                                    echo '<ul class="kinfw-social-links">';
                                        foreach( $links as $social_id => $social_link ) {
                                            printf( '<li> <a href="%s"></a> </li>', $social_link );
                                        }
                                    echo '</ul>';                            
                                }
                            }
                        echo '</div>';

                    /**
                     * Social Links
                     */
                        if( count( $links ) ) {
                            if( $settings['layout'] === 'kinfw-team-member-grid-style-3' ) {
                                echo '<div class="kinfw-social-wrapper">';
                                    echo '<div class="kinfw-social-icon">';
                                        echo '<span class="kinfw-icon kinfw-icon-math-plus"></span>';
                                        echo '<span class="kinfw-icon kinfw-icon-math-minus"></span>';
                                    echo '</div>';
                                    echo '<ul class="kinfw-social-links">';
                                        foreach( $links as $social_id => $social_link ) {
                                            printf( '<li> <a href="%s"></a> </li>', $social_link );
                                        }
                                    echo '</ul>';
                                echo '</div>';
                            } else if( in_array( $settings['layout'], [ 'kinfw-team-member-grid-style-1', 'kinfw-team-member-grid-style-2' ] ) ) {
                                echo '<ul class="kinfw-social-links">';
                                    foreach( $links as $social_id => $social_link ) {
                                        printf( '<li> <a href="%s"></a> </li>', $social_link );
                                    }
                                echo '</ul>';
                            }
                        }

                    /**
                     * Content Wrap
                     */
                        echo '<div class="kinfw-team-member-content-wrap">';
                            if( count( $links ) ) {
                                if( $settings['layout'] === 'kinfw-team-member-grid-style-5' ) {
                                    echo '<ul class="kinfw-social-links">';
                                        foreach( $links as $social_id => $social_link ) {
                                            printf( '<li> <a href="%s"></a> </li>', $social_link );
                                        }
                                    echo '</ul>';
                                }
                            }

                            printf( '<h6><a href="%s">%s</a></h6> %s',
                                esc_url( $post_link ),
                                esc_html( $post_title ),
                                $terms_list ? sprintf( '<p>%s</p>', $terms_list ) : ''
                            );
                        echo '</div>';

                echo '</div>';

            }

        echo '</div>';

    echo '</div>';

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] !== 'custom' ) {

        /**
         * Navigation
         */
        $this->add_render_attribute( 'navEl', [
            'class' => array_filter( [
                'kfw-cpt-team-member-carousel-nav-wrap',
                'kfw-cpt-team-member-carousel-nav-pos-'. $settings['arrow_position'],
                $settings['mobile_arrows'] === 'yes' ? 'hide-on-sm hide-on-xs' : ''
            ] )
        ] );

        echo '<div '.$this->get_render_attribute_string( 'navEl' ).'>';

            $this->add_render_attribute( 'prevEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-prev',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-prev'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'prevEl' ).'>';
                $this->_render_icon( $settings['right_arrow'] );
            echo '</div>';

            $this->add_render_attribute( 'nextEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-next',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-next'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'nextEl' ).'>';
                $this->_render_icon( $settings['left_arrow'] );
            echo '</div>';

        echo '</div>';
    }

    if( $settings['dots'] === 'yes' ) {

        /**
         * Pagination
         */
        $this->add_render_attribute( 'pagination', [
            'class' => array_filter( [
                'kfw-swiper-pagination',
                'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-pagination'
            ] )
        ] );
        echo '<div '.$this->get_render_attribute_string( 'pagination' ).'></div>';
    }

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] === 'custom' ) {
        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-next %2$s for Next Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );

        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-prev %2$s for Prev Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );
    }

echo '</div>';