<?php
/**
 * Widget Template : Custom Heading
 */
$settings  = $this->get_settings();
$title     = trim( $settings['title'] );
$sub_title = trim( $settings['sub_title'] );

$this->add_render_attribute( 'main', [
    'id'            => 'kfw-ele-widget-custom-heading-'.esc_attr( $this->get_id() ),
    'class'         => [ 'kfw-ele-widget-custom-heading-main' ],
    'data-settings' => $this->_generate_setting_json( $settings ),
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    /**
     * Shadow Text
     */
    if( !empty( $settings['shadow_text']) && 'yes' === $settings['use_shadow_text'] ) {
        $this->_shadow_text( $settings );
    }

    /**
     * Sub Title at Top
     */
    if( !empty( $sub_title ) && 'top' === $settings['sub_title_pos'] ) {
        $this->_sub_title( $settings );
    }

    /**
     * Title
     */
    $this->_title( $settings );


    /**
     * Sub Title at Bottom
     */
    if( !empty( $sub_title ) && 'bottom' === $settings['sub_title_pos'] ) {
        $this->_sub_title( $settings );
    }

    if( 'yes' === $settings['anim_title'] && 'style-6' === $settings['anim_type'] ) {
        echo '<span class="kfw-anim-line"></span>';
        echo '<span class="kfw-anim-dot"></span>';
    }

echo '</div>';