<?php
/**
 * Widget Template : Custom List
 */

$mode        = $this->_is_editor_mode();
$settings    = $this->get_settings();
$current_url = $this->_get_current_url();
$items       = $settings['items'];

if( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-custom-list-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-custom-list-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

	foreach( $items as $index => $item ):

		$list_item = $this->get_repeater_setting_key( 'list_item', 'items', $index );
		$classes   = [
			'elementor-repeater-item-' . esc_attr( $item['_id'] ),
			'kfw-elementor-custom-list-item',
		];

		if( !empty( $item['link']['url'] ) ) {
			$link   = $item['link']['url'];
			$target = ( !empty( $item['link']['is_external'] ) ) ? '_blank' : '_self';

			$classes[] = 'kfw-elementor-custom-list-item-linked';

			if( $link === $current_url ) {
				$classes[] = 'kfw-elementor-custom-list-active-item';
			}

            if( !$mode ) {
                $this->add_render_attribute( $list_item, 'onclick', 'window.open("'. esc_url( $link ) .'", "'. $target .'");');
            }
		}

        $this->add_render_attribute( $list_item, [
            'id'    => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
            'class' => array_filter( $classes ),
        ]);
        echo '<div '.$this->get_render_attribute_string( $list_item ).'>';

                /**
                 * Icon
                 */
					if( $settings['use_title_icon'] === 'yes' && $item['icon_type'] !== 'blank' ) {
                        if( $item['icon_type'] === 'icon' ) {
                            $this->_render_icon( $item['icon'] );
                        } else if( $item['icon_type'] === 'image' ) {
                            $this->_render_img( $item['image'] );
                        } else if( $item['icon_type'] === 'lordicon_media' || $item['icon_type'] === 'lordicon_external' ) {
                            $src = '';
                            if( $item['icon_type'] === 'lordicon_media' ) {
                                $src = !empty( $item['lordicon_media']['url'] ) ? $item['lordicon_media']['url'] : '';
                            } else if( $item['icon_type'] === 'lordicon_external' ) {
                                $src = !empty( $item['lordicon_external']['url'] ) ? $item['lordicon_external']['url'] : '';
                            }

                            if( !empty( $src ) ) {
                                $lordicon = $this->get_repeater_setting_key( 'lordicon', 'items', $index );

                                $this->add_render_attribute( $lordicon, [
                                    'class'   => 'kfw-elementor-lordicon',
                                    'src'     => $src,
                                    'stroke'  => 45,
                                    'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                    'trigger' => 'hover'
                                ]);

                                /**
                                 * Colors
                                 */
                                    $colors = '';
                                    $colors .= !empty( $settings['lordicon_primary_color'] ) ? 'primary:'.$settings['lordicon_primary_color'].',': '';
                                    $colors .= !empty( $settings['lordicon_secondary_color'] ) ? 'secondary:'.$settings['lordicon_secondary_color'].',': '';
                                    $colors .= !empty( $settings['lordicon_tertiary_color'] ) ? 'tertiary:'.$settings['lordicon_tertiary_color'].',': '';
                                    if( !empty( $colors ) ) {
                                        $this->add_render_attribute( $lordicon, 'colors', $colors );
                                    }

                                echo '<div class="kfw-custom-list-title-icon-wrap kfw-custom-list-title-lordicon-type">';
                                    echo '<span class="kfw-elementor-icon-wrap">';
                                        echo '<lord-icon '. $this->get_render_attribute_string( $lordicon ) .'></lord-icon>';
                                    echo '</span>';
                                echo '</div>';
                            }
                        }
					}

                /**
                 * Title
                 */
					$title     = trim( $item['title'] );
					$sub_title = trim( $item['sub_title'] );
					if( !empty( $title ) || !empty( $sub_title ) ) {
						echo '<div class="kfw-custom-list-title-wrap">';
							if( !empty( $title ) ) {
								echo '<div class="kfw-custom-list-title">';
									echo wp_kses( $title, [ 'strong' => '', 'br' => '' ] );
								echo '</div>';
							}

							if( !empty( $sub_title ) ) {
								echo '<div class="kfw-custom-list-sub-title">';
									echo wp_kses( $sub_title, [ 'strong' => '', 'br' => '' ] );
								echo '</div>';
							}
						echo '</div>';
					}

		echo '</div>';

    endforeach;

echo '</div>';