<?php
/**
 * Widget Template : Custom Text
 */
$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
    'id'            => 'kfw-ele-widget-custom-text-'.esc_attr( $this->get_id() ),
    'class'         => [ 'kfw-ele-widget-custom-text-main' ],
    'data-settings' => $this->_generate_setting_json( $settings ),
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    foreach( $items as $index => $item ) {

        $source  = $item['source'];
        $t_item  = $this->get_repeater_setting_key( 't-item', 't-items', $index );
        $classes = [
            'elementor-repeater-item',
            'elementor-repeater-item-' . esc_attr( $item['_id'] ),
            'kfw-ele-widget-custom-text-item',
            'kfw-ele-widget-custom-text-'.esc_attr( $source ).'-item',
        ];

        $this->add_render_attribute( $t_item, [ 'class' => array_filter( $classes ) ] );

        echo '<div '. $this->get_render_attribute_string( $t_item ) .'>';
            if( $source == 'editor' ) {
                echo $this->_parse_text_editor( $item['editor'] );
            } else if( $source == 'template' && ( $item['template'] != '0' && !empty( $item['template'] ) ) ) {
                echo $this->_generate_template_content( $item['template'] );
            }
        echo '</div>';

    }

echo '</div>';