<?php
/**
 * Widget Template : Horizontal Scroll Element
 */
$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'trigger', [
    'id'    => 'kfw-ele-widget-horiz-scroll-ele-trigger-'.esc_attr( $this->get_id() ),
    'class' => 'kfw-ele-widget-horiz-scroll-ele-trigger',
]);

echo '<div '.$this->get_render_attribute_string( 'trigger' ).'>';

    if( !empty( $settings['top_section'] ) ) {
        echo '<div class="kfw-ele-widget-horiz-scroll-ele-template">';
        echo $this->_generate_template_content( $settings['top_section'] );
        echo '</div>';
    }

    $this->add_render_attribute( 'main', [
        'id'               => 'kfw-ele-widget-horiz-scroll-ele-'.esc_attr( $this->get_id() ),
        'class'            => [
            'kfw-ele-widget-horiz-scroll-ele-main',
        ],
    ]);
    echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
        foreach( $items as $index => $item ):
            $scroll_item = $this->get_repeater_setting_key( 'scroll_item', 'items', $index );
            $this->add_render_attribute( $scroll_item, [
                'id'    => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class' => array_filter([
                    'kfw-elementor-split-horiz-scroll-ele-item',
                ]),
            ]);

            echo '<div '.$this->get_render_attribute_string( $scroll_item ).'>';
                /**
                 * Icon
                 */
                if( $item['icon_type'] !== 'blank' ) {
                    if( $item['icon_type'] === 'icon' ) {
                        $this->_render_icon( $item['icon'] );
                    } else if( $item['icon_type'] === 'text' ) {
                        $this->_render_text( $item['text'] );
                    } else if( $item['icon_type'] === 'image' ) {
                        $this->_render_img( $item['image'] );
                    } else if( $item['icon_type'] === 'lordicon_media' || $item['icon_type'] === 'lordicon_external' ) {
                        $src = '';
                        if( $item['icon_type'] === 'lordicon_media' ) {
                            $src = !empty( $item['lordicon_media']['url'] ) ? $item['lordicon_media']['url'] : '';
                        } else if( $item['icon_type'] === 'lordicon_external' ) {
                            $src = !empty( $item['lordicon_external']['url'] ) ? $item['lordicon_external']['url'] : '';
                        }

                        if( !empty( $src ) ) {
                            $lordicon = $this->get_repeater_setting_key( 'lordicon', 'items', $index );

                            $this->add_render_attribute( $lordicon, [
                                'class'   => 'kfw-elementor-lordicon',
                                'src'     => $src,
                                'stroke'  => 45,
                                'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                'trigger' => 'click'
                            ]);

                            /**
                             * Colors
                             */
                                $colors = '';
                                $colors .= !empty( $settings['lordicon_primary_color'] ) ? 'primary:'.$settings['lordicon_primary_color'].',': '';
                                $colors .= !empty( $settings['lordicon_secondary_color'] ) ? 'secondary:'.$settings['lordicon_secondary_color'].',': '';
                                $colors .= !empty( $settings['lordicon_tertiary_color'] ) ? 'tertiary:'.$settings['lordicon_tertiary_color'].',': '';
                                if( !empty( $colors ) ) {
                                    $this->add_render_attribute( $lordicon, 'colors', $colors );
                                }

                            echo '<div class="kfw-horiz-scroll-ele-title-icon-wrap kfw-horiz-scroll-ele-title-lordicon-type">';
                                echo '<span class="kfw-elementor-icon-wrap">';
                                    echo '<lord-icon '. $this->get_render_attribute_string( $lordicon ) .'></lord-icon>';
                                echo '</span>';
                            echo '</div>';
                        }
                    }
                }

                echo '<div class="kfw-horiz-scroll-ele-info-wrap">';
                    /**
                     * Prefix & Title
                     */
                    $prefix = trim( $item['prefix'] );
                    $title  = trim( $item['title'] );
                    echo '<div class="kfw-horiz-scroll-ele-title-wrap">';
                        if( !empty( $prefix ) ) {
                            echo '<div class="kfw-horiz-scroll-ele-prefix">';
                                echo wp_kses( $prefix, [ 'strong' => '', 'br' => '' ] );
                            echo '</div>';
                        }

                        if( !empty( $title ) ) {
                            echo '<div class="kfw-horiz-scroll-ele-title">';
                                echo wp_kses( $title, [ 'strong' => '', 'br' => '' ] );
                            echo '</div>';
                        }
                    echo '</div>';

                    /**
                     * Content
                     */
                    echo '<div class="kfw-horiz-scroll-ele-content-wrap">';
                        echo $this->parse_text_editor( $item['editor'] );
                    echo '</div>';
                echo '</div>';                

            echo '</div>';
        endforeach;
    echo '</div>';

echo '</div>';