<?php
/**
 * Widget Template : Image Hotspots
 */

$settings = $this->get_settings();

if (empty($settings['image']['url'])) {
    return;
}

$this->add_render_attribute( 'wrapper', [
	'id'    => 'kfw-elementor-widget-image-hotspots-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-elementor-widget-image-hotspots-wrapper' ],
] );

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';

    /**
     * Image
     */
    $image_src = $this->_get_image_src( $settings['image']['id'], 'image_size', $settings );
    $image_src = empty($image_src) ? $settings['image']['url'] : $image_src;

    $image_title = $this->_get_image_title( $settings['image'] );
    $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

    $image_alt = $this->_get_image_alt( $settings['image'] );
    $image_alt = empty( $image_alt ) ? $image_title : $image_alt;

	$this->add_render_attribute( 'image_attr', [
		'class' => 'kfw-elementor-widget-image-hotspots-image',
		'alt'   => esc_attr( $image_alt ),
		'title' => esc_attr( $image_title ),
		'src'   => esc_url( $image_src ),
	] );

    echo '<img '.$this->get_render_attribute_string( 'image_attr' ).'/>';

    /**
     * Hotspots
     */
    $hotspots = $settings['hotspots'];
    if( $hotspots ) {

        $this->add_render_attribute( 'hotspots_wrapper', [
            'class' => [ 'kfw-elementor-image-hotspots-wrapper' ],
        ] );

        echo '<div '.$this->get_render_attribute_string( 'hotspots_wrapper' ).'>';
            foreach( $hotspots as $index => $item ) {

                $type    = $item['type'];
                $tooltip = $item['tooltip'];

                /**
                 * Shape
                 */
                $is_global_shape = $item['use_global_shape_settings'];
                $shape           = $item['shape'];

                if( $is_global_shape === 'yes' ) {
                    $shape = $settings['shape'];
                } else {
                    if( $shape === 'global' ) {
                        $shape = $settings['shape'];
                    }
                }

                $hotspot_tag = 'div';
                $hotspot     = $this->get_repeater_setting_key( 'hotspot', 'hotspots', $index );

                $this->add_render_attribute( $hotspot, [
                    'class'                         => array_filter([
                        'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                        'kfw-elementor-image-hotspot',
                        'kfw-elementor-image-hotspot-'. esc_attr( $type ) .'-type',
                        'kfw-elementor-image-hotspot-shape',
                        'kfw-elementor-image-hotspot-'. esc_attr( $shape ) .'-shape-type',
                        ( $item['pulse'] == "block" ) ? "kfw-elementor-image-hotspot-has-pulse" : "",
                        !empty( $item[ 'css_classes' ] ) ? esc_attr( $item['css_classes'] ) : "",
                    ])
                ]);

                if( $tooltip === 'yes' ) {

                    /**
                     * Animation
                     */
                    $animation = $item['animation'];
                    if( $animation === 'global' ) {
                        $animation = $settings['anim'];
                    }

                    /**
                     * Arrow
                     */
                    $arrow = $item['arrow'];
                    if( $arrow === 'global' ) {
                        $arrow = $settings['arrow'];
                    }

                    if( $arrow === 'yes' ) {
                        $arrow = true;
                    } else if( $arrow === 'no' ) {
                        $arrow = false;
                    }

                    /**
                     * Position
                     */
                    $position = $item['position'];
                    if( $position === 'global' ) {
                        $position = $settings['position'];
                    }

                    /**
                     * Trigger
                     */
                    $trigger = $item['trigger'];
                    if( $trigger === 'global' ) {
                        $trigger = $settings['trigger'];
                    }

                    /**
                     * Customize It.
                     */
                    $customize = $item['customize'];

                    $defaults = [
                        'active'    => ( $item['open'] === "yes" ) ? true : false,
                        'animation' => $animation,
                        'arrow'     => $arrow,
                        'position'  => $position,
                        'trigger'   => $trigger
                    ];

                    if( !empty( $item['maxwidth']['size'] ) ) {
                        $defaults['maxwidth'] = $item['maxwidth']['size'];
                    }

                    $this->add_render_attribute( $hotspot, [
                        'class'         => array_filter([
                            'kfw-elementor-image-hotspot-has-tooltip',
                            $customize === 'yes' ? 'kfw-elementor-image-hotspot-customized' : ''
                        ]),

                        'data-settings' => wp_json_encode( $defaults )
                    ]);

                    if( $customize === 'yes' ) {

                        $this->add_render_attribute( $hotspot, [
                            'data-kf-class' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ).'-kfw-customized-wrap'
                        ]);
                    }
                }

				/**
				 * Linked hotspot
				 */
				$link = array_filter( $item['link'] );
				if( !empty( $link ) ) {
                    $hotspot_tag = 'a';

                    $this->add_render_attribute( $hotspot, [
                        'class' => [ 'kfw-elementor-image-hotspot-linked' ],
                        'href'  => esc_url( $link['url'] ),
                    ]);

					if( isset( $link['is_external'] ) ) {
						$this->add_render_attribute( $hotspot, 'target', '_blank' );
					}

					if( isset( $link['nofollow'] ) ) {
						$this->add_render_attribute( $hotspot, 'rel', 'nofollow' );
					}
                }

                echo '<'.$hotspot_tag.' '.$this->get_render_attribute_string( $hotspot ).'>';

                    if( $type === "dot" ) {
                        echo '<span class="kfw-elementor-image-hotspot-span kfw-elementor-widget-image-hotspots-icon-dot"></span>';
                    } elseif( $type === "icon" ) {
                        $this->_render_icons( $item['icon'] );
                    } elseif( $type === "image" ) {
                        printf("<span class='kfw-elementor-image-hotspot-span'> %s </span>",  wp_get_attachment_image($item['image']['id'], 'full' ) );
                    } elseif( $type === "text" ) {
                        printf("<span class='kfw-elementor-image-hotspot-span'> %s </span>", $item["text"] );
                    }

                    /**
                     * Tooltip
                     */
                        if( $tooltip === 'yes' ) {

                            $content = '';

                            $source  = $item['source'];

                            if( $source == 'editor' ) {
                                $content = $this->parse_text_editor( $item['editor'] );
                            } else if( $source == 'template' && ( $item['template'] != '0' && !empty( $item['template'] ) ) ) {
                                $content = $this->_generate_template_content( $item['template'] );
                            }

                            if( !empty( $content ) ) {
                                $this->add_render_attribute( 'tooltip_wrapper', [
                                    'class' => [ 'kfw-hidden', 'kfw-elementor-image-tooltip-wrapper' ],
                                ] );

                                echo '<div '.$this->get_render_attribute_string( 'tooltip_wrapper' ).'>';

                                    $this->add_render_attribute( 'tooltip_content', [
                                        'class' => [
                                            'kfw-elementor-image-tooltip-content',
                                            $customize === 'yes' ? 'elementor-repeater-item-'. esc_attr( $item['_id'] ) .'-kfw-customized' : ''
                                        ],
                                    ] );

                                    echo '<div '.$this->get_render_attribute_string( 'tooltip_content' ).'>';
                                        echo $content;
                                    echo '</div>';

                                echo '</div>';
                            }

                        }

                echo '</'.$hotspot_tag.'>';

            }
        echo '</div>';

    }

echo '</div>';