<?php
/**
 * Widget Template : Rounded Text
 */

$settings = $this->get_settings();
$title    = $settings['title'];

if( empty( $title ) ) {
    return;
}

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-rounded-txt-'.esc_attr( $this->get_id() ),
    'class' => [
        'kfw-ele-widget-rounded-txt-main',
        'yes' === $settings['spin'] ? 'kfw-ele-widget-rounded-txt-animate' : '',
        'yes' === $settings['spin'] ? 'kfw-ele-widget-rounded-txt-anim-'. $settings['spin_dir'] : '',
        ( 'yes' === $settings['spin'] && 'yes' === $settings['pause'] ) ? 'kfw-ele-widget-rounded-txt-anim-pause' : '',
    ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
    /**
     * SVG
     */
        echo '<div class="kfw-ele-widget-rounded-txt-svg-wrapper">';
            echo '<svg class="kfw-ele-widget-rounded-txt-svg" viewBox="0 0 144.48 144.48" width="200" height="200">';
                printf(
                    '<path id="kfw-ele-widget-rounded-txt-path-id-%1$s" d="M242.93,123A71.74,71.74,0,1,1,171.2,51.22,71.73,71.73,0,0,1,242.93,123Z" transform="translate(-98.96 -50.72)"></path>',
                    esc_attr( $this->get_id() ),
                );

                printf('
                    <text class="kfw-ele-widget-rounded-txt-path-wrap kfw-ele-widget-rounded-txt-path-wrap-%1$s">
                        <textPath class="kfw-ele-widget-rounded-txt-path" href="#kfw-ele-widget-rounded-txt-path-id-%1$s">
                            %2$s
                        </textPath>
                    </text>',
                    esc_attr( $this->get_id() ),
                    esc_html( $title )
                );
            echo '</svg>';
        echo '</div>';

    /**
     * Middle Item
     */
        if( $settings['icon_type'] !== 'blank'  ) {

            $this->add_render_attribute( 'icon-wrap', [
                'class' => [
                    'kfw-ele-widget-rounded-txt-icon-wrap',
                    'kfw-ele-widget-rounded-txt-'.esc_attr( $settings['icon_type'] ) . '-type'
                ],
            ]);

            echo '<div '.$this->get_render_attribute_string( 'icon-wrap' ).'>';
                if( $settings['icon_type'] === 'icon' ) {
                    $this->_render_icon( $settings['icon'] );
                } else if( $settings['icon_type'] === 'image' ) {
                    $this->_render_img( $settings );
                } else if( $settings['icon_type'] === 'input' ) {
                    $this->_render_input( $settings['input'] );
                }

            echo '</div>';

        }

echo '</div>';