<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
use \Elementor\Plugin as KFEl;
use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Repeater as KFRTR;
use \Elementor\Icons_Manager as KFIM;

use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;

class KFW_Accordion extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-accordion';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Accordion', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_core_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-accordion';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'accordion', 'simple' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/accordion';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        $edit_mode = $this->_is_editor_mode();

        wp_register_style( 'kfw-accordion',
            KFE_CONST_URL . 'libraries/elementor/assets/css/accordion' . KFE_CONST_DEBUG_SUFFIX . '.css',
            [],
            KFE_CONST_VERSION
        );

        wp_register_script( 'lordicon',
            KFE_CONST_URL . 'libraries/elementor/assets/js/lordicon.js',
            [],
            KFE_CONST_VERSION,
            true
        );

        wp_register_script( 'kfw-accordion',
            KFE_CONST_URL . 'libraries/elementor/assets/js/accordion' . KFE_CONST_DEBUG_SUFFIX . '.js',
            [ 'jquery', 'elementor-frontend' ],
            KFE_CONST_VERSION,
            true
        );
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return ['kfw-accordion'];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return ['lordicon', 'kfw-accordion'];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_accordion_section();
		$this->_register_settings_section();

		$this->_register_accordion_style_section();
        $this->_register_title_icon_style_section();
        $this->_register_title_style_section();
		$this->_register_sub_title_style_section();
        $this->_register_content_style_section();
        $this->_register_handler_style_section();
    }

    public function _register_accordion_section() {
		$repeater = new KFRTR();

		$this->start_controls_section( 'section_accordion', [
			'label' => esc_html__( 'Accordion Items', 'onnat-extra' )
		]);
            $repeater->start_controls_tabs('accordion_tabs');
                $repeater->start_controls_tab('tab_content',[
                    'label' => esc_html__( 'Content', 'onnat-extra' ),
                ]);
                    $repeater->add_control('title',[
                        'label'       => esc_html__( 'Title', 'onnat-extra' ),
                        'type'        => KFCM::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Accordion Title' , 'onnat-extra' ),
                        'label_block' => true,
                    ]);
                    $repeater->add_control('sub_title',[
                        'label'       => esc_html__( 'Sub Title', 'onnat-extra' ),
                        'type'        => KFCM::TEXT,
                        'dynamic'     => [ 'active' => true, ],
                        'placeholder' => esc_html__( 'Sub Title', 'onnat-extra' ),
                        'label_block' => true,
                    ]);
                    $repeater->add_control( 'source', [
                        'label'   => esc_html__( 'Content Source', 'onnat-extra' ),
                        'type'    => KFCM::CHOOSE,
                        'options' => [
                            'editor'  => [
                                'title' => esc_html__('Editor', 'onnat-extra'),
                                'icon'  => 'eicon-text-area',
                            ],
                            'template'  => [
                                'title' => esc_html__('Template', 'onnat-extra'),
                                'icon'  => 'eicon-t-letter',
                            ],
                        ],
                        'default' => 'editor',
                        'toggle'  => false,
                    ]);
                    $repeater->add_control( 'editor', [
                        'label' => esc_html__('Editor', 'onnat-extra'),
                        'type'      => KFCM::WYSIWYG,
                        'default'   => esc_html__( 'Accordion Item Content', 'onnat-extra'),
                        'condition' => [
                            'source'  => 'editor',
                        ],
                    ]);
                    $repeater->add_control( 'template', [
                        'label'     => esc_html__('Template', 'onnat-extra'),
                        'type'      => KFCM::SELECT,
                        'default'   => 0,
                        'options'   => kf_extra_plugin_elementor()->get_elementor_library(),
                        'condition' => [
                            'source'  => 'template',
                        ],
                    ]);
                $repeater->end_controls_tab();
                $repeater->start_controls_tab('tab_icon',[
                    'label' => esc_html__( 'Icon', 'onnat-extra' ),
                ]);
                    $repeater->add_control('icons_settings_des', [
                        'type'            => KFCM::RAW_HTML,
                        'content_classes' => 'kfw-elementor-editor-notice-ctrl',
                        'raw'             => sprintf(
                            esc_html__('Icon settings reflects only if %1$s Use Title Icon option %2$s is set to %1$sYES%2$s.', 'onnat-extra'),
                            '<b> <i> ', '<i> </b>'
                        ),
                    ]);
                    $repeater->add_control('icon_type',[
                        'label'   => esc_html__( 'Icon Type', 'onnat-extra' ),
                        'type'    => KFCM::CHOOSE,
                        'options' => [
                            'blank'             => [
                                'title' => esc_html__('Blank', 'onnat-extra'),
                                'icon'  => '',
                            ],
                            'icon'              => [
                                'title' => esc_html__('Icon', 'onnat-extra'),
                                'icon'  => 'eicon-plus-circle-o',
                            ],
                            'image'             => [
                                'title' => esc_html__('Image', 'onnat-extra'),
                                'icon'  => 'eicon-image',
                            ],
                            'lordicon_media'    => [
                                'title' => esc_html__('Upload Lordicon From Media', 'onnat-extra'),
                                'icon'  => 'eicon-library-upload',
                            ],
                            'lordicon_external' => [
                                'title' => esc_html__('Upload Lordicon From Extrnal', 'onnat-extra'),
                                'icon'  => 'eicon-editor-external-link',
                            ],
                        ],
                        'default' => 'blank',
                        'toggle'  => false
                    ]);
                    $repeater->add_control( 'icon', [
                        'label'     => esc_html__( 'Icon', 'onnat-extra' ),
                        'type'      => KFCM::ICONS,
                        'default'   => [
                            'value'   => 'fas fa-heart',
                            'library' => 'fa-solid',
                        ],
                        'condition' => [
                            'icon_type' => 'icon'
                        ],
                    ]);
                    $repeater->add_control( 'image', [
                        'label'     => esc_html__( 'Image', 'onnat-extra' ),
                        'type'      => KFCM::MEDIA,
                        'dynamic'   => [ 'active' => true ],
                        'default'   => [
                            'url' => \Elementor\Utils::get_placeholder_image_src()
                        ],
                        'condition' => [
                            'icon_type' => 'image'
                        ],
                    ]);
                    $repeater->add_control('lordicon_des', [
                        'type'            => KFCM::RAW_HTML,
                        'content_classes' => 'kfw-elementor-editor-notice-ctrl',
                        'raw'             => sprintf(
                            esc_html__('You can get lordicon code from %1$s ', 'onnat-extra'),
                            sprintf('<a href="%1$s" target="_blank">%2$s</a>', esc_url( 'https://lordicon.com/' ), esc_html_x( 'Lordicon.com', 'link text for lordicon.com', 'onnat-extra' ) )
                        ),
                        'condition'       => [
                            'icon_type' => [ 'lordicon_media', 'lordicon_external' ]
                        ],
                    ]);
                    $repeater->add_control('lordicon_media', [
                        'label'      => esc_html__( 'Upload JSON File', 'onnat-extra' ),
                        'type'       => KFCM::MEDIA,
                        'media_type' => 'application/json',
                        'default'    => [
                            'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                        ],
                        'condition'  => [
                            'icon_type' => 'lordicon_media'
                        ]
                    ]);
                    $repeater->add_control('lordicon_external', [
                        'label'       => esc_html__( 'Upload JSON File', 'onnat-extra' ),
                        'type'        => KFCM::URL,
                        'dynamic'     => [ 'active' => true, ],
                        'placeholder' => esc_html__( 'Enter your URL', 'onnat-extra' ),
                        'options'     => [ 'url' ],
                        'default'     => [
                            'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                        ],
                        'condition'   => [
                            'icon_type' => 'lordicon_external'
                        ]
                    ]);
                $repeater->end_controls_tab();
            $repeater->end_controls_tabs();

            $this->add_control('items', [
                'type'    => KFCM::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
						'title'     => 'Accordion #1',
						'sub_title' => '',
						'source'    => 'editor',
						'editor'    => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin sit amet auctor odio. Donec finibus, sem sed facilisis eleifend, mi ligula faucibus neque, sed tristique libero ante ac dui. Phasellus fermentum velit non elit euismod molestie. Curabitur congue magna eget est dapibus eleifend. Praesent sed est vel lectus viverra porta. Nunc egestas dui eget cursus ullamcorper. Integer mollis dapibus sollicitudin. Nullam turpis erat, dignissim egestas metus elementum, ornare elementum leo. Vestibulum ullamcorper cursus accumsan. Donec a eros non dolor faucibus tincidunt. Integer eros felis, gravida ut lacus vel, porta efficitur erat. Ut in sagittis elit, eget ullamcorper orci.',
                    ],
                    [
                        'title'     => 'Accordion #2',
                        'sub_title' => '',
                        'source'    => 'editor',
                        'editor'    => 'Sed sed tortor faucibus, rutrum quam scelerisque, maximus felis. Sed sagittis arcu at est semper, nec facilisis metus consectetur. Mauris sed auctor lacus. Fusce sit amet nisi risus. Duis in sagittis ligula. Quisque non nunc quam. Pellentesque sagittis leo ante, ac efficitur massa convallis in. Phasellus a sagittis purus, a scelerisque nisl. Duis scelerisque, nibh eu condimentum mattis, magna nisi lacinia ligula, ac varius lacus odio nec dui. Donec eget auctor enim, vehicula suscipit ex.',
                    ],
                    [
                        'title'     => 'Accordion #3',
                        'sub_title' => '',
                        'source'    => 'editor',
                        'editor'    => 'Vestibulum euismod lacus vitae ipsum bibendum, vitae condimentum mi efficitur. Praesent molestie laoreet neque nec mattis. Maecenas in metus at nibh efficitur auctor. Suspendisse ante mauris, pretium sit amet pellentesque ornare, viverra non magna. Donec velit urna, efficitur eu ex at, interdum commodo elit. Ut lobortis, sapien sit amet pretium laoreet, tellus ex condimentum lorem, id maximus nibh massa vel justo. Curabitur bibendum, nibh vitae molestie bibendum, massa ligula varius quam, et luctus lectus leo vel ex. Proin sit amet ligula leo. Vivamus ultricies purus ut libero feugiat mollis.',
                    ],
                    [
                        'title'     => 'Accordion #4',
                        'sub_title' => '',
                        'source'    => 'editor',
                        'editor'    => 'Maecenas at lacus ac dui aliquam aliquam. Nam sit amet maximus felis. Vivamus suscipit justo in ipsum fringilla hendrerit. Proin convallis felis massa, sed feugiat nunc condimentum sed. Mauris tincidunt congue erat ut iaculis. Pellentesque ac quam velit. Pellentesque leo arcu, suscipit eget volutpat vel, tincidunt a erat. Donec nec ex vitae dolor feugiat blandit. Vivamus facilisis metus et massa semper, ac ultrices dui pharetra. Proin id leo placerat, varius libero vitae, tempus est.',
                    ],
                    [
                        'title'     => 'Accordion #5',
                        'sub_title' => '',
                        'source'    => 'editor',
                        'editor'    => 'Etiam lacinia lorem vitae enim tempor condimentum. Vestibulum sed fringilla metus. Morbi fringilla, libero bibendum convallis ultrices, erat tortor egestas dolor, vitae vulputate libero elit nec felis. Nulla elit nisi, rutrum at diam ac, vehicula pretium dolor. Fusce sit amet turpis diam. Quisque ullamcorper metus at nisl porttitor varius. Sed in dolor fermentum, feugiat turpis in, facilisis neque. In nec massa eu felis ultricies feugiat ac id nulla. Donec eget nulla nulla. Pellentesque tempor',
                    ],
                ]
            ]);

            $this->add_control('accordion_hr0', [
                'type' => KFCM::DIVIDER,
            ]);
            $this->add_control('accordion_type',[
                'label'   => esc_html__( 'Accordion Type', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'toggle'  => false,
                'default' => 'type-1',
                'options' => [
                    'type-1' => [
                        'title' => esc_html__('Type 1', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-1-icon'
                    ],
                    'type-2' => [
                        'title' => esc_html__('Type 2', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-2-icon'
                    ],
                    'type-3' => [
                        'title' => esc_html__('Type 3', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-3-icon'
                    ],
                ],
                'prefix_class' => 'kfw-accordion-type kfw-accordion-',
            ]);
            $this->add_control('use_title_icon',[
                'label'        => esc_html__( 'Use Title Icon?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes'
            ]);
		$this->end_controls_section();
    }

    public function _register_settings_section() {
		$this->start_controls_section( 'section_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' )
		]);
            $this->add_control('active_accordion', [
                'label'   => esc_html__( 'Active Item Number', 'onnat-extra' ),
                'type'    => KFCM::NUMBER,
                'min'     => 1,
                'max'     => 20,
                'step'    => 1,
                'default' => 1,
            ]);
            $this->add_control('multiple_open',[
                'label'        => esc_html__( 'Multiple Open?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes',
            ]);
            $this->add_control('hr_1', [
                'type' => KFCM::DIVIDER,
            ]);
            $this->add_control('handler_icon_settings_heading',[
                'label' => esc_html__( 'HANDLER ICON SETTINGS', 'onnat-extra' ),
                'type'  => KFCM::HEADING,
            ]);
            $this->add_control('handler_icon_type',[
                'label'       => esc_html__( 'Icon Type', 'onnat-extra' ),
                'type'        => KFCM::CHOOSE,
                'options'     => [
                    'blank'             => [
                        'title' => esc_html__('Blank', 'onnat-extra'),
                        'icon'  => '',
                    ],
                    'icon'              => [
                        'title' => esc_html__('Icon', 'onnat-extra'),
                        'icon'  => 'eicon-plus-circle-o',
                    ],
                    'image'             => [
                        'title' => esc_html__('Image', 'onnat-extra'),
                        'icon'  => 'eicon-image',
                    ],
                    'lordicon_media'    => [
                        'title' => esc_html__('Upload Lordicon From Media', 'onnat-extra'),
                        'icon'  => 'eicon-library-upload',
                    ],
                    'lordicon_external' => [
                        'title' => esc_html__('Upload Lordicon From Extrnal', 'onnat-extra'),
                        'icon'  => 'eicon-editor-external-link',
                    ],
                ],
                'default' => 'icon',
                'toggle'  => false
            ]);
            $this->add_control( 'handler_align', [
                'label'       => esc_html__('Alignment', 'onnat-extra' ),
                'label_block' => false,
                'type'        => KFCM::CHOOSE,
                'options'     => [
                    'left'  => [
                        'title' => esc_html__('Start', 'onnat-extra'),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'right' => [
                        'title' => esc_html__('End', 'onnat-extra'),
                        'icon'  => 'eicon-h-align-right',
                    ],
                ],
                'toggle'      => false,
                'default'     => is_rtl() ? 'left' : 'right',
                'condition'   => [
                    'handler_icon_type!' => 'blank',
                    'use_title_icon!'    => 'yes'
                ],
            ]);
            $this->add_control( 'handler_icon_icon', [
                'label'       => esc_html__( 'Icon', 'onnat-extra' ),
                'label_block' => false,
                'type'        => KFCM::ICONS,
                'default'     => [
                    'value' => 'fas fa-plus',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid'   => [
                        'chevron-down',
                        'angle-down',
                        'angle-double-down',
                        'caret-down',
                        'caret-square-down',
                    ],
                    'fa-regular' => [
                        'caret-square-down',
                    ],
                ],
                'skin'        => 'inline',
                'condition'   => [
                    'handler_icon_type' => 'icon'
                ],
            ]);
            $this->add_control( 'handler_icon_active_icon', [
                'label'       => esc_html__( 'Active Icon', 'onnat-extra' ),
                'label_block' => false,
                'type'        => KFCM::ICONS,
                'default'     => [
                    'value' => 'fas fa-minus',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid'   => [
                        'chevron-up',
                        'angle-up',
                        'angle-double-up',
                        'caret-up',
                        'caret-square-up',
                    ],
                    'fa-regular' => [
                        'caret-square-up',
                    ],
                ],
                'skin'        => 'inline',
                'condition'   => [
                    'handler_icon_type' => 'icon'
                ],
            ]);
            $this->add_control( 'handler_icon_image', [
                'label'     => esc_html__( 'Image', 'onnat-extra' ),
                'type'      => KFCM::MEDIA,
                'dynamic'   => [ 'active' => true ],
                'default'   => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
                'condition' => [
                    'handler_icon_type' => 'image'
                ],
            ]);
            $this->add_control( 'handler_icon_active_image', [
                'label'     => esc_html__( 'Active Image', 'onnat-extra' ),
                'type'      => KFCM::MEDIA,
                'dynamic'   => [ 'active' => true ],
                'default'   => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
                'condition' => [
                    'handler_icon_type' => 'image'
                ],
            ]);
            $this->add_control('handler_icon_lordicon_des', [
                'type'            => KFCM::RAW_HTML,
                'content_classes' => 'kfw-elementor-editor-notice-ctrl',
                'raw'             => sprintf(
                    esc_html__('You can get lordicon code from %1$s ', 'onnat-extra'),
                    sprintf('<a href="%1$s" target="_blank">%2$s</a>', esc_url( 'https://lordicon.com/' ), esc_html_x( 'Lordicon.com', 'link text for lordicon.com', 'onnat-extra' ) )
                ),
                'condition'       => [
                    'handler_icon_type' => [ 'lordicon_media', 'lordicon_external' ]
                ],
            ]);
            $this->add_control('handler_icon_lordicon_media', [
                'label'      => esc_html__( 'Upload JSON File For Normal State', 'onnat-extra' ),
                'type'       => KFCM::MEDIA,
                'media_type' => 'application/json',
                'default'    => [
                    'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                ],
                'condition'  => [
                    'handler_icon_type' => 'lordicon_media'
                ]
            ]);
            $this->add_control('handler_icon_active_lordicon_media', [
                'label'      => esc_html__( 'Upload JSON File For Active State', 'onnat-extra' ),
                'type'       => KFCM::MEDIA,
                'media_type' => 'application/json',
                'default'    => [
                    'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                ],
                'condition'  => [
                    'handler_icon_type' => 'lordicon_media'
                ]
            ]);
            $this->add_control('handler_icon_lordicon_external', [
                'label'       => esc_html__( 'Upload JSON File For Normal State', 'onnat-extra' ),
                'type'        => KFCM::URL,
                'dynamic'     => [ 'active' => true, ],
                'placeholder' => esc_html__( 'Enter your URL', 'onnat-extra' ),
                'options'     => [ 'url' ],
                'default'     => [
                    'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                ],
                'condition'   => [
                    'handler_icon_type' => 'lordicon_external'
                ]
            ]);
            $this->add_control('handler_icon_active_lordicon_external', [
                'label'       => esc_html__( 'Upload JSON File For Active State', 'onnat-extra' ),
                'type'        => KFCM::URL,
                'dynamic'     => [ 'active' => true, ],
                'placeholder' => esc_html__( 'Enter your URL', 'onnat-extra' ),
                'options'     => [ 'url' ],
                'default'     => [
                    'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                ],
                'condition'   => [
                    'handler_icon_type' => 'lordicon_external'
                ]
            ]);
		$this->end_controls_section();
    }

    public function _register_accordion_style_section() {
		$this->start_controls_section( 'section_accordion_style', [
			'label' => esc_html__( 'Accordion', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_responsive_control( 'items_gap', [
                'label'      => esc_html__('Items Gap', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-accordion-item:not(:last-child)' => 'margin-bottom:{{SIZE}}{{UNIT}};',
                ],
            ]);
			$this->add_responsive_control( 'items_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
					'{{WRAPPER}} .kfw-accordion-header-wrap' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
            $this->start_controls_tabs( 'items_customize_tabs');
                $this->start_controls_tab( 'items_normal_state', [
                    'label'     => esc_html__( 'Normal', 'onnat-extra' ),
                ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'items_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'selector'       => '{{WRAPPER}}.kfw-accordion-type-1 .kfw-accordion-header-wrap, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item, {{WRAPPER}}.kfw-accordion-type-3 .kfw-accordion-header-wrap',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'items_border',
                        'selector'  => '{{WRAPPER}}.kfw-accordion-type-1 .kfw-accordion-header-wrap, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item, {{WRAPPER}}.kfw-accordion-type-3 .kfw-accordion-header-wrap'
                    ]);
                    $this->add_responsive_control( 'items_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}}.kfw-accordion-type-1 .kfw-accordion-header-wrap, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item, {{WRAPPER}}.kfw-accordion-type-3 .kfw-accordion-header-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'items_box_shadow',
                        'selector'  => '{{WRAPPER}}.kfw-accordion-type-1 .kfw-accordion-header-wrap, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item, {{WRAPPER}}.kfw-accordion-type-3 .kfw-accordion-header-wrap'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'items_hover_state', [
                    'label'     => esc_html__( 'Hover', 'onnat-extra' ),
                ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'items_hover_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'selector'       => '{{WRAPPER}}.kfw-accordion-type-1 .kfw-accordion-header-wrap:hover, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item:hover, {{WRAPPER}}.kfw-accordion-type-3 .kfw-accordion-header-wrap:hover',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'items_hover_border',
                        'selector'  => '{{WRAPPER}}.kfw-accordion-type-1 .kfw-accordion-header-wrap:hover, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item:hover, {{WRAPPER}}.kfw-accordion-type-3 .kfw-accordion-header-wrap:hover'
                    ]);
                    $this->add_responsive_control( 'items_hover_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}}.kfw-accordion-type-1 .kfw-accordion-header-wrap:hover, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item:hover, {{WRAPPER}}.kfw-accordion-type-3 .kfw-accordion-header-wrap:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'items_hover_box_shadow',
                        'selector'  => '{{WRAPPER}}.kfw-accordion-type-1 .kfw-accordion-header-wrap:hover, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item:hover, {{WRAPPER}}.kfw-accordion-type-3 .kfw-accordion-header-wrap:hover'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'items_active_state', [
                    'label'     => esc_html__( 'Active', 'onnat-extra' ),
                ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'items_active_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'selector'       => '{{WRAPPER}}.kfw-accordion-type-1 .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-header-wrap, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item.kfw-elementor-active-accordion, {{WRAPPER}}.kfw-accordion-type-3 .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-header-wrap',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'items_active_border',
                        'selector'  => '{{WRAPPER}}.kfw-accordion-type-1 .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-header-wrap, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item.kfw-elementor-active-accordion, {{WRAPPER}}.kfw-accordion-type-3 .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-header-wrap'
                    ]);
                    $this->add_responsive_control( 'items_active_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}}.kfw-accordion-type-1 .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-header-wrap, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item.kfw-elementor-active-accordion, {{WRAPPER}}.kfw-accordion-type-3 .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-header-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'items_active_box_shadow',
                        'selector'  => '{{WRAPPER}}.kfw-accordion-type-1 .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-header-wrap, {{WRAPPER}}.kfw-accordion-type-2 .kfw-elementor-accordion-item.kfw-elementor-active-accordion, {{WRAPPER}}.kfw-accordion-type-3 .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-header-wrap'
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

    public function _register_title_icon_style_section() {
		$this->start_controls_section( 'section_icon_style', [
			'label' => esc_html__( 'Title Icon', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_responsive_control( 'icon_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-title-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'icon_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-title-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);

            /**
             * Style: Icon Type
             */
                $this->add_control('icon_type_style_before_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_control('icon_type_style_heading',[
					'label' => esc_html__( 'Icon Type Style', 'onnat-extra' ),
					'type'  => KFCM::HEADING,
				]);
				$this->add_control('icon_type_style_after_hr', [
					'type' => KFCM::DIVIDER,
				]);
                $this->add_responsive_control( 'icon_type_size', [
                    'label'      => esc_html__('Size', 'onnat-extra' ),
                    'type'       => KFCM::SLIDER,
                    'size_units' => [ 'px' ],
                    'range'      => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kfw-accordion-title-icon-wrap.kfw-accordion-title-icon-type .kfw-elementor-icon-wrap svg, {{WRAPPER}} .kfw-accordion-title-icon-wrap.kfw-accordion-title-icon-type .kfw-elementor-icon-wrap i' => 'font-size: {{SIZE}}{{UNIT}};'
                    ],
                ]);
				$this->add_control( 'icon_color_settings', [
                    'label'        => esc_html__('Colors', 'onnat-extra'),
					'type'         => KFCM::POPOVER_TOGGLE,
					'return_value' => 'yes',
				]);
                $this->start_popover();
                    $this->add_control( 'icon_type_color', [
                        'label'     => esc_html__('Normal Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => [
                        '{{WRAPPER}} .kfw-accordion-title-icon-wrap.kfw-accordion-title-icon-type .kfw-elementor-icon-wrap' => 'color:{{VALUE}};fill:{{VALUE}};',
                        ],
                    ]);
                    $this->add_control( 'icon_type_hover_color', [
                        'label'     => esc_html__('Hover Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .kfw-accordion-header-wrap:hover .kfw-accordion-title-icon-wrap.kfw-accordion-title-icon-type .kfw-elementor-icon-wrap' => 'color:{{VALUE}};fill:{{VALUE}};',
                        ],
                    ]);
                    $this->add_control( 'icon_type_active_color', [
                        'label'     => esc_html__('Active Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.kfw-accordion-type-1 .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-title-icon-wrap.kfw-accordion-title-icon-type .kfw-elementor-icon-wrap svg' => 'fill:{{VALUE}};',
                            '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-title-icon-wrap.kfw-accordion-title-icon-type .kfw-elementor-icon-wrap' => 'color:{{VALUE}};fill:{{VALUE}};',
                        ],
                    ]);
                $this->end_popover();

            /**
             * Style: Image Type
             */
                $this->add_control('img_type_style_before_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_control('img_type_style_heading',[
                    'label' => esc_html__( 'Image Type Style', 'onnat-extra' ),
                    'type'  => KFCM::HEADING,
                ]);
                $this->add_control('img_type_style_after_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_responsive_control( 'img_type_size', [
                    'label'      => esc_html__('Size', 'onnat-extra' ),
                    'type'       => KFCM::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min' => 5,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kfw-accordion-title-icon-wrap.kfw-accordion-title-image-type img' => 'max-width:{{SIZE}}px;'
                    ],
                ]);

            /**
             * Style: Lordicon Type
             */
                $this->add_control('lordicon_type_style_before_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_control('lordicon_type_style_heading',[
                    'label' => esc_html__( 'LordIcon Type Style', 'onnat-extra' ),
                    'type'  => KFCM::HEADING,
                ]);
                $this->add_control('lordicon_type_style_after_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_responsive_control( 'lordicon_type_size', [
                    'label'      => esc_html__('Size', 'onnat-extra' ),
                    'type'       => KFCM::SLIDER,
                    'size_units' => [ 'px' ],
                    'range'      => [
                        'px' => [
                            'min' => 1,
                            'max' => 300,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kfw-accordion-title-icon-wrap.kfw-accordion-title-lordicon-type .kfw-elementor-icon-wrap,
                        {{WRAPPER}} .kfw-accordion-title-icon-wrap.kfw-accordion-title-lordicon-type .kfw-elementor-lordicon' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};'
                    ]
                ]);
				$this->add_control( 'lordicon_color_settings', [
                    'label'        => esc_html__('Colors', 'onnat-extra'),
					'type'         => KFCM::POPOVER_TOGGLE,
					'return_value' => 'yes',
				]);
                $this->start_popover();
                    $this->add_control('lordicon_primary_color',[
                        'label'     => __( 'Primary Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'default'   => '#121331',
                    ]);
                    $this->add_control('lordicon_secondary_color',[
                        'label'   => __( 'Secondary Color', 'onnat-extra' ),
                        'type'    => KFCM::COLOR,
                        'default' => '#121331',
                    ]);
                    $this->add_control('lordicon_tertiary_color',[
                        'label'   => __( 'Tertiary Color', 'onnat-extra' ),
                        'type'    => KFCM::COLOR,
                        'default' => '#0816A8',
                    ]);
                $this->end_popover();
		$this->end_controls_section();
    }

    public function _register_title_style_section() {
		$this->start_controls_section( 'section_title_style', [
			'label' => esc_html__( 'Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'title_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-accordion-title',
            ]);
            $this->add_responsive_control( 'title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->start_controls_tabs( 'title_customize_tabs' );
                $this->start_controls_tab( 'title_normal_state', [
                    'label' => esc_html__( 'Normal', 'onnat-extra' ),
                ]);
                    $this->add_control( 'title_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-accordion-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'title_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-accordion-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'title_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-accordion-title',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'title_hover_state', [
                    'label' => esc_html__( 'Hover', 'onnat-extra' ),
                ]);
                    $this->add_control( 'title_hover_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-accordion-header-wrap:hover .kfw-accordion-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'title_hover_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-accordion-header-wrap:hover .kfw-accordion-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'title_hover_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-accordion-header-wrap:hover .kfw-accordion-title',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'title_active_state', [
                    'label' => esc_html__( 'Active', 'onnat-extra' ),
                ]);
                    $this->add_control( 'title_active_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'title_active_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'title_active_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-title',
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

    public function _register_sub_title_style_section() {
		$this->start_controls_section( 'section_sub_title_style', [
			'label' => esc_html__( 'Sub Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'sub_title_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-accordion-sub-title',
            ]);
            $this->add_responsive_control( 'sub_title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'sub_title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->start_controls_tabs( 'sub_title_customize_tabs' );
                $this->start_controls_tab( 'sub_title_normal_state', [
                    'label' => esc_html__( 'Normal', 'onnat-extra' ),
                ]);
                    $this->add_control( 'sub_title_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-accordion-sub-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'sub_title_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-accordion-sub-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'sub_title_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-accordion-sub-title',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'sub_title_hover_state', [
                    'label' => esc_html__( 'Hover', 'onnat-extra' ),
                ]);
                    $this->add_control( 'sub_title_hover_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-accordion-header-wrap:hover .kfw-accordion-sub-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'sub_title_hover_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-accordion-header-wrap:hover .kfw-accordion-sub-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'sub_title_hover_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-accordion-header-wrap:hover .kfw-accordion-sub-title',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'sub_title_active_state', [
                    'label' => esc_html__( 'Active', 'onnat-extra' ),
                ]);
                    $this->add_control( 'sub_title_active_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-sub-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'sub_title_active_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-sub-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'sub_title_active_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-sub-title',
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

    public function _register_content_style_section() {
		$this->start_controls_section( 'section_content_style', [
			'label' => esc_html__( 'Content', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'content_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-accordion-content-wrap.kfw-accordion-content-editor-type',
            ]);
            $this->add_responsive_control( 'content_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-content-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'content_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-content-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'content_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'selectors' => ['{{WRAPPER}} .kfw-accordion-content-wrap.kfw-accordion-content-editor-type' => 'color: {{VALUE}};' ],
            ]);
            $this->add_group_control( KFGCTS::get_type(), [
                'name'     => 'content_txt_shadow',
                'selector' => '{{WRAPPER}} .kfw-accordion-content-wrap.kfw-accordion-content-editor-type',
            ]);
            $this->add_group_control( KFGCTST::get_type(), [
                'name'     => 'content_txt_stroke',
                'selector' => '{{WRAPPER}} .kfw-accordion-content-wrap.kfw-accordion-content-editor-type',
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'           => 'content_bg',
                'types'          => ['classic', 'gradient'],
                'exclude'        => [ 'image'],
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color'      => [ 'default' => '' ],
                ],
                'selector'       => '{{WRAPPER}} .kfw-accordion-content-wrap.kfw-accordion-content-editor-type',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'content_border',
                'selector'  => '{{WRAPPER}} .kfw-accordion-content-wrap.kfw-accordion-content-editor-type'
            ]);
            $this->add_responsive_control( 'content_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-content-wrap.kfw-accordion-content-editor-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'content_box_shadow',
                'selector'  => '{{WRAPPER}} .kfw-accordion-content-wrap.kfw-accordion-content-editor-type'
            ]);
		$this->end_controls_section();
    }

    public function _register_handler_style_section() {
        $icon_condition = [
            'handler_icon_type' => 'icon'
        ];

        $img_condition = [
            'handler_icon_type' => 'image'
        ];

        $ld_condition = [
            'handler_icon_type' => [ 'lordicon_media', 'lordicon_external' ],
        ];

		$this->start_controls_section( 'section_icon_type_handler_style', [
            'label'     => esc_html__( 'Handler Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $icon_condition
		]);
            $this->add_responsive_control( 'handler_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'condition'  => $icon_condition,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type .kfw-accordion-handler-icon .kfw-elementor-icon-wrap svg' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type .kfw-accordion-handler-icon .kfw-elementor-icon-wrap i'   => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]);
			$this->add_responsive_control( 'handler_icon_margin', [
				'label'              => esc_html__('Margin', 'onnat-extra' ),
				'type'               => KFCM::DIMENSIONS,
				'size_units'         => [ 'px', 'em', '%' ],
				'allowed_dimensions' => [
                    'top',
                    'right',
                    'bottom',
                ],
				'placeholder'        => [
                    'top'    => '',
                    'right'  => '',
                    'bottom' => '',
                    'left'   => 'auto',
                ],
				'condition'          => $icon_condition,
				'selectors'          => [
					'{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type' => 'margin-top: {{TOP}}{{UNIT}}; margin-bottom: {{BOTTOM}}{{UNIT}}; margin-right: {{RIGHT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'handler_icon_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $icon_condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
            $this->start_controls_tabs( 'icon_type_handler_customize_tabs',[
                'condition' => $icon_condition
            ]);
                $this->start_controls_tab( 'icon_type_handler_normal_state', [
                    'label'     => esc_html__( 'Normal', 'onnat-extra' ),
                    'condition' => $icon_condition
                ]);
                    $this->add_control( 'handler_icon_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'condition' => $icon_condition,
                        'selectors' => [
                            '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type .kfw-accordion-handler-icon .kfw-elementor-icon-wrap svg' => 'fill:{{VALUE}};',
                            '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type .kfw-accordion-handler-icon .kfw-elementor-icon-wrap i'   => 'color:{{VALUE}};',
                        ],
                    ]);
					$this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'handler_icon_bg',
						'types'          => ['classic', 'gradient'],
						'exclude'        => [ 'image'],
						'fields_options' => [
							'background' => [ 'default' => 'classic' ],
							'color'      => [ 'default' => '' ],
						],
						'condition'      => $icon_condition,
						'selector'       => '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'      => 'handler_icon_border',
						'condition' => $icon_condition,
						'selector'  => '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type'
					]);
					$this->add_responsive_control( 'handler_icon_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'condition'  => $icon_condition,
						'selectors'  => [
							'{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						]
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'      => 'handler_icon_box_shadow',
						'condition' => $icon_condition,
						'selector'  => '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type'
					]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'icon_type_handler_hover_state', [
                    'label'     => esc_html__( 'Hover', 'onnat-extra' ),
                    'condition' => $icon_condition
                ]);
                    $this->add_control( 'handler_icon_hover_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'condition' => $icon_condition,
                        'selectors' => [
                            '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type .kfw-accordion-handler-icon .kfw-elementor-icon-wrap svg' => 'fill:{{VALUE}};',
                            '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type .kfw-accordion-handler-icon .kfw-elementor-icon-wrap i'   => 'color:{{VALUE}};',
                        ],
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'handler_icon_hover_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $icon_condition,
                        'selector'       => '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'handler_icon_hover_border',
                        'condition' => $icon_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type'
                    ]);
                    $this->add_responsive_control( 'handler_icon_hover_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $icon_condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'handler_icon_hover_box_shadow',
                        'condition' => $icon_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'icon_type_handler_active_state', [
                    'label'     => esc_html__( 'Active', 'onnat-extra' ),
                    'condition' => $icon_condition
                ]);
                    $this->add_control( 'handler_icon_active_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'condition' => $icon_condition,
                        'selectors' => [
                            '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type .kfw-accordion-handler-icon .kfw-elementor-icon-wrap svg' => 'fill:{{VALUE}};',
                            '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type .kfw-accordion-handler-icon .kfw-elementor-icon-wrap i'   => 'color:{{VALUE}};',
                        ],
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'handler_icon_active_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $icon_condition,
                        'selector'       => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'handler_icon_active_border',
                        'condition' => $icon_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type'
                    ]);
                    $this->add_responsive_control( 'handler_icon_active_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $icon_condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'handler_icon_active_box_shadow',
                        'condition' => $icon_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-icon-type'
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();

        $this->end_controls_section();

		$this->start_controls_section( 'section_img_type_handler_style', [
            'label'     => esc_html__( 'Image Type Handler', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $img_condition,
		]);
            $this->add_responsive_control( 'handler_img_size', [
                'label'      => esc_html__('Image Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'condition'  => $img_condition,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type .kfw-accordion-handler-icon .kfw-elementor-icon-wrap img' => 'max-width:{{SIZE}}px;'
                ],
            ]);
            $this->add_responsive_control( 'handler_img_margin', [
				'label'              => esc_html__('Margin', 'onnat-extra' ),
				'type'               => KFCM::DIMENSIONS,
				'size_units'         => [ 'px', 'em', '%' ],
				'allowed_dimensions' => [
                    'top',
                    'right',
                    'bottom',
                ],
				'placeholder'        => [
                    'top'    => '',
                    'right'  => '',
                    'bottom' => '',
                    'left'   => 'auto',
                ],
                'condition'          => $img_condition,
                'selectors'          => [
                    '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type' => 'margin-top: {{TOP}}{{UNIT}}; margin-bottom: {{BOTTOM}}{{UNIT}}; margin-right: {{RIGHT}}{{UNIT}};',
                ]
            ]);
            $this->add_responsive_control( 'handler_img_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $img_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->start_controls_tabs( 'img_type_handler_customize_tabs',[
                'condition' => $img_condition
            ]);
                $this->start_controls_tab( 'img_type_handler_normal_state', [
                    'label'     => esc_html__( 'Normal', 'onnat-extra' ),
                    'condition' => $img_condition
                ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'handler_img_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $img_condition,
                        'selector'       => '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'handler_img_border',
                        'condition' => $img_condition,
                        'selector'  => '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type'
                    ]);
                    $this->add_responsive_control( 'handler_img_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $img_condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'handler_img_box_shadow',
                        'condition' => $img_condition,
                        'selector'  => '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'img_type_handler_hover_state', [
                    'label'     => esc_html__( 'Hover', 'onnat-extra' ),
                    'condition' => $img_condition
                ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'handler_img_hover_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $img_condition,
                        'selector'       => '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'handler_img_hover_border',
                        'condition' => $img_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type'
                    ]);
                    $this->add_responsive_control( 'handler_img_hover_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $img_condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'handler_img_hover_box_shadow',
                        'condition' => $img_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'img_type_handler_active_state', [
                    'label'     => esc_html__( 'Active', 'onnat-extra' ),
                    'condition' => $img_condition
                ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'handler_img_active_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $img_condition,
                        'selector'       => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'handler_img_active_border',
                        'condition' => $img_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type'
                    ]);
                    $this->add_responsive_control( 'handler_img_active_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $img_condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'handler_img_active_box_shadow',
                        'condition' => $img_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-image-type'
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

		$this->start_controls_section( 'section_lordicon_type_handler_style', [
            'label'     => esc_html__( 'Lordicon Type Handler', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $ld_condition
		]);
            $this->add_responsive_control( 'handler_media_size', [
                'label'      => esc_html__('Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'condition'  => $ld_condition,
                'range'      => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type .kfw-elementor-lordicon' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'handler_media_stroke', [
                'label'      => esc_html__('Stroke', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'condition'  => $ld_condition,
                'range'      => [
                    'min' => 1,
                    'max' => 500,
                ],
            ]);
            $this->add_responsive_control( 'handler_media_margin', [
				'label'              => esc_html__('Margin', 'onnat-extra' ),
				'type'               => KFCM::DIMENSIONS,
				'size_units'         => [ 'px', 'em', '%' ],
				'allowed_dimensions' => [
                    'top',
                    'right',
                    'bottom',
                ],
				'placeholder'        => [
                    'top'    => '',
                    'right'  => '',
                    'bottom' => '',
                    'left'   => 'auto',
                ],
                'condition'          => $ld_condition,
                'selectors'          => [
                    '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type' => 'margin-top: {{TOP}}{{UNIT}}; margin-bottom: {{BOTTOM}}{{UNIT}}; margin-right: {{RIGHT}}{{UNIT}};',
                ]
            ]);
            $this->add_responsive_control( 'handler_media_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $ld_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'hr_lordicon_colors', [
                'type'      => KFCM::DIVIDER,
                'condition' => $ld_condition,
			]);
			$this->add_control( 'heading_lordicon_colors', [
				'label'     => esc_html__( 'COLORS', 'onnat-extra' ),
				'condition' => $ld_condition,
				'type'      => KFCM::HEADING,
			]);
            $this->add_control('handler_media_primary_color',[
				'label'     => __( 'Primary Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'default'   => '#121331',
            ]);
            $this->add_control('handler_media_secondary_color',[
                'label'   => __( 'Secondary Color', 'onnat-extra' ),
                'type'    => KFCM::COLOR,
                'default' => '#121331',
            ]);
            $this->add_control('handler_media_tertiary_color',[
                'label'   => __( 'Tertiary Color', 'onnat-extra' ),
                'type'    => KFCM::COLOR,
                'default' => '#0816A8',
            ]);
            $this->start_controls_tabs( 'media_type_handler_customize_tabs',[
                'condition' => $ld_condition
            ]);
                $this->start_controls_tab( 'media_type_handler_normal_state', [
                    'label'     => esc_html__( 'Normal', 'onnat-extra' ),
                    'condition' => $ld_condition
                ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'handler_media_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $ld_condition,
                        'selector'       => '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'handler_media_border',
                        'condition' => $ld_condition,
                        'selector'  => '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type'
                    ]);
                    $this->add_responsive_control( 'handler_media_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $ld_condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'handler_media_box_shadow',
                        'condition' => $ld_condition,
                        'selector'  => '{{WRAPPER}} .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'media_type_handler_hover_state', [
                    'label'     => esc_html__( 'Hover', 'onnat-extra' ),
                    'condition' => $ld_condition
                ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'handler_media_hover_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $ld_condition,
                        'selector'       => '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'handler_media_hover_border',
                        'condition' => $ld_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type'
                    ]);
                    $this->add_responsive_control( 'handler_media_hover_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $ld_condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'handler_media_hover_box_shadow',
                        'condition' => $ld_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item:hover .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'media_type_handler_active_state', [
                    'label'     => esc_html__( 'Active', 'onnat-extra' ),
                    'condition' => $ld_condition
                ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'handler_media_active_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $ld_condition,
                        'selector'       => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'handler_media_active_border',
                        'condition' => $ld_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type'
                    ]);
                    $this->add_responsive_control( 'handler_media_active_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $ld_condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'handler_media_active_box_shadow',
                        'condition' => $ld_condition,
                        'selector'  => '{{WRAPPER}} .kfw-elementor-accordion-item.kfw-elementor-active-accordion .kfw-accordion-handler-icon-wrap.kfw-accordion-handler-lordicon-type'
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
    }

	public function _render_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

		if( !empty( $icon ) ) {
            echo '<div class="kfw-accordion-title-icon-wrap kfw-accordion-title-icon-type">';
                echo '<span class="kfw-elementor-icon-wrap">';
                    KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
                echo '</span>';
            echo '</div>';
		}
    }

    public function _render_img( $settings = [] ) {
        if( !empty( $settings['url'] ) ) {
            $image_src = $settings['url'];

			$image_title = $this->_get_image_title( $settings );
			$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

			$image_alt = $this->_get_image_alt( $settings );
			$image_alt = empty( $image_alt ) ? $image_title : $image_title;

            echo '<div class="kfw-accordion-title-icon-wrap kfw-accordion-title-image-type">';
                echo '<span class="kfw-elementor-icon-wrap">';
                    echo '<img alt="'. esc_attr( $image_alt ) .'" title="'. esc_attr( $image_title ) .'" src="'. esc_url( $image_src ) .'"/>';
                echo '</span>';
            echo '</div>';
        }
    }

	public function _render_handler_icon( $icon , $active = false ) {
        $icon  = array_filter( $icon );
        $class = ( $active ) ? 'kfw-accordion-handler-open' : 'kfw-accordion-handler-close';

		if( !empty( $icon ) ) {
            echo '<div class="kfw-accordion-handler-icon '. $class .'">';
                echo '<span class="kfw-elementor-icon-wrap">';
                    KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
                echo '</span>';
            echo '</div>';
        }
    }

    public function _render_handler_icon_img( $settings = [] , $active = false ) {
        if( !empty( $settings['url'] ) ) {
            $image_src = $settings['url'];

			$image_title = $this->_get_image_title( $settings );
			$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

			$image_alt = $this->_get_image_alt( $settings );
			$image_alt = empty( $image_alt ) ? $image_title : $image_title;

            $class = ( $active ) ? 'kfw-accordion-handler-open' : 'kfw-accordion-handler-close';

            echo '<div class="kfw-accordion-handler-icon '. $class .'">';
                echo '<span class="kfw-elementor-icon-wrap">';
                    echo '<img alt="'. esc_attr( $image_alt ) .'" title="'. esc_attr( $image_title ) .'" src="'. esc_url( $image_src ) .'"/>';
                echo '</span>';
            echo '</div>';
        }
    }

	public function _get_image_title( $attachment ) {
		if ( empty( $attachment['id'] ) ) {
			return '';
		}

		return get_the_title( $attachment['id'] );
	}

	public function _get_image_alt( $instance ) {
		if ( empty( $instance['id'] ) ) {
			// For `Insert From URL` images.
			return isset( $instance['alt'] ) ? trim( strip_tags( $instance['alt'] ) ) : '';
		}

		$attachment_id = $instance['id'];
		if ( ! $attachment_id ) {
			return '';
		}

		$attachment = get_post( $attachment_id );
		if ( ! $attachment ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		if ( ! $alt ) {
			$alt = $attachment->post_excerpt;
			if ( ! $alt ) {
				$alt = $attachment->post_title;
			}
		}
		return trim( strip_tags( $alt ) );
	}

	/**
	 * Get template content
	 */
	public function _generate_template_content( $template_id ) {
		return KFEl::instance()->frontend->get_builder_content_for_display( $template_id );
	}

    public function _is_editor_mode() {
        $preview = KFEl::instance()->preview->is_preview_mode();
        $editor  = KFEl::instance()->editor->is_edit_mode();

        return ( $preview || $editor ) ? true : false;
    }

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-accordion");
		include $render;
    }
}