<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Icons_Manager as KFIM;

use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;

class KFW_Lordicon_Icon_Box extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-lordicon-icon-box';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Icon Box : Lordicon', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_core_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-icon-box kfw-lordicon-icon-box';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'icon', 'box', 'icon box', 'lordicon' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
		return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/icon-box-lordicon';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

		wp_register_script( 'lordicon',
			KFE_CONST_URL . 'libraries/elementor/assets/js/lordicon.js',
			[],
			KFE_CONST_VERSION,
			true
		);

		wp_register_style( 'kfw-lordicon-icon-box',
			KFE_CONST_URL . 'libraries/elementor/assets/css/lordicon-icon-box' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-lordicon-icon-box' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'lordicon' ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_icon_section();
		$this->_register_content_section();
		$this->_register_button_section();

		$this->_register_box_style_section();
		$this->_register_icon_style_section();
		$this->_register_title_style_section();
		$this->_register_sub_title_style_section();
		$this->_register_description_style_section();
		$this->_register_button_style_section();
    }

    public function _register_icon_section() {
		$this->start_controls_section( 'section_icon', [
			'label' => esc_html__( 'Lordicon', 'onnat-extra' )
		]);
			$this->add_control('source_des', [
				'type'            => KFCM::RAW_HTML,
				'content_classes' => 'kfw-elementor-editor-notice-ctrl',
				'raw'             => sprintf(
					esc_html__('You can get lordicon code from %1$s Lordicon.com %2$s', 'onnat-extra'),
					sprintf('<a href="%1$s" target="_blank">', esc_url( 'https://lordicon.com/' ) ),
					'</a>',
				),
			]);
            $this->add_control('source_type',[
                'label'   => esc_html__( 'Source', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'options' => [
                    'media'    => [
                        'title' => esc_html__('Upload From Media', 'onnat-extra'),
                        'icon'  => 'eicon-library-upload',
                    ],
                    'external' => [
                        'title' => esc_html__('Upload From Extrnal', 'onnat-extra'),
                        'icon'  => 'eicon-editor-external-link',
                    ],
                ],
                'default' => 'media',
                'toggle'  => false
            ]);
            $this->add_control('source_media', [
                'label'      => esc_html__( 'Upload JSON File', 'onnat-extra' ),
                'type'       => KFCM::MEDIA,
                'media_type' => 'application/json',
                'default'    => [
					'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                ],
                'condition'  => [
                    'source_type' => 'media'
                ]
            ]);
            $this->add_control('source_external', [
                'label'       => esc_html__( 'Upload JSON File', 'onnat-extra' ),
                'type'        => KFCM::URL,
                'dynamic'     => [ 'active' => true, ],
                'placeholder' => esc_html__( 'Enter your URL', 'onnat-extra' ),
                'options'     => [ 'url' ],
                'default'     => [
					'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                ],
				'condition'   => [
                    'source_type' => 'external'
                ]
            ]);
			$this->add_control( 'hr_lordicon_settings', [
				'type' => KFCM::DIVIDER,
			]);
			$this->add_control( 'heading_lordicon_settings', [
				'label' => esc_html__( 'SETTINGS', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
			]);
			$this->add_control('trigger', [
				'label'   => esc_html__( 'Play On', 'onnat-extra' ),
				'type'    => KFCM::SELECT,
				'options' => [
                    'boomerang'     => esc_html__( 'Boomerang', 'onnat-extra' ),
                    'click'         => esc_html__( 'Click', 'onnat-extra' ),
                    'hover'         => esc_html__( 'Hover', 'onnat-extra' ),
                    'loop'          => esc_html__( 'Auto Loop', 'onnat-extra' ),
                    'morph'         => esc_html__( 'Morph', 'onnat-extra' ),
                    'loop-on-hover' => esc_html__( 'Loop on hover', 'onnat-extra' ),
				],
				'default' => 'loop',
			]);
			$this->add_control('target', [
				'label'   => esc_html__( 'Trigger Play On', 'onnat-extra' ),
				'type'    => KFCM::SELECT,
				'options' => [
                    'widget'  => esc_html__( 'On Widget', 'onnat-extra' ),
					'column'  => esc_html__( 'On Column', 'onnat-extra' ),
					'section' => esc_html__( 'On Section', 'onnat-extra' ),
					'custom'  => esc_html__( 'Custom', 'onnat-extra' ),
                ],
                'default' => 'widget',
			]);
			$this->add_control('custom_target', [
				'label'       => esc_html__( 'Custom Target', 'onnat-extra' ),
				'type'        => KFCM::TEXT,
				'placeholder' => __( '.example', 'onnat-extra' ),
				'default'     => __( '.example', 'onnat-extra' ),
				'condition'   => [
                    'target' => 'custom',
                ]
			]);
			$this->add_control( 'hr_lordicon_additional_settings', [
				'type' => KFCM::DIVIDER,
			]);
			$this->add_control( 'heading_lordicon_additional_settings', [
				'label' => esc_html__( 'ADDITIONAL SETTINGS', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
			]);
			$this->add_control('position', [
				'label'          => esc_html__( 'Position', 'onnat-extra' ),
				'type'           => KFCM::CHOOSE,
				'options'        => [
					'left'   => [
						'title' => esc_html__( 'Left', 'onnat-extra' ),
						'icon'  => 'eicon-h-align-left',
					],
					'top'    => [
						'title' => esc_html__( 'Top', 'onnat-extra' ),
						'icon'  => 'eicon-v-align-top',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'onnat-extra' ),
						'icon'  => 'eicon-h-align-right',
					],
					'bottom' => [
						'title' => esc_html__( 'Bottom', 'onnat-extra' ),
						'icon'  => 'eicon-v-align-bottom',
					],
				],
				'default'        => 'top',
				'toggle'         => false,
				'prefix_class'   => 'kfw-ele-lordicon-icon-box-icon-position-',
			]);
			$this->add_control('align',[
				'label'        => esc_html__( 'Alignment', 'onnat-extra' ),
				'type'         => KFCM::CHOOSE,
				'options'      => [
					'top'    => [
						'title' => esc_html__( 'Top', 'onnat-extra' ),
						'icon'  => 'eicon-v-align-top',
					],
					'middle' => [
						'title' => esc_html__( 'Middle', 'onnat-extra' ),
						'icon'  => 'eicon-v-align-middle',
					],
					'bottom' => [
						'title' => esc_html__( 'Bottom', 'onnat-extra' ),
						'icon'  => 'eicon-v-align-bottom',
					],
				],
                'prefix_class' => 'kfw-ele-lordicon-icon-box-icon-vertical-align-',
                'default'      => 'top',
                'toggle'       => false,
                'condition'    => [
                    'position' => [ 'left', 'right' ]
                ],
			]);
			$this->add_responsive_control('lr_icon_vertical_offset',[
				'label'          => esc_html__( 'Vertical Offset', 'onnat-extra' ),
				'type'           => KFCM::SLIDER,
				'default'        => ['size' => 0,],
				'tablet_default' => ['size' => 0,],
				'mobile_default' => ['size' => 0,],
				'range'          => [
                    'px' => [
                        'min' => -200,
						'max' => 200,
					],
				],
				'selectors'      => [
                    '{{WRAPPER}}' => '--kfw-lordicon-icon-box-lr-v-offet:{{SIZE}}px;'
				],
                'condition'      => [
                    'position' => [ 'left', 'right' ]
                ],
			]);
			$this->add_responsive_control('lr_icon_horizontal_offset',[
				'label'          => esc_html__( 'Horizontal Offset', 'onnat-extra' ),
				'type'           => KFCM::SLIDER,
				'default'        => ['size' => 0,],
				'tablet_default' => ['size' => 0,],
				'mobile_default' => ['size' => 0,],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--kfw-lordicon-icon-box-lr-h-offet:{{SIZE}}px;'
				],
                'condition'      => [
                    'position' => [ 'left', 'right' ]
                ],
			]);
			$this->add_responsive_control('tb_icon_vertical_offset',[
				'label'          => esc_html__( 'Vertical Offset', 'onnat-extra' ),
				'type'           => KFCM::SLIDER,
				'default'        => ['size' => 0,],
				'tablet_default' => ['size' => 0,],
				'mobile_default' => ['size' => 0,],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--kfw-lordicon-icon-box-tb-v-offet:{{SIZE}}px;'
				],
                'condition'      => [
                    'position' => [ 'top', 'bottom' ]
                ],
			]);
			$this->add_responsive_control('tb_icon_horizontal_offset',[
				'label'          => esc_html__( 'Horizontal Offset', 'onnat-extra' ),
				'type'           => KFCM::SLIDER,
				'default'        => ['size' => 0,],
				'tablet_default' => ['size' => 0,],
				'mobile_default' => ['size' => 0,],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--kfw-lordicon-icon-box-tb-h-offet:{{SIZE}}px;'
				],
                'condition'      => [
                    'position' => [ 'top', 'bottom' ]
                ],
			]);
		$this->end_controls_section();
    }

    public function _register_content_section() {
		$this->start_controls_section( 'section_content', [
			'label' => esc_html__( 'Content', 'onnat-extra' )
		]);
            $this->add_control('title',[
                'label'       => esc_html__( 'Title', 'onnat-extra' ),
                'type'        => KFCM::TEXT,
                'dynamic'     => [ 'active' => true ],
                'default'     => esc_html__( 'Icon Box Title' , 'onnat-extra' ),
                'label_block' => true,
            ]);
            $this->add_control('title_link',[
                'label'     => esc_html__( 'Title Link', 'onnat-extra' ),
                'type'      => KFCM::URL,
                'dynamic'   => [
                    'active' => true
                ],
                'options'   => [
                    'url',
                    'is_external',
                    'nofollow'
                ],
                'default'   => [
                    'url'         => '',
                    'is_external' => true,
                    'nofollow'    => true,
                ],
                'condition' => [
                    'title!' => ''
                ]
            ]);
			$this->add_control('sub_title',[
				'label'       => esc_html__( 'Sub Title', 'onnat-extra' ),
				'type'        => KFCM::TEXT,
				'dynamic'     => [ 'active' => true, ],
				'placeholder' => esc_html__( 'Enter Sub Title', 'onnat-extra' ),
				'label_block' => true,
			]);
			$this->add_control('description',[
				'label'       => esc_html__( 'Description', 'onnat-extra' ),
				'type'        => KFCM::TEXTAREA,
				'dynamic'     => [ 'active' => true, ],
				'placeholder' => esc_html__( 'Enter Description', 'onnat-extra' ),
				'default'     => esc_html__( 'Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', 'onnat-extra' ),
				'label_block' => true,
			]);
		$this->end_controls_section();
    }

    public function _register_button_section() {
		$this->start_controls_section( 'section_button', [
			'label' => esc_html__( 'Button', 'onnat-extra' )
		]);
            $this->add_control('use_button',[
                'label'        => esc_html__( 'Use Button', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes'
            ]);
			$this->add_control( 'btn_text', [
				'label'     => esc_html__( 'Text', 'onnat-extra' ),
				'type'      => KFCM::TEXT,
				'default'   => esc_html__( 'Button', 'onnat-extra' ),
				'condition' => [
					'use_button' => 'yes'
				]
			]);
			$this->add_control( 'btn_link', [
				'label'       => esc_html__( 'Link', 'onnat-extra' ),
				'type'        => KFCM::URL,
				'placeholder' => 'https://your-link.com',
				'default'     => [ 'url' => '#' ],
				'conditions'  => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'use_button',
							'operator' => '===',
							'value'    => 'yes'
						],
						[
							'relation' => 'or',
							'terms'    => [
								[
									'name'     => 'btn_text',
									'operator' => '!=',
									'value'    => ''
								],
								[
									'name'     => 'btn_icon[value]',
									'operator' => '!=',
									'value'    => ''
								],
							],
						]
					]
				],
			]);
			$this->add_control( 'btn_icon', [
				'label'       => esc_html__( 'Icon', 'onnat-extra' ),
				'type'        => KFCM::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
				'condition'   => [
					'use_button' => 'yes'
				],
				'default'     => [
					'value'   => 'fa fa-check',
					'library' => 'fa-solid'
				]
			]);
		$this->end_controls_section();
    }

	public function _register_box_style_section() {
		$this->start_controls_section( 'section_box_style', [
			'label' => esc_html__( 'Box', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control( 'box_align', [
				'label'     => esc_html__( 'Alignment', 'onnat-extra' ),
				'type'      => KFCM::CHOOSE,
				'toggle'    => false,
				'default'   => 'center',
				'options'   => [
					'left'    => [
						'title' => esc_html__( 'Left', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center'  => [
						'title' => esc_html__( 'Center', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'   => [
						'title' => esc_html__( 'Right', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main' => 'text-align: {{VALUE}};',
				],
			]);
            $this->add_responsive_control( 'box_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'box_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->start_controls_tabs( 'box_customize_tabs');
				$this->start_controls_tab( 'box_normal_state', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'           => 'box_bg',
						'types'          => ['classic', 'gradient'],
						'fields_options' => [
							'background' => [ 'default' => 'classic' ],
							'color'      => [ 'default' => '' ],
						],
						'selector'       => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main',
					]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'box_border',
                        'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main',
                    ]);
                    $this->add_responsive_control( 'box_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'box_box_shadow',
                        'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main',
                    ]);
                $this->end_controls_tab();
				$this->start_controls_tab( 'box_hover_state', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'           => 'box_hover_bg',
						'types'          => ['classic', 'gradient'],
						'fields_options' => [
							'background' => [ 'default' => 'classic' ],
							'color'      => [ 'default' => '' ],
						],
						'selector'       => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main:before',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'      => 'box_hover_border',
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main:hover',
					]);
					$this->add_responsive_control( 'box_hover_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						]
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'      => 'box_hover_box_shadow',
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main:hover',
					]);
                    $this->add_control('box_hover_overlay_color',[
                        'label'     => __( 'Overlay Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'default'   => '',
                        'selectors' => ['{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-main:after' => 'background-color: {{VALUE}};' ],
                    ]);
					$this->add_control('box_hover_style', [
						'label'        => esc_html__( 'Hover Style', 'onnat-extra' ),
						'type'         => KFCM::CHOOSE,
						'options'      => [
							'none'    => [
								'title' => esc_html__( 'None', 'onnat-extra' ),
								'icon'  => 'eicon-ban',
							],
							'default' => [
								'title' => esc_html__( 'Default', 'onnat-extra' ),
								'icon'  => 'eicon-globe',
							],
							'circle'  => [
								'title' => esc_html__( 'Circle', 'onnat-extra' ),
								'icon'  => 'eicon-circle',
							],
							'ellipse' => [
								'title' => esc_html__( 'Ellipse', 'onnat-extra' ),
								'icon'  => 'eicon-preview-medium',
							],
							'square'  => [
								'title' => esc_html__( 'Square', 'onnat-extra' ),
								'icon' => 'eicon-square',
							],
						],
						'default'      => 'none',
						'toggle'       => false,
						'prefix_class' => 'kfw-ele-widget-lordicon-icon-box-hover-style-',
					]);
                $this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

    public function _register_icon_style_section() {
		$this->start_controls_section( 'section_icon_style', [
			'label' => esc_html__( 'Source', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_responsive_control( 'media_size', [
                'label'      => esc_html__('Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 1,
                        'max' => 999,
                    ],
                ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-elementor-lordicon-wrap, {{WRAPPER}} .kfw-elementor-lordicon' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};'
				]
            ]);
            $this->add_control( 'media_stroke', [
                'label'      => esc_html__('Stroke', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'range'      => [
                    'min' => 1,
                    'max' => 500,
                ],
            ]);
			$this->add_responsive_control( 'media_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-lordicon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'lottie_media_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-elementor-lordicon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_control( 'hr_lordicon_colors', [
				'type' => KFCM::DIVIDER,
			]);
			$this->add_control( 'heading_lordicon_colors', [
				'label' => esc_html__( 'COLORS', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
			]);
            $this->add_control('lordicon_color_des', [
                'type'            => KFCM::RAW_HTML,
                'content_classes' => 'kfw-elementor-editor-notice-ctrl',
                'raw'             => sprintf(
                    esc_html__('Premium icons need more than two colors.', 'onnat-extra'),
                )
            ]);
            $this->add_control('primary_color',[
				'label'     => __( 'Primary Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'default'   => '#121331',
            ]);
            $this->add_control('secondary_color',[
                'label'   => __( 'Secondary Color', 'onnat-extra' ),
                'type'    => KFCM::COLOR,
                'default' => '#121331',
            ]);
            $this->add_control('tertiary_color',[
                'label'   => __( 'Tertiary Color', 'onnat-extra' ),
                'type'    => KFCM::COLOR,
                'default' => '#0816A8',
            ]);
            $this->add_control('quaternary_color',[
                'label'   => __( 'Quaternary Color', 'onnat-extra' ),
                'type'    => KFCM::COLOR,
                'default' => '#2CA808',
            ]);
            $this->add_control('quinary_color',[
                'label'   => __( 'Quinary Color', 'onnat-extra' ),
                'type'    => KFCM::COLOR,
                'default' => '#4bb3fd',
            ]);
            $this->add_control('senary_color',[
                'label'   => __( 'Senary Color', 'onnat-extra' ),
                'type'    => KFCM::COLOR,
                'default' => '#f9c9c0',
            ]);
			$this->start_controls_tabs( 'media_tabs');
                $this->start_controls_tab( 'media_normal_state', [
                    'label' => esc_html__( 'Normal', 'onnat-extra' ),
                ]);
                    $this->add_control('media_rotate',[
                        'label'     => esc_html__( 'Rotate', 'onnat-extra' ),
                        'type'      => KFCM::SLIDER,
                        'default'   => [
                            'size' => 0,
                            'unit' => 'deg',
                        ],
                        'range'     => [
                            'deg' => [
                                'max' => 360,
                                'min' => -360,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .kfw-elementor-lordicon' => 'transform: rotate({{SIZE}}{{UNIT}});',
                        ],
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'media_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'selector'       => '{{WRAPPER}} .kfw-elementor-lordicon-wrap',
                    ]);
                    $this->add_control('media_bg_rotate',[
                        'label'     => esc_html__( 'Rotate', 'onnat-extra' ),
                        'type'      => KFCM::SLIDER,
                        'default'   => [
                            'size' => 0,
                            'unit' => 'deg',
                        ],
                        'range'     => [
                            'deg' => [
                                'max' => 360,
                                'min' => -360,
                            ],
                        ],
						'condition' => [
							'media_bg_background' => [ 'classic', 'gradient' ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .kfw-elementor-lordicon-wrap' => 'transform: rotate({{SIZE}}{{UNIT}});',
                        ],
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'media_border',
                        'selector'  => '{{WRAPPER}} .kfw-elementor-lordicon-wrap',
                    ]);
                    $this->add_responsive_control( 'media_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-elementor-lordicon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'media_box_shadow',
                        'selector'  => '{{WRAPPER}} .kfw-elementor-lordicon-wrap'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'media_hover_state', [
                    'label' => esc_html__( 'Hover', 'onnat-extra' ),
                ]);
                    $this->add_control('media_hover_rotate',[
                        'label'     => esc_html__( 'Rotate', 'onnat-extra' ),
                        'type'      => KFCM::SLIDER,
                        'default'   => [
                            'size' => 0,
                            'unit' => 'deg',
                        ],
                        'range'     => [
                            'deg' => [
                                'max' => 360,
                                'min' => -360,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}}:hover .kfw-elementor-lordicon' => 'transform: rotate({{SIZE}}{{UNIT}});',
                        ],
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'media_hover_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'selector'       => '{{WRAPPER}}:hover .kfw-elementor-lordicon-wrap',
                    ]);
                    $this->add_control('media_hover_bg_rotate',[
                        'label'     => esc_html__( 'Rotate', 'onnat-extra' ),
                        'type'      => KFCM::SLIDER,
                        'default'   => [
                            'size' => 0,
                            'unit' => 'deg',
                        ],
                        'range'     => [
                            'deg' => [
                                'max' => 360,
                                'min' => -360,
                            ],
                        ],
						'condition' => [
							'media_hover_bg_background' => [ 'classic', 'gradient' ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}}:hover .kfw-elementor-lordicon-wrap' => 'transform: rotate({{SIZE}}{{UNIT}});',
                        ],
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'media_hover_border',
                        'selector'  => '{{WRAPPER}}:hover .kfw-elementor-lordicon-wrap',
                    ]);
                    $this->add_responsive_control( 'media_hover_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}}:hover .kfw-elementor-lordicon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'media_hover_box_shadow',
                        'selector'  => '{{WRAPPER}}:hover .kfw-elementor-lordicon-wrap'
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

	public function _register_title_style_section() {
		$this->start_controls_section( 'section_title_style', [
			'label'     => esc_html__( 'Title', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [ 'title!'=> '' ]
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'title_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'condition' => [ 'title!'=> '' ],
				'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-title',
			]);
			$this->add_responsive_control( 'title_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => [ 'title!'=> '' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'title_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => [ 'title!'=> '' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->start_controls_tabs( 'title_customize_tabs' );
				$this->start_controls_tab( 'title_normal_state', [
					'label'     => esc_html__( 'Normal', 'onnat-extra' ),
					'condition' => [ 'title!'=> '' ],
				]);
					$this->add_control( 'title_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => ['{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-title, {{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-title a' => 'color: {{VALUE}};' ],
						'condition' => [ 'title!'=> '' ],
					]);
					$this->add_group_control( KFGCTS::get_type(), [
						'name'      => 'title_txt_shadow',
						'condition' => [ 'title!'=> '' ],
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-title, {{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-title a',
					]);
					$this->add_group_control( KFGCTST::get_type(), [
						'name'      => 'title_txt_stroke',
						'condition' => [ 'title!'=> '' ],
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-title, {{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-title a',
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'title_hover_state', [
					'label'     => esc_html__( 'Hover', 'onnat-extra' ),
					'condition' => [ 'title!'=> '' ],
				]);
					$this->add_control( 'title_hover_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => ['{{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-title, {{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-title a' => 'color: {{VALUE}};' ],
						'condition' => [ 'title!'=> '' ],
					]);
					$this->add_group_control( KFGCTS::get_type(), [
						'name'      => 'title_hover_txt_shadow',
						'condition' => [ 'title!'=> '' ],
						'selector'  => '{{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-title, {{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-title a',
					]);
					$this->add_group_control( KFGCTST::get_type(), [
						'name'      => 'title_hover_txt_stroke',
						'condition' => [ 'title!'=> '' ],
						'selector'  => '{{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-title, {{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-title a',
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function _register_sub_title_style_section() {
		$this->start_controls_section( 'section_sub_title_style', [
			'label'     => esc_html__( 'Sub Title', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [ 'sub_title!'=> '' ]
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'sub_title_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'condition' => [ 'sub_title!'=> '' ],
				'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-sub-title',
			]);
			$this->add_responsive_control( 'sub_title_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => [ 'sub_title!'=> '' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'sub_title_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => [ 'sub_title!'=> '' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->start_controls_tabs( 'sub_title_customize_tabs' );
				$this->start_controls_tab( 'sub_title_normal_state', [
					'label'     => esc_html__( 'Normal', 'onnat-extra' ),
					'condition' => [ 'sub_title!'=> '' ],
				]);
					$this->add_control( 'sub_title_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => ['{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-sub-title' => 'color: {{VALUE}};' ],
						'condition' => [ 'sub_title!'=> '' ],
					]);
					$this->add_group_control( KFGCTS::get_type(), [
						'name'      => 'sub_title_txt_shadow',
						'condition' => [ 'sub_title!'=> '' ],
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-sub-title',
					]);
					$this->add_group_control( KFGCTST::get_type(), [
						'name'      => 'sub_title_txt_stroke',
						'condition' => [ 'sub_title!'=> '' ],
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-sub-title',
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'sub_title_hover_state', [
					'label'     => esc_html__( 'Hover', 'onnat-extra' ),
					'condition' => [ 'sub_title!'=> '' ],
				]);
					$this->add_control( 'sub_title_hover_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => ['{{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-sub-title' => 'color: {{VALUE}};' ],
						'condition' => [ 'sub_title!'=> '' ],
					]);
					$this->add_group_control( KFGCTS::get_type(), [
						'name'      => 'sub_title_hover_txt_shadow',
						'condition' => [ 'sub_title!'=> '' ],
						'selector'  => '{{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-sub-title',
					]);
					$this->add_group_control( KFGCTST::get_type(), [
						'name'      => 'sub_title_hover_txt_stroke',
						'condition' => [ 'sub_title!'=> '' ],
						'selector'  => '{{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-sub-title',
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function _register_description_style_section() {
		$this->start_controls_section( 'section_description_style', [
			'label'     => esc_html__( 'Description', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [ 'description!'=> '' ]
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'description_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'condition' => [ 'description!'=> '' ],
				'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-description',
			]);
			$this->add_responsive_control( 'description_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => [ 'description!'=> '' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'description_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => [ 'description!'=> '' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->start_controls_tabs( 'description_customize_tabs' );
				$this->start_controls_tab( 'description_normal_state', [
					'label'     => esc_html__( 'Normal', 'onnat-extra' ),
					'condition' => [ 'description!'=> '' ],
				]);
					$this->add_control( 'description_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => ['{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-description' => 'color: {{VALUE}};' ],
						'condition' => [ 'description!'=> '' ],
					]);
					$this->add_group_control( KFGCTS::get_type(), [
						'name'      => 'description_txt_shadow',
						'condition' => [ 'description!'=> '' ],
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-description',
					]);
					$this->add_group_control( KFGCTST::get_type(), [
						'name'      => 'description_txt_stroke',
						'condition' => [ 'description!'=> '' ],
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-description',
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'description_hover_state', [
					'label'     => esc_html__( 'Hover', 'onnat-extra' ),
					'condition' => [ 'description!'=> '' ],
				]);
					$this->add_control( 'description_hover_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => ['{{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-description' => 'color: {{VALUE}};' ],
						'condition' => [ 'description!'=> '' ],
					]);
					$this->add_group_control( KFGCTS::get_type(), [
						'name'      => 'description_hover_txt_shadow',
						'condition' => [ 'description!'=> '' ],
						'selector'  => '{{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-description',
					]);
					$this->add_group_control( KFGCTST::get_type(), [
						'name'      => 'description_hover_txt_stroke',
						'condition' => [ 'description!'=> '' ],
						'selector'  => '{{WRAPPER}}:hover .kfw-ele-widget-lordicon-icon-box-description',
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function _register_button_style_section() {
		$style_condition = [
			'relation' => 'and',
			'terms'    => [
				[
					'name'     => 'use_button',
					'operator' => '===',
					'value'    => 'yes'
				],
				[
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'btn_text',
							'operator' => '!=',
							'value'    => ''
						],
						[
							'name'     => 'btn_icon[value]',
							'operator' => '!=',
							'value'    => ''
						],
					],
				]
			]
		];

		$btn_txt_condition = [
			'relation' => 'and',
			'terms'    => [
				[
					'name'     => 'use_button',
					'operator' => '===',
					'value'    => 'yes'
				],
				[
					'name'     => 'btn_text',
					'operator' => '!=',
					'value'    => ''
				],
			]
		];

		$this->start_controls_section( 'section_button_style', [
			'label'      => esc_html__( 'Button', 'onnat-extra' ),
			'tab'        => KFCM::TAB_STYLE,
			'conditions' => $style_condition,
		]);
			$this->add_responsive_control( 'btn_align', [
				'label'     => esc_html__( 'Alignment', 'onnat-extra' ),
				'type'      => KFCM::CHOOSE,
				'toggle'    => false,
				'default'   => '',
				'options'   => [
					'left'    => [
						'title' => esc_html__( 'Left', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center'  => [
						'title' => esc_html__( 'Center', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'   => [
						'title' => esc_html__( 'Right', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button-wrap' => 'text-align: {{VALUE}};',
				],
			]);
			$this->add_responsive_control( 'btn_padding', [
				'label'      => esc_html__( 'Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'use_button!' => ''
				]
			]);
			$this->add_responsive_control( 'btn_margin', [
				'label'      => esc_html__( 'Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'separator'  => 'after',
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'use_button!' => ''
				]
			]);
			$this->add_control( 'btn_animation_hover', [
				'label'      => esc_html__( 'Hover Animation', 'onnat-extra' ),
				'type'       => KFCM::HOVER_ANIMATION,
				'conditions' => $style_condition,
			]);

			/**
			 * Button Text Style
			 */
				$this->add_control('btn_txt_style_before_hr', [
					'type'       => KFCM::DIVIDER,
					'conditions' => $btn_txt_condition,
				]);
				$this->add_control('btn_txt_style_heading',[
					'label'      => esc_html__( 'BUTTON TEXT', 'onnat-extra' ),
					'type'       => KFCM::HEADING,
					'conditions' => $btn_txt_condition,
				]);
				$this->add_control('btn_txt_style_after_hr', [
					'type'       => KFCM::DIVIDER,
					'conditions' => $btn_txt_condition,
				]);
				$this->add_group_control( KFGCT::get_type(), [
					'name'        => 'btn_typo',
					'description' => esc_html__( 'Typography', 'onnat-extra' ),
					'selector'    => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button',
					'conditions'  => $btn_txt_condition,
				]);

				$this->start_controls_tabs( 'btn_customize_tabs' );
					$this->start_controls_tab( 'btn_normal_state', [
						'label'      => esc_html__( 'Normal', 'onnat-extra' ),
						'conditions' => $btn_txt_condition
					]);
						$this->add_control( 'btn_color', [
							'label'      => esc_html__('Text Color', 'onnat-extra' ),
							'type'       => KFCM::COLOR,
							'selectors'  => ['{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button' => 'color: {{VALUE}};' ],
							'conditions' => $btn_txt_condition
						]);
						$this->add_group_control( KFGCBG::get_type(), [
							'name'       => 'btn_bg',
							'label'      => esc_html__('Background', 'onnat-extra' ),
							'types'      => [ 'classic', 'gradient' ],
							'exclude'    => [ 'image' ], # To remove background image option in classic mode
							'selector'   => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button',
							'conditions' => $btn_txt_condition
						]);
						$this->add_group_control( KFGCBR::get_type(), [
							'name'           => 'btn_border',
							'fields_options' => [
								'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
								'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
							],
							'selector'       => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button',
							'conditions'     => $btn_txt_condition,
						]);
						$this->add_responsive_control( 'btn_border_radius', [
							'label'      => esc_html__('Border Radius', 'onnat-extra' ),
							'type'       => KFCM::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors'  => [ '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
							'conditions' => $btn_txt_condition,
						]);
						$this->add_group_control( KFGCBS::get_type(), [
							'name'       => 'btn_box_shadow',
							'selector'   => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button',
							'conditions' => $btn_txt_condition,
						]);
					$this->end_controls_tab();
					$this->start_controls_tab( 'btn_hover_state', [
						'label'      => esc_html__( 'Hover', 'onnat-extra' ),
						'conditions' => $btn_txt_condition
					]);
						$this->add_control( 'btn_hover_color', [
							'label'      => esc_html__('Text Color', 'onnat-extra' ),
							'type'       => KFCM::COLOR,
							'selectors'  => ['{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover' => 'color: {{VALUE}};' ],
							'conditions' => $btn_txt_condition
						]);
						$this->add_group_control( KFGCBG::get_type(), [
							'name'       => 'btn_hover_bg',
							'label'      => esc_html__('Background', 'onnat-extra' ),
							'types'      => [ 'classic', 'gradient' ],
							'exclude'    => [ 'image' ], # To remove background image option in classic mode
							'selector'   => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover',
							'conditions' => $btn_txt_condition
						]);
						$this->add_group_control( KFGCBR::get_type(), [
							'name'           => 'btn_hover_border',
							'fields_options' => [
								'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
								'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
							],
							'selector'       => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover',
							'conditions'     => $btn_txt_condition,
						]);
						$this->add_responsive_control( 'btn_hover_border_radius', [
							'label'      => esc_html__('Border Radius', 'onnat-extra' ),
							'type'       => KFCM::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors'  => [ '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
							'conditions' => $btn_txt_condition,
						]);
						$this->add_group_control( KFGCBS::get_type(), [
							'name'       => 'btn_hover_box_shadow',
							'selector'   => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover',
							'conditions' => $btn_txt_condition,
						]);
					$this->end_controls_tab();
				$this->end_controls_tabs();

			/**
			 * Button Icon Style
			 */
				$btn_icon_condition = [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'use_button',
							'operator' => '===',
							'value'    => 'yes'
						],
						[
							'name'     => 'btn_icon[value]',
							'operator' => '!=',
							'value'    => ''
						],
					]
				];
				$btn_icon_animation_condition = [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'use_button',
							'operator' => '===',
							'value'    => 'yes'
						],
						[
							'name'     => 'btn_text',
							'operator' => '!=',
							'value'    => ''
						],
						[
							'name'     => 'btn_icon[value]',
							'operator' => '!=',
							'value'    => ''
						],
					]
				];

				$this->add_control('btn_icon_style_before_hr', [
					'type'       => KFCM::DIVIDER,
					'conditions' => $btn_icon_condition,
				]);
				$this->add_control('btn_icon_style_heading',[
					'label'      => esc_html__( 'BUTTON ICON', 'onnat-extra' ),
					'type'       => KFCM::HEADING,
					'conditions' => $btn_icon_condition,
				]);
				$this->add_control('btn_icon_style_after_hr', [
					'type'       => KFCM::DIVIDER,
					'conditions' => $btn_icon_condition,
				]);
				$this->add_responsive_control( 'btn_icon_padding', [
					'label'      => esc_html__( 'Padding', 'onnat-extra' ),
					'type'       => KFCM::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button .kfw-elementor-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
					'conditions' => $btn_icon_condition
				]);
				$this->add_responsive_control( 'btn_icon_margin', [
					'label'      => esc_html__( 'Margin', 'onnat-extra' ),
					'type'       => KFCM::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'separator'  => 'after',
					'selectors'  => [
						'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button .kfw-elementor-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
					'conditions' => $btn_icon_condition
				]);
				$this->add_control( 'btn_icon_pos', [
					'label'      => esc_html__( 'Position', 'onnat-extra' ),
					'type'       => KFCM::CHOOSE,
					'options'    => [
						'left'           => [
							'title' => esc_html__('Left', 'onnat-extra'),
							'icon'  => 'eicon-text-align-left',
						],
						'right'          => [
							'title' => esc_html__('Right', 'onnat-extra'),
							'icon'  => 'eicon-text-align-right',
						],
						'animated-left'  => [
							'title' => esc_html__('Animated Left', 'onnat-extra'),
							'icon'  => 'eicon-animation',
						],
						'animated-right' => [
							'title' => esc_html__('Animated Right', 'onnat-extra'),
							'icon'  => 'eicon-animation kfw-ctrl-rotate-180',
						],
						'toggle'         => [
							'title' => esc_html__('Toogle Button Text', 'onnat-extra'),
							'icon'  => 'eicon-share-arrow',
						]
					],
					'default'    => 'left',
					'toggle'     => false,
					'conditions' => $btn_icon_animation_condition
				]);
				$this->add_control( 'alr_btn_icon_animation', [
					'label'      => esc_html__( 'Animation Direction', 'onnat-extra' ),
					'type'       => KFCM::CHOOSE,
					'options'    => [
						'in'  => [
							'title' => esc_html__('Animate In', 'onnat-extra'),
							'icon'  => 'eicon-chevron-left'
						],
						'out' => [
							'title' => esc_html__('Animate Out', 'onnat-extra'),
							'icon'  => 'eicon-chevron-right'
						],
					],
					'default'    => 'in',
					'toggle'     => false,
					'conditions' => [
						'relation' => 'and',
						'terms'    => [
							[
								'name'     => 'use_button',
								'operator' => '===',
								'value'    => 'yes'
							],
							[
								'name'     => 'btn_text',
								'operator' => '!=',
								'value'    => ''
							],
							[
								'name'     => 'btn_icon[value]',
								'operator' => '!=',
								'value'    => ''
							],
							[
								'name'     => 'btn_icon_pos',
								'operator' => 'in',
								'value'    => ['animated-left', 'animated-right' ]
							]
						]
					]
				]);
				$this->add_control( 'toggle_btn_icon_animation', [
					'label'      => esc_html__( 'Animation Direction', 'onnat-extra' ),
					'type'       => KFCM::CHOOSE,
					'options'    => [
						'top'    => [
							'title' => esc_html__('Top', 'onnat-extra'),
							'icon'  => 'eicon-arrow-up',
						],
						'right'  => [
							'title' => esc_html__('Right', 'onnat-extra'),
							'icon'  => 'eicon-arrow-right',
						],
						'bottom' => [
							'title' => esc_html__('Bottom', 'onnat-extra'),
							'icon'  => 'eicon-arrow-down',
						],
						'left'   => [
							'title' => esc_html__('Left', 'onnat-extra'),
							'icon'  => 'eicon-arrow-left',
						],
					],
					'default'    => 'left',
					'toggle'     => false,
					'conditions' => [
						'relation' => 'and',
						'terms'    => [
							[
								'name'     => 'use_button',
								'operator' => '===',
								'value'    => 'yes'
							],
							[
								'name'     => 'btn_text',
								'operator' => '!=',
								'value'    => ''
							],
							[
								'name'     => 'btn_icon[value]',
								'operator' => '!=',
								'value'    => ''
							],
							[
								'name'     => 'btn_icon_pos',
								'operator' => '===',
								'value'    => 'toggle'
							]
						]
					]
				]);
				$this->add_responsive_control( 'btn_icon_size', [
					'label'      => esc_html__('Size', 'onnat-extra' ),
					'type'       => KFCM::SLIDER,
					'size_units' => [ 'px' ],
					'range'      => [
						'px' => [
							'min' => 0,
							'max' => 999,
						],
					],
					'selectors'  => [
						'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button .kfw-elementor-icon-wrap i' => 'font-size: {{SIZE}}{{UNIT}};'
					],
					'conditions' => $btn_icon_condition
				]);
				$this->start_controls_tabs( 'btn_icon_customize_tabs' );
					$this->start_controls_tab( 'btn_icon_normal_state', [
						'label'      => esc_html__( 'Normal', 'onnat-extra' ),
						'conditions' => $btn_icon_condition
					]);
						$this->add_control( 'btn_icon_color', [
							'label'      => esc_html__('Icon Color', 'onnat-extra' ),
							'type'       => KFCM::COLOR,
							'selectors'  => [
								'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button .kfw-elementor-icon-wrap i'   => 'color: {{VALUE}};',
								'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button .kfw-elementor-icon-wrap svg' => 'fill: {{VALUE}};'
							],
							'conditions' => $btn_icon_condition
						]);
						$this->add_group_control( KFGCBG::get_type(), [
							'name'       => 'btn_icon_bg',
							'label'      => esc_html__('Background', 'onnat-extra' ),
							'types'      => [ 'classic', 'gradient' ],
							'exclude'    => [ 'image' ], # To remove background image option in classic mode
							'selector'   => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button .kfw-elementor-icon-wrap',
							'conditions' => $btn_icon_condition
						]);
						$this->add_group_control( KFGCBR::get_type(), [
							'name'           => 'btn_icon_border',
							'fields_options' => [
								'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
								'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
							],
							'selector'       => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button .kfw-elementor-icon-wrap',
							'conditions'     => $btn_icon_condition,
						]);
						$this->add_responsive_control( 'btn_icon_border_radius', [
							'label'      => esc_html__('Border Radius', 'onnat-extra' ),
							'type'       => KFCM::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors'  => [ '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button .kfw-elementor-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
							'conditions' => $btn_icon_condition,
						]);
						$this->add_group_control( KFGCBS::get_type(), [
							'name'       => 'btn_icon_box_shadow',
							'selector'   => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button .kfw-elementor-icon-wrap',
							'conditions' => $btn_icon_condition,
						]);
					$this->end_controls_tab();
					$this->start_controls_tab( 'btn_icon_hover_state', [
						'label'      => esc_html__( 'Hover', 'onnat-extra' ),
						'conditions' => $btn_icon_condition
					]);
						$this->add_control( 'btn_icon_hover_color', [
							'label'      => esc_html__('Color', 'onnat-extra' ),
							'type'       => KFCM::COLOR,
							'selectors'  => [
								'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover .kfw-elementor-icon-wrap i'   => 'color: {{VALUE}};',
								'{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover .kfw-elementor-icon-wrap svg' => 'color: {{VALUE}};',
							],
							'conditions' => $btn_icon_condition
						]);
						$this->add_group_control( KFGCBG::get_type(), [
							'name'       => 'btn_icon_hover_bg',
							'label'      => esc_html__('Background', 'onnat-extra' ),
							'types'      => [ 'classic', 'gradient' ],
							'exclude'    => [ 'image' ], # To remove background image option in classic mode
							'selector'   => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover .kfw-elementor-icon-wrap',
							'conditions' => $btn_icon_condition
						]);
						$this->add_group_control( KFGCBR::get_type(), [
							'name'           => 'btn_icon_hover_border',
							'fields_options' => [
								'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
								'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
							],
							'selector'       => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover .kfw-elementor-icon-wrap',
							'conditions'     => $btn_icon_condition,
						]);
						$this->add_responsive_control( 'btn_icon_hover_border_radius', [
							'label'      => esc_html__('Border Radius', 'onnat-extra' ),
							'type'       => KFCM::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors'  => [ '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover .kfw-elementor-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
							'conditions' => $btn_icon_condition,
						]);
						$this->add_group_control( KFGCBS::get_type(), [
							'name'       => 'btn_icon_hover_box_shadow',
							'selector'   => '{{WRAPPER}} .kfw-ele-widget-lordicon-icon-box-button:hover .kfw-elementor-icon-wrap',
							'conditions' => $btn_icon_condition,
						]);
					$this->end_controls_tab();
				$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function _title( $settings = [] ) {
		if( !empty( $settings['title'] ) ) {

			$title = $settings['title'];
			$link  = isset( $settings['title_link'] ) ? array_filter( $settings['title_link'] ) : [];

			if( isset( $link['url'] ) ) {

				$this->add_render_attribute( 'cta', 'href', esc_url( $link['url'] ) );
				if ( !empty( $link['is_external'] ) ) {
					$this->add_render_attribute( 'cta', 'target', '_blank' );
				}


				if ( !empty( $link['nofollow'] ) ) {
					$this->add_render_attribute( 'cta', 'rel', 'nofollow' );
				}

				$title = '';
				$title .= '<a '. $this->get_render_attribute_string( 'cta' ) .'>';
					$title .= esc_html( $settings['title'] );
				$title .= '</a>';
			}

			$this->add_render_attribute( 'title', [
				'class' => array_filter([
					'kfw-ele-widget-lordicon-icon-box-title'
				])
			]);

			echo '<div '.$this->get_render_attribute_string( 'title' ).'>' . $title . '</div>';
		}
	}

	public function _sub_title( $settings = [] ) {
		if( !empty( $settings['sub_title'] ) ) {

			$this->add_render_attribute( 'sub-title', [
				'class' => array_filter([
					'kfw-ele-widget-lordicon-icon-box-sub-title'
				])
			]);

			echo '<div '.$this->get_render_attribute_string( 'sub-title' ).'>' . $settings['sub_title'] . '</div>';
		}
	}

	public function _description( $settings = [] ) {
		if( !empty( $settings['description'] ) ) {

			$this->add_render_attribute( 'description', [
				'class' => array_filter([
					'kfw-ele-widget-lordicon-icon-box-description'
				])
			]);

			echo '<div '.$this->get_render_attribute_string( 'description' ).'>' . esc_html( $settings['description'] ) . '</div>';
		}
	}

	public function _button( $settings = [] ) {
		if( isset( $settings['use_button'] ) && $settings['use_button'] === 'yes' ) {
			$link = isset( $settings['btn_link'] ) ? array_filter( $settings['btn_link'] ) : [];

			$this->add_render_attribute( 'cta-wrapper', [
				'class' => array_filter([
					'kfw-ele-widget-lordicon-icon-box-button-wrap',
					!empty( trim( $settings['btn_text'] ) ) ? 'kfw-ele-widget-lordicon-icon-box-button-has-txt' : ''
				])
			]);

			echo '<div '.$this->get_render_attribute_string( 'cta-wrapper' ).'>';

				$this->add_render_attribute( 'cta', [
					'class' => array_filter([
						'kfw-ele-widget-lordicon-icon-box-button',
						!empty( $settings['btn_animation_hover'] ) ? 'elementor-animation-'.esc_attr( $settings['btn_animation_hover'] ): '',
					])
				]);

				/**
				 * Button Icon related classes
				 */
				if( $settings['btn_icon']['value'] !== '' ) {
					$this->add_render_attribute( 'cta', [
						'class' => array_filter([
							!empty( trim( $settings['btn_text'] ) ) ? 'kfw-ele-widget-lordicon-icon-box-button-icon-position-'.$settings['btn_icon_pos'] : '',
							( !empty( trim( $settings['btn_text'] ) ) ) && ( $settings['btn_icon_pos'] === 'animated-left' || $settings['btn_icon_pos'] === 'animated-right' ) ? 'kfw-ele-widget-lordicon-icon-box-button-animated-icon-position-' . $settings['alr_btn_icon_animation'] : '',
							( !empty( trim( $settings['btn_text'] ) ) ) && ( $settings['btn_icon_pos'] === 'toggle' ) ? 'kfw-ele-widget-lordicon-icon-box-button-toggle-icon-position-' . $settings['toggle_btn_icon_animation'] : '',								
						])
					]);
				}

				if ( ! empty( $link['url'] ) ) {
					$this->add_render_attribute( 'cta', 'href', esc_url( $link['url'] ) );

					if ( ! empty( $link['is_external'] ) ) {
						$this->add_render_attribute( 'cta', 'target', '_blank' );
					}

					if ( ! empty( $link['nofollow'] ) ) {
						$this->add_render_attribute( 'cta', 'rel', 'nofollow' );
					}
				}

				echo '<a '.$this->get_render_attribute_string( 'cta' ).'>';

					if( $settings['btn_icon_pos'] === 'left' || $settings['btn_icon_pos'] === 'animated-left' ) {
						$this->_render_icon( $settings['btn_icon'] );
					}

					if( !empty( trim( $settings['btn_text'] ) ) ) {
						printf( '<span class="kfw-elementor-button-text">%s</span>', esc_html( $settings['btn_text'] ) );
					}

					if( $settings['btn_icon_pos'] === 'right'
						|| $settings['btn_icon_pos'] === 'animated-right'
						|| $settings['btn_icon_pos'] === 'toggle'
						|| $settings['btn_icon_pos'] === 'toggle-alt'
					) {
						$this->_render_icon( $settings['btn_icon'] );
					}
				echo '</a>';

			echo '</div>';
		}
	}

	public function _render_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

		if( !empty( $icon ) ) {
			echo '<span class="kfw-elementor-icon-wrap">';
				KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
			echo '</span>';
		}
	}

    /**
     * Render widget output on the frontend.
     */
    protected function render() {
        $render = kf_extra_plugin_elementor()->get_template("kfw-lordicon-icon-box");
        include $render;
    }
}