<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
use \Elementor\Plugin as KFEl;
use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Icons_Manager as KFIM;
use \Elementor\Repeater as KFRTR;

use \Elementor\Group_Control_Image_Size as KFGCIS;
use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;

class KFW_Split_Scroll_Alt extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-split-scroll-alt';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Alternate Split Scroll', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_core_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-import-export';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'split', 'scroll', 'alt', 'gsap' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/split-scroll-alt';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        if ( ! wp_script_is( 'kfw-gsap', 'enqueued' ) ) {
            wp_register_script( 'kfw-gsap', KFE_CONST_URL . 'assets/js/gsap.min.js', [], KFE_CONST_VERSION, true );
        }

        if ( ! wp_script_is( 'kfw-gsap-scroll-trigger', 'enqueued' ) ) {
            wp_register_script( 'kfw-gsap-scroll-trigger', KFE_CONST_URL . 'assets/js/ScrollTrigger.min.js', ['kfw-gsap'], KFE_CONST_VERSION, true );
        }

        wp_register_script( 'lordicon',
            KFE_CONST_URL . 'libraries/elementor/assets/js/lordicon.js',
            [],
            KFE_CONST_VERSION,
            true
        );

		wp_register_script( 'kfw-split-scroll-alt',
			KFE_CONST_URL . 'libraries/elementor/assets/js/split-scroll-alt' . KFE_CONST_DEBUG_SUFFIX . '.js',
			[ 'jquery', 'elementor-frontend' ],
			KFE_CONST_VERSION,
			true
		);

		wp_register_style( 'kfw-split-scroll-alt',
			KFE_CONST_URL . 'libraries/elementor/assets/css/split-scroll-alt' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);

    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-split-scroll-alt' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'lordicon', 'kfw-gsap', 'kfw-gsap-scroll-trigger', 'kfw-split-scroll-alt' ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
        $this->_register_items_section();

		$this->_register_frist_last_item_section();
		$this->_register_image_section();
        $this->_register_nav_style_section();
		$this->_register_title_icon_style_section();
		$this->_register_title_style_section();
		$this->_register_sub_title_style_section();
		$this->_register_content_style_section();
		$this->_register_button_style_section();
    }

	public function _register_items_section() {
		$repeater = new KFRTR();
		$this->start_controls_section( 'section_items', [
			'label' => esc_html__( 'Items', 'onnat-extra' )
		]);
			$this->add_control('widget_des', [
				'type'            => KFCM::RAW_HTML,
				'content_classes' => 'kfw-elementor-editor-notice-ctrl',
				'raw'             => esc_html__('For optimal visibility, consider using this widget in a full-width section or a single column.', 'onnat-extra'),
			]);
			$repeater->start_controls_tabs('tabs');
				$repeater->start_controls_tab('tab_content',[
					'label' => esc_html__( 'Content', 'onnat-extra' ),
				]);
					$repeater->add_control('title',[
						'label'       => esc_html__( 'Title', 'onnat-extra' ),
						'type'        => KFCM::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Enter Title' , 'onnat-extra' ),
						'label_block' => true,
					]);
					$repeater->add_control('sub_title',[
						'label'       => esc_html__( 'Sub Title', 'onnat-extra' ),
						'type'        => KFCM::TEXT,
						'dynamic'     => [ 'active' => true, ],
						'placeholder' => esc_html__( 'Sub Title', 'onnat-extra' ),
						'label_block' => true,
					]);
					$repeater->add_control( 'source', [
						'label'   => esc_html__( 'Content Source', 'onnat-extra' ),
						'type'    => KFCM::CHOOSE,
						'options' => [
							'editor'  => [
								'title' => esc_html__('Editor', 'onnat-extra'),
								'icon'  => 'eicon-text-area',
							],
							'template'  => [
								'title' => esc_html__('Template', 'onnat-extra'),
								'icon'  => 'eicon-t-letter',
							],
						],
						'default' => 'editor',
						'toggle'  => false,
					]);
					$repeater->add_control( 'editor', [
						'label'     => esc_html__('Editor', 'onnat-extra'),
						'type'      => KFCM::WYSIWYG,
						'default'   => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
						'condition' => [
							'source' => 'editor',
						],
					]);
                    $repeater->add_control( 'btn_text', [
						'label'     => esc_html__( 'Button Text', 'onnat-extra' ),
						'type'      => KFCM::TEXT,
						'default'   => esc_html__( 'Learn More', 'onnat-extra' ),
						'condition' => [
							'source' => 'editor',
                        ],
                    ]);
                    $repeater->add_control( 'btn_link', [
                        'label'       => esc_html__( 'Link', 'onnat-extra' ),
                        'type'        => KFCM::URL,
                        'placeholder' => 'https://your-link.com',
                        'default'     => [ 'url' => '#' ],
                        'condition'   => [
                            'source'    => 'editor',
                            'btn_text!' => '',
                        ]
                    ]);
                    $repeater->add_control( 'btn_icon', [
                        'label'       => esc_html__( 'Icon', 'onnat-extra' ),
                        'type'        => KFCM::ICONS,
                        'skin'        => 'inline',
                        'label_block' => false,
                        'default'     => [
                            'value'   => 'fa fa-check',
                            'library' => 'fa-solid'
                        ],
                        'condition'   => [
                            'source'    => 'editor',
                            'btn_text!' => '',
                        ],
                    ]);
                    $repeater->add_control( 'btn_icon_pos', [
                        'label'     => esc_html__( 'Icon Position', 'onnat-extra' ),
                        'type'      => KFCM::CHOOSE,
                        'options'   => [
                            'left'   => [
                                'title' => esc_html__('Left', 'onnat-extra'),
                                'icon'  => 'eicon-text-align-left',
                            ],
                            'right'  => [
                                'title' => esc_html__('Right', 'onnat-extra'),
                                'icon'  => 'eicon-text-align-right',
                            ],
                        ],
                        'default'   => 'left',
                        'toggle'    => false,
                        'condition' => [
                            'source'    => 'editor',
                            'btn_text!' => '',
                            'btn_icon[value]!' => ''
                        ],
                    ]);
					$repeater->add_control( 'template', [
						'label'     => esc_html__('Template', 'onnat-extra'),
						'type'      => KFCM::SELECT,
						'default'   => 0,
						'options'   => kf_extra_plugin_elementor()->get_elementor_library(),
						'condition' => [
							'source'  => 'template',
						],
					]);
				$repeater->end_controls_tab();

                $repeater->start_controls_tab('tab_image',[
                    'label' => esc_html__( 'Main Image', 'onnat-extra' ),
                ]);
                    $repeater->add_control( 'main_image', [
                        'label'   => esc_html__('Image', 'onnat-extra'),
                        'type'    => KFCM::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                            'id'  => -1
                        ],
                        'dynamic' => [
                            'active' => true,
                        ],
                    ]);
				$repeater->end_controls_tab();

                $repeater->start_controls_tab('tab_icon',[
                    'label' => esc_html__( 'Header Icon', 'onnat-extra' ),
                ]);
					$repeater->add_control('icons_settings_des', [
						'type'            => KFCM::RAW_HTML,
						'content_classes' => 'kfw-elementor-editor-notice-ctrl',
						'raw'             => sprintf(
							esc_html__('Icon settings reflects only if %1$s Use Title Icon option %2$s is set to %1$sYES%2$s.', 'onnat-extra'),
							'<b> <i> ', '<i> </b>'
						),
					]);
                    $repeater->add_control('icon_type',[
                        'label'   => esc_html__( 'Icon Type', 'onnat-extra' ),
                        'type'    => KFCM::CHOOSE,
                        'options' => [
                            'blank'             => [
                                'title' => esc_html__('Blank', 'onnat-extra'),
                                'icon'  => '',
                            ],
                            'icon'              => [
                                'title' => esc_html__('Icon', 'onnat-extra'),
                                'icon'  => 'eicon-plus-circle-o',
                            ],
                            'image'             => [
                                'title' => esc_html__('Image', 'onnat-extra'),
                                'icon'  => 'eicon-image',
                            ],
							'text'           => [
                                'title' => esc_html__('Text', 'onnat-extra'),
                                'icon'  => 'eicon-t-letter',
							],
							'lordicon_media' => [
                                'title' => esc_html__('Upload Lordicon From Media', 'onnat-extra'),
                                'icon'  => 'eicon-library-upload',
                            ],
                            'lordicon_external' => [
                                'title' => esc_html__('Upload Lordicon From Extrnal', 'onnat-extra'),
                                'icon'  => 'eicon-editor-external-link',
                            ],
                        ],
                        'default' => 'blank',
                        'toggle'  => false
                    ]);
                    $repeater->add_control( 'icon', [
                        'label'     => esc_html__( 'Icon', 'onnat-extra' ),
                        'type'      => KFCM::ICONS,
                        'default'   => [
                            'value'   => 'fas fa-heart',
                            'library' => 'fa-solid',
                        ],
                        'condition' => [
                            'icon_type' => 'icon'
                        ],
                    ]);
                    $repeater->add_control( 'image', [
                        'label'     => esc_html__( 'Image', 'onnat-extra' ),
                        'type'      => KFCM::MEDIA,
                        'dynamic'   => [ 'active' => true ],
                        'default'   => [
                            'url' => \Elementor\Utils::get_placeholder_image_src()
                        ],
                        'condition' => [
                            'icon_type' => 'image'
                        ],
                    ]);
					$repeater->add_control('text',[
						'label'       => esc_html__( 'Text', 'onnat-extra' ),
						'type'        => KFCM::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'A' , 'onnat-extra' ),
						'label_block' => true,
						'condition'   => [
                            'icon_type' => 'text'
                        ],
					]);
                    $repeater->add_control('lordicon_des', [
                        'type'            => KFCM::RAW_HTML,
                        'content_classes' => 'kfw-elementor-editor-notice-ctrl',
                        'raw'             => sprintf(
                            esc_html__('You can get lordicon code from %1$s ', 'onnat-extra'),
                            sprintf('<a href="%1$s" target="_blank">%2$s</a>', esc_url( 'https://lordicon.com/' ), esc_html_x( 'Lordicon.com', 'link text for lordicon.com', 'onnat-extra' ) )
                        ),
                        'condition'       => [
                            'icon_type' => [ 'lordicon_media', 'lordicon_external' ]
                        ],
                    ]);
                    $repeater->add_control('lordicon_media', [
                        'label'      => esc_html__( 'Upload JSON File', 'onnat-extra' ),
                        'type'       => KFCM::MEDIA,
                        'media_type' => 'application/json',
                        'default'    => [
                            'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                        ],
                        'condition'  => [
                            'icon_type' => 'lordicon_media'
                        ]
                    ]);
                    $repeater->add_control('lordicon_external', [
                        'label'       => esc_html__( 'Upload JSON File', 'onnat-extra' ),
                        'type'        => KFCM::URL,
                        'dynamic'     => [ 'active' => true, ],
                        'placeholder' => esc_html__( 'Enter your URL', 'onnat-extra' ),
                        'options'     => [ 'url' ],
                        'default'     => [
                            'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                        ],
                        'condition'   => [
                            'icon_type' => 'lordicon_external'
                        ]
                    ]);
				$repeater->end_controls_tab();
			$repeater->end_controls_tabs();

			$this->add_control('items', [
				'type'        => KFCM::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
                        'title'      => 'Item 1',
                        'sub_title'  => 'This is item 1',
                        'source'     => 'editor',
                        'editor'     => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin sit amet auctor odio. Donec finibus, sem sed facilisis eleifend, mi ligula faucibus neque, sed tristique libero ante ac dui. Phasellus fermentum velit non elit euismod molestie.',
                        'main_image' => [
							'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-1.svg'
						]

					],
					[
                        'title'      => 'Item 2',
                        'sub_title'  => 'This is item 2',
                        'source'     => 'editor',
                        'editor'     => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin sit amet auctor odio. Donec finibus, sem sed facilisis eleifend, mi ligula faucibus neque, sed tristique libero ante ac dui. Phasellus fermentum velit non elit euismod molestie.',
                        'main_image' => [
							'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-2.svg'
						]
					],
					[
                        'title'      => 'Item 3',
                        'sub_title'  => 'This is item 3',
                        'source'     => 'editor',
                        'editor'     => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin sit amet auctor odio. Donec finibus, sem sed facilisis eleifend, mi ligula faucibus neque, sed tristique libero ante ac dui. Phasellus fermentum velit non elit euismod molestie.',
                        'main_image' => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-3.svg'
						]
					],
					[
                        'title'      => 'Item 4',
                        'sub_title'  => 'This is item 4',
                        'source'     => 'editor',
                        'editor'     => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin sit amet auctor odio. Donec finibus, sem sed facilisis eleifend, mi ligula faucibus neque, sed tristique libero ante ac dui. Phasellus fermentum velit non elit euismod molestie.',
                        'main_image' => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-4.svg'
						]
					],
					[
                        'title'      => 'Item 5',
                        'sub_title'  => 'This is item 5',
                        'source'     => 'editor',
                        'editor'     => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin sit amet auctor odio. Donec finibus, sem sed facilisis eleifend, mi ligula faucibus neque, sed tristique libero ante ac dui. Phasellus fermentum velit non elit euismod molestie.',
                        'main_image' => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-5.svg'
						]
					]
				],
				'title_field' => '{{{ title }}}'
			]);
            $this->add_control('hr_0', [
                'type' => KFCM::DIVIDER,
            ]);
            $this->add_control('layout_type',[
                'label'   => esc_html__( 'Layout Type', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'toggle'  => false,
                'default' => 'layout-right',
                'options' => [
                    'layout-left' => [
                        'title' => esc_html__('Left', 'onnat-extra'),
                        'icon'  => 'eicon-h-align-left'
                    ],
                    'layout-right' => [
                        'title' => esc_html__('Right', 'onnat-extra'),
                        'icon'  => 'eicon-h-align-right'
                    ],
                ],
            ]);
            $this->add_control('use_header_icon',[
                'label'        => esc_html__( 'Use Header Icon?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes'
            ]);
            $this->add_group_control( KFGCIS::get_type(), [
                'name'    => 'image_size',
                'default' => 'full',
            ]);
            $this->add_control('enable_bullet', [
                'label'        => esc_html__('Use Bullet', 'onnat-extra'),
                'type'         => KFCM::SWITCHER,
                'dynamic'      => [ 'active' => true ],
                'return_value' => 'yes',
                'default'      => 0,
            ]);
		$this->end_controls_section();
	}

	public function _register_frist_last_item_section() {
		$this->start_controls_section( 'section_first_last_item_style', [
			'label' => esc_html__( 'First & Last Item', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_control('first_item_heading',[
				'label' => esc_html__( 'First Item', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
			]);
				$this->add_responsive_control( 'first_item_padding', [
					'label'              => esc_html__('Padding', 'onnat-extra' ),
					'type'               => KFCM::DIMENSIONS,
					'size_units'         => [ 'px', 'em', '%' ],
					'allowed_dimensions' => [ 'top', 'bottom' ],
					'default'            => [
						'top'      => '285',
						'right'    => 'auto',
						'bottom'   => '285',
						'left'     => 'auto',
						'unit'     => 'px',
						'isLinked' => false,
					],
					'selectors'          => [
						'{{WRAPPER}} .kfw-ele-widget-split-scroll-alt-main .kfw-elementor-split-scroll-alt-content-wrap' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}};',
					]
				]);
			$this->add_control('last_item_heading',[
				'label' => esc_html__( 'Last Item', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
			]);
				$this->add_responsive_control( 'last_item_padding', [
					'label'              => esc_html__('Padding', 'onnat-extra' ),
					'type'               => KFCM::DIMENSIONS,
					'size_units'         => [ 'px', 'em', '%' ],
					'allowed_dimensions' => [ 'top', 'bottom' ],
					'default'            => [
						'top'      => '285',
						'right'    => 'auto',
						'bottom'   => '285',
						'left'     => 'auto',
						'unit'     => 'px',
						'isLinked' => false,					
					],
					'selectors'          => [
						'{{WRAPPER}} .kfw-ele-widget-split-scroll-alt-main .kfw-elementor-split-scroll-alt-content-item.last .kfw-elementor-split-scroll-alt-content-wrap' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}};',
					]
				]);			
		$this->end_controls_section();
	}

	public function _register_image_section() {
		$this->start_controls_section( 'section_img_style', [
			'label' => esc_html__( 'Image', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'           => 'img_wrap_bg',
				'types'          => ['classic', 'gradient'],
				'exclude'        => [ 'image'],
				'fields_options' => [
					'background' => [ 'default' => 'classic' ],
					'color'      => [ 'default' => '' ],
				],
				'selector'       => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-img-item, {{WRAPPER}} .kfw-split-scroll-alt-mobile-img-wrap',
			]);
            $this->add_responsive_control( 'img_wrap_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-split-scroll-alt-img-item, {{WRAPPER}} .kfw-split-scroll-alt-mobile-img-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'img_wrap_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-split-scroll-alt-img-item, {{WRAPPER}} .kfw-split-scroll-alt-mobile-img-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_group_control( KFGCBR::get_type(), [
				'name'      => 'img_wrap_border',
				'selector'  => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-img-item, {{WRAPPER}} .kfw-split-scroll-alt-mobile-img-wrap'
			]);
			$this->add_responsive_control( 'img_wrap_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-elementor-split-scroll-alt-img-item, {{WRAPPER}} .kfw-elementor-split-scroll-alt-img-item img,
					{{WRAPPER}} .kfw-split-scroll-alt-mobile-img-wrap, {{WRAPPER}} .kfw-split-scroll-alt-mobile-img-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'      => 'img_wrap_box_shadow',
				'selector'  => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-img-item, {{WRAPPER}} .kfw-split-scroll-alt-mobile-img-wrap'
			]);
		$this->end_controls_section();
	}

    public function _register_nav_style_section() {
        $this->start_controls_section( 'section_nav', [
            'label'     => esc_html__( 'Bullet', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => [
                'enable_bullet' => 'yes'
            ],
        ]);
            $this->add_responsive_control( 'bullet_size', [
                'label'      => esc_html__('Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
					'{{WRAPPER}} .kfw-elementor-split-scroll-alt-nav li'          => 'width: {{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .kfw-elementor-split-scroll-alt-nav li.selected' => 'width: {{SIZE}}{{UNIT}}; height:calc({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}/2 );'
                ],
                'condition'  => [
                    'enable_bullet' => 'yes'
                ],
            ]);
			$this->add_responsive_control( 'bullet_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-elementor-split-scroll-alt-nav li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]);
            $this->add_control( 'bullet_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'selectors' => ['{{WRAPPER}} .kfw-elementor-split-scroll-alt-nav li' => 'background: {{VALUE}};' ],
            ]);
            $this->add_control( 'bullet_active_color', [
                'label'     => esc_html__('Active Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'selectors' => ['{{WRAPPER}} .kfw-elementor-split-scroll-alt-nav li.selected' => 'background: {{VALUE}};' ],
            ]);
        $this->end_controls_section();
    }

    public function _register_title_icon_style_section() {
		$this->start_controls_section( 'section_icon_style', [
			'label'     => esc_html__( 'Title Icon', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [
                'use_header_icon!' => '',
			],
		]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'           => 'icon_bg',
				'types'          => ['classic', 'gradient'],
				'exclude'        => [ 'image'],
				'fields_options' => [
					'background' => [ 'default' => 'classic' ],
					'color'      => [ 'default' => '' ],
				],
				'selector'       => '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap .kfw-elementor-icon-wrap',
			]);
			$this->add_group_control( KFGCBR::get_type(), [
				'name'      => 'icon_border',
				'selector'  => '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap .kfw-elementor-icon-wrap'
			]);
			$this->add_responsive_control( 'icon_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap .kfw-elementor-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'      => 'icon_box_shadow',
				'selector'  => '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap .kfw-elementor-icon-wrap'
			]);
            $this->add_responsive_control( 'icon_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'icon_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap .kfw-elementor-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);

            /**
             * Style: Icon Type
             */
                $this->add_control('icon_type_style_before_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_control('icon_type_style_heading',[
					'label' => esc_html__( 'Icon Type Style', 'onnat-extra' ),
					'type'  => KFCM::HEADING,
				]);
				$this->add_control('icon_type_style_after_hr', [
					'type' => KFCM::DIVIDER,
				]);
                $this->add_responsive_control( 'icon_type_size', [
                    'label'      => esc_html__('Size', 'onnat-extra' ),
                    'type'       => KFCM::SLIDER,
                    'size_units' => [ 'px' ],
                    'range'      => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-icon-type .kfw-elementor-icon-wrap svg, {{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-icon-type .kfw-elementor-icon-wrap i' => 'font-size: {{SIZE}}{{UNIT}};'
                    ],
                ]);
				$this->add_control( 'icon_type_color', [
					'label'     => esc_html__('Normal Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'selectors' => [
						'{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-icon-type .kfw-elementor-icon-wrap' => 'color:{{VALUE}};fill:{{VALUE}};',
					],
				]);

			/**
			 * Style: Text Type
			 */
				$this->add_control('txt_type_style_before_hr', [
					'type' => KFCM::DIVIDER,
				]);
				$this->add_control('txt_type_style_heading',[
					'label' => esc_html__( 'Text Type Style', 'onnat-extra' ),
					'type'  => KFCM::HEADING,
				]);
				$this->add_control('txt_type_style_after_hr', [
					'type' => KFCM::DIVIDER,
				]);
				$this->add_group_control(KFGCT::get_type(), [
					'name'     => 'txt_type_typo',
					'label'    => esc_html__( 'Typography', 'onnat-extra' ),
					'selector' => '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-txt-type .kfw-elementor-icon-wrap',
				]);
				$this->add_control( 'txt_type_color', [
					'label'     => esc_html__('Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'selectors' => [
						'{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-txt-type .kfw-elementor-icon-wrap' => 'color: {{VALUE}};'
					],
				]);
				$this->add_group_control( KFGCTS::get_type(), [
					'name'     => 'txt_type_txt_shadow',
					'selector' => '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-txt-type .kfw-elementor-icon-wrap',
				]);
				$this->add_group_control( KFGCTST::get_type(), [
					'name'     => 'txt_type_txt_stroke',
					'selector' => '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-txt-type .kfw-elementor-icon-wrap',
				]);

            /**
             * Style: Image Type
             */
                $this->add_control('img_type_style_before_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_control('img_type_style_heading',[
                    'label' => esc_html__( 'Image Type Style', 'onnat-extra' ),
                    'type'  => KFCM::HEADING,
                ]);
                $this->add_control('img_type_style_after_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_responsive_control( 'img_type_size', [
                    'label'      => esc_html__('Size', 'onnat-extra' ),
                    'type'       => KFCM::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min' => 5,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-image-type img' => 'max-width:{{SIZE}}px;'
                    ],
                ]);

            /**
             * Style: Lordicon Type
             */
                $this->add_control('lordicon_type_style_before_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_control('lordicon_type_style_heading',[
                    'label' => esc_html__( 'LordIcon Type Style', 'onnat-extra' ),
                    'type'  => KFCM::HEADING,
                ]);
                $this->add_control('lordicon_type_style_after_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_responsive_control( 'lordicon_type_size', [
                    'label'      => esc_html__('Size', 'onnat-extra' ),
                    'type'       => KFCM::SLIDER,
                    'size_units' => [ 'px' ],
                    'range'      => [
                        'px' => [
                            'min' => 1,
                            'max' => 300,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-lordicon-type .kfw-elementor-icon-wrap,
                        {{WRAPPER}} .kfw-split-scroll-alt-title-icon-wrap.kfw-split-scroll-alt-title-lordicon-type .kfw-elementor-lordicon' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};'
                    ]
                ]);
				$this->add_control( 'lordicon_color_settings', [
                    'label'        => esc_html__('Colors', 'onnat-extra'),
					'type'         => KFCM::POPOVER_TOGGLE,
					'return_value' => 'yes',
				]);
                $this->start_popover();
                    $this->add_control('lordicon_primary_color',[
                        'label'     => __( 'Primary Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'default'   => '#121331',
                    ]);
                    $this->add_control('lordicon_secondary_color',[
                        'label'   => __( 'Secondary Color', 'onnat-extra' ),
                        'type'    => KFCM::COLOR,
                        'default' => '#121331',
                    ]);
                    $this->add_control('lordicon_tertiary_color',[
                        'label'   => __( 'Tertiary Color', 'onnat-extra' ),
                        'type'    => KFCM::COLOR,
                        'default' => '#0816A8',
                    ]);
                $this->end_popover();
		$this->end_controls_section();
    }

    public function _register_title_style_section() {
		$this->start_controls_section( 'section_title_style', [
			'label' => esc_html__( 'Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'title_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-split-scroll-alt-title',
            ]);
            $this->add_responsive_control( 'title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-split-scroll-alt-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-split-scroll-alt-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'title_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => ['{{WRAPPER}} .kfw-split-scroll-alt-title' => 'color: {{VALUE}};' ],
			]);
			$this->add_group_control( KFGCTS::get_type(), [
				'name'     => 'title_txt_shadow',
				'selector' => '{{WRAPPER}} .kfw-split-scroll-alt-title',
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'     => 'title_txt_stroke',
				'selector' => '{{WRAPPER}} .kfw-split-scroll-alt-title',
			]);
		$this->end_controls_section();
    }

    public function _register_sub_title_style_section() {
		$this->start_controls_section( 'section_sub_title_style', [
			'label' => esc_html__( 'Sub Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'sub_title_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-split-scroll-alt-sub-title',
            ]);
            $this->add_responsive_control( 'sub_title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-split-scroll-alt-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'sub_title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-split-scroll-alt-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'sub_title_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => ['{{WRAPPER}} .kfw-split-scroll-alt-sub-title' => 'color: {{VALUE}};' ],
			]);
			$this->add_group_control( KFGCTS::get_type(), [
				'name'     => 'sub_title_txt_shadow',
				'selector' => '{{WRAPPER}} .kfw-split-scroll-alt-sub-title',
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'     => 'sub_title_txt_stroke',
				'selector' => '{{WRAPPER}} .kfw-split-scroll-alt-sub-title',
			]);
		$this->end_controls_section();
    }

    public function _register_content_style_section() {
		$this->start_controls_section( 'section_content_style', [
			'label' => esc_html__( 'Content', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'content_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info',
            ]);
            $this->add_responsive_control( 'content_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'content_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'content_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'selectors' => ['{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info' => 'color: {{VALUE}};' ],
            ]);
            $this->add_group_control( KFGCTS::get_type(), [
                'name'     => 'content_txt_shadow',
                'selector' => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info',
            ]);
            $this->add_group_control( KFGCTST::get_type(), [
                'name'     => 'content_txt_stroke',
                'selector' => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info',
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'           => 'content_bg',
                'types'          => ['classic', 'gradient'],
                'exclude'        => [ 'image'],
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color'      => [ 'default' => '' ],
                ],
                'selector'       => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'content_border',
                'selector'  => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info'
            ]);
            $this->add_responsive_control( 'content_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'content_box_shadow',
                'selector'  => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-info-editor-type .kfw-elementor-split-scroll-alt-info'
            ]);
		$this->end_controls_section();
    }

    public function _register_button_style_section() {
		$this->start_controls_section( 'section_button_style', [
			'label' => esc_html__( 'Button', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control( KFGCT::get_type(), [
                'name'        => 'button_typo',
                'description' => esc_html__( 'Typography', 'onnat-extra' ),
                'selector'    => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-button',
            ]);
            $this->add_responsive_control( 'btn_icon_size', [
                'label'      => esc_html__('Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 999,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-split-scroll-alt-button .kfw-elementor-icon-wrap' => 'font-size: {{SIZE}}{{UNIT}};'
                ],
            ]);
			$this->add_responsive_control( 'button_padding', [
				'label'      => esc_html__( 'Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-elementor-split-scroll-alt-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]);
			$this->add_responsive_control( 'button_margin', [
				'label'      => esc_html__( 'Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'separator'  => 'after',
				'selectors'  => [
					'{{WRAPPER}} .kfw-elementor-split-scroll-alt-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]);
			$this->start_controls_tabs( 'button_customize_tabs' );
				$this->start_controls_tab( 'button_normal_state', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'button_color', [
						'label'      => esc_html__('Button Text Color', 'onnat-extra' ),
						'type'       => KFCM::COLOR,
						'selectors'  => [
							'{{WRAPPER}} .kfw-elementor-split-scroll-alt-button'                              => 'color: {{VALUE}};',
							'{{WRAPPER}} .kfw-elementor-split-scroll-alt-button .kfw-elementor-icon-wrap i'     => 'color: {{VALUE}};',
							'{{WRAPPER}} .kfw-elementor-split-scroll-alt-button .kfw-elementor-icon-wrap svg' => 'fill: {{VALUE}};',
						],
					]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'       => 'button_background',
						'label'      => esc_html__('Background', 'onnat-extra' ),
						'types'      => [ 'classic', 'gradient' ],
						'exclude'    => [ 'image'],
						'selector'   => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-button',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'button_border',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-button',
					]);
					$this->add_responsive_control( 'button_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [ '{{WRAPPER}} .kfw-elementor-split-scroll-alt-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'       => 'button_box_shadow',
						'selector'   => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-button',
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'button_hover_state', [
					'label'     => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'button_color_hover', [
						'label'      => esc_html__('Button Text Color', 'onnat-extra' ),
						'type'       => KFCM::COLOR,
						'selectors'  => [
							'{{WRAPPER}} .kfw-elementor-split-scroll-alt-button:hover'                              => 'color: {{VALUE}};',
							'{{WRAPPER}} .kfw-elementor-split-scroll-alt-button:hover .kfw-elementor-icon-wrap i'     => 'color: {{VALUE}};',
							'{{WRAPPER}} .kfw-elementor-split-scroll-alt-button:hover .kfw-elementor-icon-wrap svg' => 'fill: {{VALUE}};',
						],
					]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'       => 'button_background_hover',
						'label'      => esc_html__('Background', 'onnat-extra' ),
						'types'      => [ 'classic', 'gradient' ],
						'exclude'    => [ 'image' ],
						'selector'   => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-button:hover',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'button_border_hover',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-button:hover',
					]);
					$this->add_responsive_control( 'button_border_radius_hover', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kfw-elementor-split-scroll-alt-button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'       => 'button_box_shadow_hover',
						'selector'   => '{{WRAPPER}} .kfw-elementor-split-scroll-alt-button:hover',
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
    }

	public function _render_text( $txt ) {
		if( !empty( $txt ) ) {

			printf('<div class="kfw-split-scroll-alt-title-icon-wrap kfw-split-scroll-alt-title-txt-type">
					<span class="kfw-elementor-icon-wrap">%s</span>
				</div>', $txt
			);

		}
	}

	public function _render_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

		if( !empty( $icon ) ) {
            echo '<div class="kfw-split-scroll-alt-title-icon-wrap kfw-split-scroll-alt-title-icon-type">';
                echo '<span class="kfw-elementor-icon-wrap">';
                    KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
                echo '</span>';
            echo '</div>';
		}
    }

    public function _render_img( $settings = [], $wrap = true ) {
        if( !empty( $settings['url'] ) ) {
            $image_src = $settings['url'];

			$image_title = $this->_get_image_title( $settings );
			$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

			$image_alt = $this->_get_image_alt( $settings );
			$image_alt = empty( $image_alt ) ? $image_title : $image_title;

			if( $wrap ) {
				echo '<div class="kfw-split-scroll-alt-title-icon-wrap kfw-split-scroll-alt-title-image-type">';
			}
                echo '<span class="kfw-elementor-icon-wrap">';
                    echo '<img alt="'. esc_attr( $image_alt ) .'" title="'. esc_attr( $image_title ) .'" src="'. esc_url( $image_src ) .'"/>';
                echo '</span>';
			if( $wrap ) {
				echo '</div>';
			}
        }
    }

    public static function _get_image_src( $attachment_id, $image_size_key, array $settings ) {
        return KFGCIS::get_attachment_image_src( $attachment_id, $image_size_key, $settings );
    }

	public function _get_image_title( $attachment ) {
		if ( empty( $attachment['id'] ) ) {
			return '';
		}

		return get_the_title( $attachment['id'] );
	}

	public function _get_image_alt( $instance ) {
		if ( empty( $instance['id'] ) ) {
			// For `Insert From URL` images.
			return isset( $instance['alt'] ) ? trim( strip_tags( $instance['alt'] ) ) : '';
		}

		$attachment_id = $instance['id'];
		if ( ! $attachment_id ) {
			return '';
		}

		$attachment = get_post( $attachment_id );
		if ( ! $attachment ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		if ( ! $alt ) {
			$alt = $attachment->post_excerpt;
			if ( ! $alt ) {
				$alt = $attachment->post_title;
			}
		}
		return trim( strip_tags( $alt ) );
	}

	public function _render_button_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

		if( !empty( $icon ) ) {
			echo '<span class="kfw-elementor-icon-wrap">';
				KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
			echo '</span>';
		}
	}

	public function _button( $item, $index ) {
		if( !empty( $item['btn_text'] ) ) {
			$link = array_filter( $item['btn_link'] );
			if ( ! empty( $link['url'] ) ) {
				$r_con_a_item = $this->get_repeater_setting_key( 'r_con_a_item', 'items', $index );
				$this->add_render_attribute( $r_con_a_item, [
					'href'  => esc_url( $link['url'] ),
					'class' => array_filter([
						'kfw-elementor-split-scroll-alt-button',
						'kfw-elementor-split-scroll-alt-icon-align-' . esc_attr( $item['btn_icon_pos'] ),
					])
				] );

				if ( ! empty( $link['is_external'] ) ) {
					$this->add_render_attribute( $r_con_a_item, 'target', '_blank' );
				}

				if ( ! empty( $link['nofollow'] ) ) {
					$this->add_render_attribute( $r_con_a_item, 'rel', 'nofollow' );
				}

				echo '<div class="kfw-elementor-split-scroll-alt-button-wrap"><a '.$this->get_render_attribute_string( $r_con_a_item ).'>';

					if( $item['btn_icon_pos'] === 'left' ) {
						$this->_render_button_icon( $item['btn_icon']);
					}

					echo esc_html( $item['btn_text'] );

					if( $item['btn_icon_pos'] === 'right' ) {
						$this->_render_button_icon( $item['btn_icon']);
					}
				echo '</a> </div>';
			}
		}

	}

    public function _nav( $items, $selected = '' ) {
        $nav = '';
        if( !empty( $items )  ) {
            $nav .= '<ul class="kfw-elementor-split-scroll-alt-nav">';
            foreach( $items as $index => $item ) {
                if( $index == $selected ) {
                    $nav .= '<li class="selected"></li>';
                } else {
                    $nav .= '<li></li>';
                }
            }

            $nav .= '</ul>';
        }

        return $nav;
    }

    public function _is_editor_mode() {
        $preview = KFEl::instance()->preview->is_preview_mode();
        $editor  = KFEl::instance()->editor->is_edit_mode();

        return ( $preview || $editor ) ? true : false;
    }

	/**
	 * Get template content
	 */
	public function _generate_template_content( $template_id ) {
		return KFEl::instance()->frontend->get_builder_content_for_display( $template_id );
	}

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-split-scroll-alt");
		include $render;
    }
}