<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use Elementor\Widget_Base as WB;
use Elementor\Controls_Manager as KFCM;
use Elementor\Repeater as KFRTR;
use Elementor\Icons_Manager as KFIM;
use Elementor\Plugin as KFEl;

use \Elementor\Group_Control_Background as KFGCBG;
use Elementor\Group_Control_Typography as KFGCT;
use Elementor\Group_Control_Border as KFGCBR;
use Elementor\Group_Control_Box_Shadow as KFGCBS;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;

class KFW_Tabs extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-tabs';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Tabs', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_core_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-tabs';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'tabs', 'tab', 'simple' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/tabs';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

		wp_register_script( 'lordicon',
			KFE_CONST_URL . 'libraries/elementor/assets/js/lordicon.js',
			[],
			KFE_CONST_VERSION,
			true
		);

		wp_register_script( 'kfw-tabs',
			KFE_CONST_URL . 'libraries/elementor/assets/js/tabs' . KFE_CONST_DEBUG_SUFFIX . '.js',
			[ 'jquery', 'elementor-frontend' ],
			KFE_CONST_VERSION,
			true
		);

		wp_register_style( 'kfw-tabs',
			KFE_CONST_URL . 'libraries/elementor/assets/css/tabs' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);

    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-tabs' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'lordicon', 'kfw-tabs' ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_tabs_section();
		$this->_register_settings_section();

		$this->_register_tab_type_style_section();
		$this->_register_title_style_section();
		$this->_register_sub_title_style_section();
		$this->_register_content_style_section();
		$this->_register_content_wrap_style_section();
        $this->_register_icon_style_section();
    }

    public function _register_tabs_section() {
		$repeater = new KFRTR();

		$this->start_controls_section( 'section_tabs', [
			'label' => esc_html__( 'Tabs', 'onnat-extra' )
		]);
            $repeater->start_controls_tabs('tabs_tabs');
                $repeater->start_controls_tab('tab_content',[
                    'label' => esc_html__( 'Content', 'onnat-extra' ),
                ]);
                    $repeater->add_control('title',[
                        'label'       => esc_html__( 'Title', 'onnat-extra' ),
                        'type'        => KFCM::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Tab Title' , 'onnat-extra' ),
                        'label_block' => true,
                    ]);
                    $repeater->add_control('sub_title',[
                        'label'       => esc_html__( 'Sub Title', 'onnat-extra' ),
                        'type'        => KFCM::TEXT,
                        'dynamic'     => [ 'active' => true, ],
                        'placeholder' => esc_html__( 'Sub Title', 'onnat-extra' ),
                        'label_block' => true,
                    ]);
                    $repeater->add_control( 'source', [
                        'label'   => esc_html__( 'Content Source', 'onnat-extra' ),
                        'type'    => KFCM::CHOOSE,
                        'options' => [
                            'editor'  => [
                                'title' => esc_html__('Editor', 'onnat-extra'),
                                'icon'  => 'eicon-text-area',
                            ],
                            'template'  => [
                                'title' => esc_html__('Template', 'onnat-extra'),
                                'icon'  => 'eicon-t-letter',
                            ],
                        ],
                        'default' => 'editor',
                        'toggle'  => false,
                    ]);
                    $repeater->add_control( 'editor', [
                        'label' => esc_html__('Editor', 'onnat-extra'),
                        'type'      => KFCM::WYSIWYG,
                        'default'   => esc_html__( 'Tab Item Content', 'onnat-extra'),
                        'condition' => [
                            'source'  => 'editor',
                        ],
                    ]);
                    $repeater->add_control( 'template', [
                        'label'     => esc_html__('Template', 'onnat-extra'),
                        'type'      => KFCM::SELECT,
                        'default'   => 0,
                        'options'   => kf_extra_plugin_elementor()->get_elementor_library(),
                        'condition' => [
                            'source'  => 'template',
                        ],
                    ]);
                $repeater->end_controls_tab();
                $repeater->start_controls_tab('tab_icon',[
                    'label' => esc_html__( 'Icon', 'onnat-extra' ),
                ]);
                    $repeater->add_control('icons_settings_des', [
                        'type'            => KFCM::RAW_HTML,
                        'content_classes' => 'kfw-elementor-editor-notice-ctrl',
                        'raw'             => sprintf(
                            esc_html__('Icon settings reflects only if %1$s Tab Settings > Use Icon option %2$s is set to %1$sYES%2$s.', 'onnat-extra'),
                            '<b> <i> ', '<i> </b>'
                        ),
                    ]);
                    $repeater->add_control('icon_type',[
                        'label'   => esc_html__( 'Icon Type', 'onnat-extra' ),
                        'type'    => KFCM::CHOOSE,
                        'options' => [
                            'blank'             => [
                                'title' => esc_html__('Blank', 'onnat-extra'),
                                'icon'  => '',
                            ],
                            'icon'              => [
                                'title' => esc_html__('Icon', 'onnat-extra'),
                                'icon'  => 'eicon-plus-circle-o',
                            ],
                            'image'             => [
                                'title' => esc_html__('Image', 'onnat-extra'),
                                'icon'  => 'eicon-image',
                            ],
                            'lordicon_media'    => [
                                'title' => esc_html__('Upload Lordicon From Media', 'onnat-extra'),
                                'icon'  => 'eicon-library-upload',
                            ],
                            'lordicon_external' => [
                                'title' => esc_html__('Upload Lordicon From Extrnal', 'onnat-extra'),
                                'icon'  => 'eicon-editor-external-link',
                            ],
                        ],
                        'default' => 'blank',
                        'toggle'  => false
                    ]);
                    $repeater->add_control( 'icon', [
                        'label'     => esc_html__( 'Icon', 'onnat-extra' ),
                        'type'      => KFCM::ICONS,
                        'default'   => [
                            'value'   => 'fas fa-heart',
                            'library' => 'fa-solid',
                        ],
                        'condition' => [
                            'icon_type' => 'icon'
                        ],
                    ]);
                    $repeater->add_control( 'image', [
                        'label'     => esc_html__( 'Image', 'onnat-extra' ),
                        'type'      => KFCM::MEDIA,
                        'dynamic'   => [ 'active' => true ],
                        'default'   => [
                            'url' => \Elementor\Utils::get_placeholder_image_src()
                        ],
                        'condition' => [
                            'icon_type' => 'image'
                        ],
                    ]);
                    $repeater->add_control('lordicon_des', [
                        'type'            => KFCM::RAW_HTML,
                        'content_classes' => 'kfw-elementor-editor-notice-ctrl',
                        'raw'             => sprintf(
                            esc_html__('You can get lordicon code from %1$s ', 'onnat-extra'),
                            sprintf('<a href="%1$s" target="_blank">%2$s</a>', esc_url( 'https://lordicon.com/' ), esc_html_x( 'Lordicon.com', 'link text for lordicon.com', 'onnat-extra' ) )
                        ),
                        'condition'       => [
                            'icon_type' => [ 'lordicon_media', 'lordicon_external' ]
                        ],
                    ]);
                    $repeater->add_control('lordicon_media', [
                        'label'      => esc_html__( 'Upload JSON File', 'onnat-extra' ),
                        'type'       => KFCM::MEDIA,
                        'media_type' => 'application/json',
                        'default'    => [
                            'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                        ],
                        'condition'  => [
                            'icon_type' => 'lordicon_media'
                        ]
                    ]);
                    $repeater->add_control('lordicon_external', [
                        'label'       => esc_html__( 'Upload JSON File', 'onnat-extra' ),
                        'type'        => KFCM::URL,
                        'dynamic'     => [ 'active' => true, ],
                        'placeholder' => esc_html__( 'Enter your URL', 'onnat-extra' ),
                        'options'     => [ 'url' ],
                        'default'     => [
                            'url' => KFE_CONST_URL . 'libraries/elementor/assets/json/lordicon-clock-icon.json'
                        ],
                        'condition'   => [
                            'icon_type' => 'lordicon_external'
                        ]
                    ]);
                $repeater->end_controls_tab();
            $repeater->end_controls_tabs();

            $this->add_control('items', [
                'type'    => KFCM::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
						'title'     => 'Tab #1',
						'sub_title' => '',
						'source'    => 'editor',
						'editor'    => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin sit amet auctor odio. Donec finibus, sem sed facilisis eleifend, mi ligula faucibus neque, sed tristique libero ante ac dui. Phasellus fermentum velit non elit euismod molestie. Curabitur congue magna eget est dapibus eleifend. Praesent sed est vel lectus viverra porta. Nunc egestas dui eget cursus ullamcorper. Integer mollis dapibus sollicitudin. Nullam turpis erat, dignissim egestas metus elementum, ornare elementum leo. Vestibulum ullamcorper cursus accumsan. Donec a eros non dolor faucibus tincidunt. Integer eros felis, gravida ut lacus vel, porta efficitur erat. Ut in sagittis elit, eget ullamcorper orci.',
                    ],
                    [
                        'title'     => 'Tab #2',
                        'sub_title' => '',
                        'source'    => 'editor',
                        'editor'    => 'Sed sed tortor faucibus, rutrum quam scelerisque, maximus felis. Sed sagittis arcu at est semper, nec facilisis metus consectetur. Mauris sed auctor lacus. Fusce sit amet nisi risus. Duis in sagittis ligula. Quisque non nunc quam. Pellentesque sagittis leo ante, ac efficitur massa convallis in. Phasellus a sagittis purus, a scelerisque nisl. Duis scelerisque, nibh eu condimentum mattis, magna nisi lacinia ligula, ac varius lacus odio nec dui. Donec eget auctor enim, vehicula suscipit ex.',
                    ],
                    [
                        'title'     => 'Tab #3',
                        'sub_title' => '',
                        'source'    => 'editor',
                        'editor'    => 'Vestibulum euismod lacus vitae ipsum bibendum, vitae condimentum mi efficitur. Praesent molestie laoreet neque nec mattis. Maecenas in metus at nibh efficitur auctor. Suspendisse ante mauris, pretium sit amet pellentesque ornare, viverra non magna. Donec velit urna, efficitur eu ex at, interdum commodo elit. Ut lobortis, sapien sit amet pretium laoreet, tellus ex condimentum lorem, id maximus nibh massa vel justo. Curabitur bibendum, nibh vitae molestie bibendum, massa ligula varius quam, et luctus lectus leo vel ex. Proin sit amet ligula leo. Vivamus ultricies purus ut libero feugiat mollis.',
                    ],
                    [
                        'title'     => 'Tab #4',
                        'sub_title' => '',
                        'source'    => 'editor',
                        'editor'    => 'Maecenas at lacus ac dui aliquam aliquam. Nam sit amet maximus felis. Vivamus suscipit justo in ipsum fringilla hendrerit. Proin convallis felis massa, sed feugiat nunc condimentum sed. Mauris tincidunt congue erat ut iaculis. Pellentesque ac quam velit. Pellentesque leo arcu, suscipit eget volutpat vel, tincidunt a erat. Donec nec ex vitae dolor feugiat blandit. Vivamus facilisis metus et massa semper, ac ultrices dui pharetra. Proin id leo placerat, varius libero vitae, tempus est.',
                    ],
                    [
                        'title'     => 'Tab #5',
                        'sub_title' => '',
                        'source'    => 'editor',
                        'editor'    => 'Etiam lacinia lorem vitae enim tempor condimentum. Vestibulum sed fringilla metus. Morbi fringilla, libero bibendum convallis ultrices, erat tortor egestas dolor, vitae vulputate libero elit nec felis. Nulla elit nisi, rutrum at diam ac, vehicula pretium dolor. Fusce sit amet turpis diam. Quisque ullamcorper metus at nisl porttitor varius. Sed in dolor fermentum, feugiat turpis in, facilisis neque. In nec massa eu felis ultricies feugiat ac id nulla. Donec eget nulla nulla. Pellentesque tempor',
                    ],
                ]
            ]);
		$this->end_controls_section();
    }

    public function _register_settings_section() {
		$this->start_controls_section( 'section_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' )
		]);
            $this->add_control('tab_type',[
                'label'   => esc_html__( 'Tab Type', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'toggle'  => false,
                'default' => 'type-1',
                'options' => [
                    'type-1' => [
                        'title' => esc_html__('Type 1', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-1-icon'
                    ],
                    'type-2' => [
                        'title' => esc_html__('Type 2', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-2-icon'
                    ],
                    'type-3' => [
                        'title' => esc_html__('Type 3', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-3-icon'
                    ],
                ],
                #'prefix_class' => 'kfw-tab-type kfw-tab-',
            ]);

            $this->add_control('tab_settings_heading',[
                'label' => esc_html__( 'TAB SETTINGS', 'onnat-extra' ),
                'type'  => KFCM::HEADING,
            ]);
            $this->add_control('tab_settings_heading_after_hr', [
                'type' => KFCM::DIVIDER,
            ]);
            $this->add_control('active_tab', [
                'label'   => esc_html__( 'Active Tab Item Number', 'onnat-extra' ),
                'type'    => KFCM::NUMBER,
                'min'     => 1,
                'max'     => 20,
                'step'    => 1,
                'default' => 1,
            ]);
            $this->add_control('tabs_position', [
				'label'        => esc_html__( 'Position', 'onnat-extra' ),
				'type'         => KFCM::CHOOSE,
				'options'      => [
					'left'   => [
						'title' => esc_html__( 'Vertical Left', 'onnat-extra' ),
						'icon'  => 'eicon-h-align-left',
					],
					'top'    => [
						'title' => esc_html__( 'Horizontal Top', 'onnat-extra' ),
						'icon'  => 'eicon-v-align-top',
					],
					'right'  => [
						'title' => esc_html__( 'Vertical Right', 'onnat-extra' ),
						'icon'  => 'eicon-h-align-right',
					],
					'bottom' => [
						'title' => esc_html__( 'Horizontal Bottom', 'onnat-extra' ),
						'icon'  => 'eicon-v-align-bottom',
					],
                ],
                'default'      => 'top',
                'toggle'       => false,
                'prefix_class' => 'kfw-ele-tabs-view-',
            ]);
            $this->add_control('tabs_lr_alignment', [
                'label'     => esc_html__( 'Alignment', 'onnat-extra' ),
                'type'      => KFCM::CHOOSE,
                'options'   => [
                    'top'    => [
                        'title' => esc_html__('Top', 'onnat-extra'),
                        'icon'  => 'eicon-v-align-top',
                    ],
                    'center'  => [
                        'title' => esc_html__('Center', 'onnat-extra'),
                        'icon'  => 'eicon-v-align-middle',
                    ],
                    'bottom'   => [
                        'title' => esc_html__('Bottom', 'onnat-extra'),
                        'icon'  => 'eicon-v-align-bottom',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justified', 'onnat-extra'),
                        'icon'  => 'eicon-v-align-stretch',
                    ],
                ],
                'default'      => 'center',
                'toggle'       => false,
                'prefix_class' => 'kfw-ele-tabs-vertical-align-',
                'condition'    => [
                    'tabs_position' => [ 'left', 'right', ]
                ]
            ]);
            $this->add_control('tabs_tb_alignment', [
                'label'        => esc_html__( 'Alignment', 'onnat-extra' ),
                'type'         => KFCM::CHOOSE,
                'options'      => [
                    'left'    => [
                        'title' => esc_html__('Left', 'onnat-extra'),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__('Center', 'onnat-extra'),
                        'icon'  => 'eicon-h-align-center',
                    ],
                    'right'   => [
                        'title' => esc_html__('Right', 'onnat-extra'),
                        'icon'  => 'eicon-h-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justified', 'onnat-extra'),
                        'icon'  => 'eicon-h-align-stretch',
                    ],
                ],
                'default'      => 'center',
                'toggle'       => false,
                'prefix_class' => 'kfw-ele-tabs-horizontal-align-',
                'condition'    => [
                    'tabs_position' => [ 'top', 'bottom', ]
                ]
            ]);
            $this->add_control('icon_settings_heading',[
                'label' => esc_html__( 'ICON SETTINGS', 'onnat-extra' ),
                'type'  => KFCM::HEADING,
            ]);
            $this->add_control('icon_settings_heading_after_hr', [
                'type' => KFCM::DIVIDER,
            ]);
            $this->add_control('use_tabs_icon',[
                'label'        => esc_html__( 'Use Tab Icon', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes'
            ]);
			$this->add_control('icon_position', [
				'label'     => esc_html__( 'Icon Position', 'onnat-extra' ),
				'type'      => KFCM::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'onnat-extra' ),
						'icon'  => 'eicon-h-align-left',
					],
					'top'    => [
						'title' => esc_html__( 'Top', 'onnat-extra' ),
						'icon'  => 'eicon-v-align-top',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'onnat-extra' ),
						'icon'  => 'eicon-h-align-right',
					],
					'bottom' => [
						'title' => esc_html__( 'Bottom', 'onnat-extra' ),
						'icon'  => 'eicon-v-align-bottom',
					],
				],
				'default'   => 'left',
				'toggle'    => false,
				'condition' => [
                    'use_tabs_icon' => 'yes'
                ]
			]);
		$this->end_controls_section();
    }

    public function _register_tab_type_style_section() {
		$this->start_controls_section( 'section_type_style', [
			'label' => esc_html__( 'Tab Type', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_responsive_control( 'type_2_h_min_width', [
                'label'      => esc_html__('Width', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'condition' => [
                    'tab_type'                    => 'type-2',
                    'tabs_position'               => [ 'left', 'right' ],
                    'type_active_border_position' => 'h',
                ],
                'selectors'  => [
                    '{{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-left .kfw-tab-type-2 .kfw-ele-widget-tabs-header-wrapper, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-right .kfw-tab-type-2 .kfw-ele-widget-tabs-header-wrapper' => 'min-width:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->start_controls_tabs( 'type_border_customize_tabs', [
                'condition' => [
                    'tab_type' => [ 'type-1', 'type-2' ]
                ]
            ] );
                $this->start_controls_tab( 'type_border_normal_state', [
                    'label' => esc_html__( 'Normal', 'onnat-extra' ),
                ]);
                    $this->add_responsive_control( 'type_normal_border_size', [
                        'label'      => esc_html__('Border Size', 'onnat-extra' ),
                        'type'       => KFCM::SLIDER,
                        'size_units' => [ 'px' ],
                        'range'      => [
                            'px' => [
                                'min' => 0,
                                'max' => 50,
                            ],
                        ],
                        'condition' => [
                            'tab_type' => [ 'type-1', 'type-2' ]
                        ],
                        'selectors'  => [
                            '{{WRAPPER}}' => '--kfw-tab-border-width:{{SIZE}}{{UNIT}};'
                        ],
                    ]);
                    $this->add_control( 'type_normal_border_color', [
                        'label'     => esc_html__('Border Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'condition' => [
                            'tab_type' => [ 'type-1', 'type-2' ]
                        ],
                        'selectors' => [
                            '{{WRAPPER}}' => '--kfw-tab-border-color:{{VALUE}};'
                        ],
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'type_border_active_state', [
                    'label' => esc_html__( 'Active', 'onnat-extra' ),
                ]);
                    $this->add_control( 'type_active_border_position', [
                        'label'        => esc_html__( 'Border Layout', 'onnat-extra' ),
                        'type'         => KFCM::CHOOSE,
                        'options'      => [
                            'v'  => [
                                'title' => esc_html__( 'Vertical', 'onnat-extra' ),
                                'icon'  => 'eicon-ellipsis-v',
                            ],
                            'h' => [
                                'title' => esc_html__( 'Horizontal', 'onnat-extra' ),
                                'icon'  => 'eicon-ellipsis-h',
                            ],        
                        ],
                        'default'      => 'v',
                        'toggle'       => false,
                        'condition'    => [
                            'tab_type'      => 'type-2',
                            'tabs_position' => [ 'left', 'right' ],
                        ],
                        'prefix_class' => 'kfw-ele-tabs-active-border-',
                    ]);
                    $this->add_responsive_control( 'type_active_border_size', [
                        'label'      => esc_html__('Border Size', 'onnat-extra' ),
                        'type'       => KFCM::SLIDER,
                        'size_units' => [ 'px' ],
                        'range'      => [
                            'px' => [
                                'min' => 0,
                                'max' => 50,
                            ],
                        ],
                        'condition' => [
                            'tab_type' => [ 'type-1', 'type-2' ]
                        ],
                        'selectors'  => [
                            '{{WRAPPER}}' => '--kfw-tab-border-active-width:{{SIZE}}{{UNIT}};',
                        ],
                    ]);
                    $this->add_control( 'type_active_border_color', [
                        'label'     => esc_html__('Border Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'condition' => [
                            'tab_type' => [ 'type-1', 'type-2' ]
                        ],
                        'selectors' => [
                            '{{WRAPPER}}' => '--kfw-tab-border-active-color:{{VALUE}};'
                        ],
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();

            $condition = [
                'tab_type' =>'type-3'
            ];

            $this->start_controls_tabs( 'type_3_customize_tabs', [
                'condition' => $condition
            ] );
                $this->start_controls_tab( 'type_3_nav', [
                    'label' => esc_html__( 'Nav', 'onnat-extra' ),
                    'condition' => $condition
                ]);
                    $this->add_responsive_control( 'type_3_nav_margin', [
                        'label'      => esc_html__('Margin', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', 'em', '%' ],
                        'condition'  => $condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-tab-type-3 .kfw-ele-widget-tabs-type-3-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ]
                    ]);
                    $this->add_responsive_control( 'type_3_nav_padding', [
                        'label'      => esc_html__('Padding', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', 'em', '%' ],
                        'condition'  => $condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-tab-type-3 .kfw-ele-widget-tabs-type-3-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ]
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'type_3_nav_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'condition'      => $condition,
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'selector'       => '{{WRAPPER}} .kfw-tab-type-3 .kfw-ele-widget-tabs-type-3-header, {{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab.kfw-elementor-tabs-mobile-tab',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'type_3_nav_border',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kfw-tab-type-3 .kfw-ele-widget-tabs-type-3-header, {{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab.kfw-elementor-tabs-mobile-tab'
                    ]);
                    $this->add_responsive_control( 'type_3_nav_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-tab-type-3 .kfw-ele-widget-tabs-type-3-header, {{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab.kfw-elementor-tabs-mobile-tab' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'type_3_nav_box_shadow',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kfw-tab-type-3 .kfw-ele-widget-tabs-type-3-header, {{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab.kfw-elementor-tabs-mobile-tab'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'type_3_nav_menu', [
                    'label' => esc_html__( 'Menu', 'onnat-extra' ),
                    'condition' => $condition
                ]);
                    $this->add_responsive_control( 'type_3_nav_menu_margin', [
                        'label'      => esc_html__('Margin', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', 'em', '%' ],
                        'condition'  => $condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ]
                    ]);
                    $this->add_responsive_control( 'type_3_nav_menu_padding', [
                        'label'      => esc_html__('Padding', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', 'em', '%' ],
                        'condition'  => $condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ]
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'type_3_nav_menu_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'condition'      => $condition,
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'selector'       => '{{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab.kfw-elementor-active-tab',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'type_3_nav_menu_border',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab.kfw-elementor-active-tab'
                    ]);
                    $this->add_responsive_control( 'type_3_nav_menu_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'condition'  => $condition,
                        'selectors'  => [
                            '{{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab.kfw-elementor-active-tab' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'type_3_nav_menu_box_shadow',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kfw-tab-type-3 .kfw-elementor-tabs-tab.kfw-elementor-active-tab'
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

    public function _register_title_style_section() {
		$this->start_controls_section( 'section_title_style', [
			'label' => esc_html__( 'Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'title_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-left .kfw-tab-type-2 .kfw-elementor-tabs-tab .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-right .kfw-tab-type-2 .kfw-elementor-tabs-tab .kfw-elementor-tabs-tab-title',
            ]);
            $this->add_responsive_control( 'title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-tabs-tab-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-tabs-tab-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->start_controls_tabs( 'title_customize_tabs' );
                $this->start_controls_tab( 'title_normal_state', [
                    'label' => esc_html__( 'Normal', 'onnat-extra' ),
                ]);
                    $this->add_control( 'title_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-left .kfw-tab-type-2 .kfw-elementor-tabs-tab .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-right .kfw-tab-type-2 .kfw-elementor-tabs-tab .kfw-elementor-tabs-tab-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'title_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'title_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-left .kfw-tab-type-2 .kfw-elementor-tabs-tab .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-right .kfw-tab-type-2 .kfw-elementor-tabs-tab .kfw-elementor-tabs-tab-title',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'title_hover_state', [
                    'label' => esc_html__( 'Hover', 'onnat-extra' ),
                ]);
                    $this->add_control( 'title_hover_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-left .kfw-tab-type-2 .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-right .kfw-tab-type-2 .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'title_hover_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'title_hover_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-left .kfw-tab-type-2 .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-right .kfw-tab-type-2 .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-title',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'title_active_state', [
                    'label' => esc_html__( 'Active', 'onnat-extra' ),
                ]);
                    $this->add_responsive_control( 'title_active_size', [
                        'label'      => esc_html__('Size', 'onnat-extra' ),
                        'type'       => KFCM::SLIDER,
                        'size_units' => [ 'px' ],
                        'range'      => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                            ],    
                        ],
                        'selectors'  => ['{{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-left .kfw-tab-type-2 .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-right .kfw-tab-type-2 .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-title' => 'font-size: {{SIZE}}{{UNIT}};' ],
                        'condition'  => [
                            'tab_type'                    => 'type-2',
                            'tabs_position'               => [ 'left', 'right' ],
                            'type_active_border_position' => 'h',
                        ],
                    ]);
                    $this->add_control( 'title_active_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-left .kfw-tab-type-2 .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-right .kfw-tab-type-2 .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'title_active_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'title_active_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-left .kfw-tab-type-2 .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-title, {{WRAPPER}}.kfw-ele-tabs-active-border-h.kfw-ele-tabs-view-right .kfw-tab-type-2 .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-title',
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

    public function _register_sub_title_style_section() {
		$this->start_controls_section( 'section_sub_title_style', [
			'label' => esc_html__( 'Sub Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'sub_title_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab-sub-title',
            ]);
            $this->add_responsive_control( 'sub_title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-tabs-tab-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'sub_title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-elementor-tabs-tab-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->start_controls_tabs( 'sub_title_customize_tabs' );
                $this->start_controls_tab( 'sub_title_normal_state', [
                    'label' => esc_html__( 'Normal', 'onnat-extra' ),
                ]);
                    $this->add_control( 'sub_title_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-elementor-tabs-tab-sub-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'sub_title_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab-sub-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'sub_title_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab-sub-title',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'sub_title_hover_state', [
                    'label' => esc_html__( 'Hover', 'onnat-extra' ),
                ]);
                    $this->add_control( 'sub_title_hover_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-sub-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'sub_title_hover_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-sub-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'sub_title_hover_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab:hover .kfw-elementor-tabs-tab-sub-title',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'sub_title_active_state', [
                    'label' => esc_html__( 'Active', 'onnat-extra' ),
                ]);
                    $this->add_control( 'sub_title_active_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-sub-title' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'sub_title_active_txt_shadow',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-sub-title',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'sub_title_active_txt_stroke',
                        'selector' => '{{WRAPPER}} .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-elementor-tabs-tab-sub-title',
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

    public function _register_content_style_section() {
		$this->start_controls_section( 'section_content_style', [
			'label' => esc_html__( 'Content', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'content_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .elementor-repeater-item-tab-content-editor-type.kfw-elementor-tabs-content',
            ]);
            $this->add_responsive_control( 'content_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-tabs-content-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'content_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-tabs-content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'content_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'selectors' => ['{{WRAPPER}} .elementor-repeater-item-tab-content-editor-type.kfw-elementor-tabs-content' => 'color: {{VALUE}};' ],
            ]);
            $this->add_group_control( KFGCTS::get_type(), [
                'name'     => 'content_txt_shadow',
                'selector' => '{{WRAPPER}} .elementor-repeater-item-tab-content-editor-type.kfw-elementor-tabs-content',
            ]);
            $this->add_group_control( KFGCTST::get_type(), [
                'name'     => 'content_txt_stroke',
                'selector' => '{{WRAPPER}} .elementor-repeater-item-tab-content-editor-type.kfw-elementor-tabs-content',
            ]);
		$this->end_controls_section();
    }

    public function _register_content_wrap_style_section() {
		$this->start_controls_section( 'section_content_wrap_style', [
			'label' => esc_html__( 'Content Wrap', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_responsive_control( 'content_wrap_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-tabs-content-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'content_wrap_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-repeater-item-tab-content-editor-type.kfw-elementor-tabs-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'           => 'content_wrap_bg',
                'types'          => ['classic', 'gradient'],
                'exclude'        => [ 'image'],
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color'      => [ 'default' => '' ],
                ],
                'selector'       => '{{WRAPPER}} .elementor-repeater-item-tab-content-editor-type.kfw-elementor-tabs-content',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'content_wrap_border',
                'selector'  => '{{WRAPPER}}'
            ]);
            $this->add_responsive_control( 'content_wrap_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-repeater-item-tab-content-editor-type.kfw-elementor-tabs-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'content_wrap_box_shadow',
                'selector'  => '{{WRAPPER}} .elementor-repeater-item-tab-content-editor-type.kfw-elementor-tabs-content'
            ]);
		$this->end_controls_section();
    }

    public function _register_icon_style_section() {
		$this->start_controls_section( 'section_icon_style', [
			'label' => esc_html__( 'Icon', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_responsive_control( 'icon_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-tabs-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'icon_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-tabs-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);

            /**
             * Style: Icon Type
             */
                $this->add_control('icon_type_style_before_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_control('icon_type_style_heading',[
					'label' => esc_html__( 'Icon Type Style', 'onnat-extra' ),
					'type'  => KFCM::HEADING,
				]);
				$this->add_control('icon_type_style_after_hr', [
					'type' => KFCM::DIVIDER,
				]);
                $this->add_responsive_control( 'icon_type_size', [
                    'label'      => esc_html__('Size', 'onnat-extra' ),
                    'type'       => KFCM::SLIDER,
                    'size_units' => [ 'px' ],
                    'range'      => [
                        'px' => [
                            'min' => 0,
                            'max' => 999,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kfw-ele-widget-tabs-icon-wrap.kfw-ele-widget-tabs-icon-icon-type .kfw-elementor-icon-wrap svg, {{WRAPPER}} .kfw-ele-widget-tabs-icon-wrap.kfw-ele-widget-tabs-icon-icon-type .kfw-elementor-icon-wrap i' => 'font-size: {{SIZE}}{{UNIT}};'
                    ],
                ]);
				$this->add_control( 'icon_color_settings', [
                    'label'        => esc_html__('Colors', 'onnat-extra'),
					'type'         => KFCM::POPOVER_TOGGLE,
					'return_value' => 'yes',
				]);
                $this->start_popover();
                    $this->add_control( 'icon_type_color', [
                        'label'     => esc_html__('Normal Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => [
                        '{{WRAPPER}} .kfw-ele-widget-tabs-icon-wrap.kfw-ele-widget-tabs-icon-icon-type .kfw-elementor-icon-wrap' => 'color:{{VALUE}};fill:{{VALUE}};',
                        ],
                    ]);
                    $this->add_control( 'icon_type_hover_color', [
                        'label'     => esc_html__('Hover Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .kfw-elementor-tabs-tab:hover .kfw-ele-widget-tabs-icon-wrap.kfw-ele-widget-tabs-icon-icon-type .kfw-elementor-icon-wrap' => 'color:{{VALUE}};fill:{{VALUE}};',
                        ],
                    ]);
                    $this->add_control( 'icon_type_active_color', [
                        'label'     => esc_html__('Active Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .kfw-elementor-tabs-tab.kfw-elementor-active-tab .kfw-ele-widget-tabs-icon-wrap.kfw-ele-widget-tabs-icon-icon-type .kfw-elementor-icon-wrap' => 'color:{{VALUE}};fill:{{VALUE}};',
                        ],
                    ]);
                $this->end_popover();

            /**
             * Style: Image Type
             */
                $this->add_control('img_type_style_before_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_control('img_type_style_heading',[
                    'label' => esc_html__( 'Image Type Style', 'onnat-extra' ),
                    'type'  => KFCM::HEADING,
                ]);
                $this->add_control('img_type_style_after_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_responsive_control( 'img_type_size', [
                    'label'      => esc_html__('Size', 'onnat-extra' ),
                    'type'       => KFCM::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min' => 5,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kfw-ele-widget-tabs-icon-wrap.kfw-ele-widget-tabs-icon-image-type img' => 'max-width:{{SIZE}}px;'
                    ],
                ]);

            /**
             * Style: Lordicon Type
             */
                $this->add_control('lordicon_type_style_before_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_control('lordicon_type_style_heading',[
                    'label' => esc_html__( 'LordIcon Type Style', 'onnat-extra' ),
                    'type'  => KFCM::HEADING,
                ]);
                $this->add_control('lordicon_type_style_after_hr', [
                    'type' => KFCM::DIVIDER,
                ]);
                $this->add_responsive_control( 'lordicon_type_size', [
                    'label'      => esc_html__('Size', 'onnat-extra' ),
                    'type'       => KFCM::SLIDER,
                    'size_units' => [ 'px' ],
                    'range'      => [
                        'px' => [
                            'min' => 1,
                            'max' => 300,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .kfw-ele-widget-tabs-icon-wrap.kfw-ele-widget-tabs-icon-lordicon-type .kfw-elementor-icon-wrap, {{WRAPPER}} .kfw-ele-widget-tabs-icon-wrap.kfw-ele-widget-tabs-icon-lordicon-type .kfw-elementor-lordicon' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};'
                    ]
                ]);
				$this->add_control( 'lordicon_color_settings', [
                    'label'        => esc_html__('Colors', 'onnat-extra'),
					'type'         => KFCM::POPOVER_TOGGLE,
					'return_value' => 'yes',
				]);
                $this->start_popover();
                    $this->add_control('lordicon_primary_color',[
                        'label'     => __( 'Primary Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'default'   => '#121331',
                    ]);
                    $this->add_control('lordicon_secondary_color',[
                        'label'   => __( 'Secondary Color', 'onnat-extra' ),
                        'type'    => KFCM::COLOR,
                        'default' => '#121331',
                    ]);
                    $this->add_control('lordicon_tertiary_color',[
                        'label'   => __( 'Tertiary Color', 'onnat-extra' ),
                        'type'    => KFCM::COLOR,
                        'default' => '#0816A8',
                    ]);
                $this->end_popover();
		$this->end_controls_section();
    }

	public function _render_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

		if( !empty( $icon ) ) {
            echo '<div class="kfw-ele-widget-tabs-icon-wrap kfw-ele-widget-tabs-icon-icon-type">';
                echo '<span class="kfw-elementor-icon-wrap">';
                    KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
                echo '</span>';
            echo '</div>';
		}
	}

	public function _render_img( $settings = [] ) {
		if( !empty( $settings['url'] ) ) {
			$image_src = $settings['url'];

			$image_title = $this->_get_image_title( $settings );
			$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

			$image_alt = $this->_get_image_alt( $settings );
			$image_alt = empty( $image_alt ) ? $image_title : $image_title;

            echo '<div class="kfw-ele-widget-tabs-icon-wrap kfw-ele-widget-tabs-icon-image-type">';
                echo '<span class="kfw-elementor-icon-wrap">';
                    echo '<img alt="'. esc_attr( $image_alt ) .'" title="'. esc_attr( $image_title ) .'" src="'. esc_url( $image_src ) .'"/>';
                echo '</span>';
            echo '</div>';
        }
    }

	public function _get_image_title( $attachment ) {
		if ( empty( $attachment['id'] ) ) {
			return '';
		}

		return get_the_title( $attachment['id'] );
	}

	public function _get_image_alt( $instance ) {
		if ( empty( $instance['id'] ) ) {
			// For `Insert From URL` images.
			return isset( $instance['alt'] ) ? trim( strip_tags( $instance['alt'] ) ) : '';
		}

		$attachment_id = $instance['id'];
		if ( ! $attachment_id ) {
			return '';
		}

		$attachment = get_post( $attachment_id );
		if ( ! $attachment ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		if ( ! $alt ) {
			$alt = $attachment->post_excerpt;
			if ( ! $alt ) {
				$alt = $attachment->post_title;
			}
		}
		return trim( strip_tags( $alt ) );
	}

	/**
	 * Get template content
	 */
	public function _generate_template_content( $template_id ) {
		return KFEl::instance()->frontend->get_builder_content_for_display( $template_id );
	}

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-tabs");
		include $render;
    }
}