<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Icons_Manager as KFIM;
use \Elementor\Group_Control_Image_Size as KFGCIS;
use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;

class KFW_Testimonial_Carousel extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-testimonial-carousel';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Testimonial Carousel', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_core_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-testimonial-carousel kfw-testimonial-carousel';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'testimonial', 'review', 'carousel' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/testimonial-carousel';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

		wp_register_script( 'kfw-testimonial-carousel',
			KFE_CONST_URL . 'libraries/elementor/assets/js/testimonial-carousel' . KFE_CONST_DEBUG_SUFFIX . '.js',
			[ 'jquery', 'elementor-frontend' ],
			KFE_CONST_VERSION,
			true
		);

		wp_register_style( 'kfw-testimonial',
			KFE_CONST_URL . 'libraries/elementor/assets/css/testimonial' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);

		wp_register_style( 'kfw-testimonial-carousel',
			KFE_CONST_URL . 'libraries/elementor/assets/css/testimonial-carousel' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'swiper', 'kfw-testimonial', 'kfw-testimonial-carousel' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'kfw-testimonial-carousel' ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_items_section();
		$this->_register_settings_section();

		$this->_register_nav_style_section();
		$this->_register_dot_style_section();

        $this->_register_type_style_section();
		$this->_register_quote_default_icon_style_section();
		$this->_register_quote_icon_style_section();
		$this->_register_quote_image_style_section();
		$this->_register_avatar_style_section();
		$this->_register_name_style_section();
		$this->_register_role_style_section();
		$this->_register_content_style_section();
		$this->_register_rating_style_section();

	}

    public function _register_items_section() {
		$this->start_controls_section( 'section_items', [
			'label' => esc_html__( 'Testimonial Items', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
            $this->add_control( 'items', [
                'type'        => KFCM::REPEATER,
                'fields'      => [
                    [
                        'name'        => 'name',
                        'label'       => esc_html__( 'Name', 'onnat-extra' ),
                        'label_block' => true,
                        'type'        => KFCM::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Name' , 'onnat-extra' ),
                    ],
                    [
                        'name'        => 'role',
                        'label'       => esc_html__( 'Role', 'onnat-extra' ),
                        'label_block' => true,
                        'type'        => KFCM::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Role' , 'onnat-extra' ),
                    ],
                    [
						'name'       => 'rating',
						'label'      => esc_html__( 'Rating', 'onnat-extra' ),
						'type'       => KFCM::SLIDER,
						'dynamic'    => [ 'active' => true ],
						'size_units' => [ 'px' ],
						'default'    => [
                            'unit' => 'px',
                            'size' => 4,
                        ],
						'range'      => [
							'px' => [
                                'min'  => 0,
                                'max'  => 5,
                                'step' => .5,
							],
						],
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-testimonial-rating-inner' =>'width:calc(20 * {{SIZE}}%)',

                        ],
                    ],
                    [
                        'name'        => 'avatar',
                        'label'       => esc_html__( 'Avatar', 'onnat-extra' ),
                        'type'        => KFCM::MEDIA,
                        'media_types' => [ 'image' ],
                        'default'     => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar.png'
                        ],
                        'dynamic' => [ 'active' => true ],
                    ],
                    [
                        'name'    => 'content',
                        'label'   => esc_html__( 'Content', 'onnat-extra' ),
                        'type'    => KFCM::TEXTAREA,
                        'dynamic' => [ 'active' => true ],
                        'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ],
                ],
                'title_field' => '{{{ name }}}',
                'default'     => [
                    [
                        'name'    => 'Robert',
                        'role'    => 'Manager',
                        'rating'  => '4',
                        'avatar'  => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar.png'
                        ],
                        'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ],
                    [
                        'name'    => 'James',
                        'role'    => 'Administrator',
                        'rating'  => '4.5',
                        'avatar'  => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar.png'
                        ],
                        'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ],
                    [
                        'name'    => 'Christopher',
                        'role'    => 'CEO',
                        'rating'  => '4',
                        'avatar'  => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar.png'
                        ],
                        'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ],
                    [
                        'name'    => 'Michael',
                        'role'    => 'Engineer',
                        'rating'  => '5',
                        'avatar'  => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar.png'
                        ],
                        'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ]
                ],
            ]);
            $this->add_control('hr_items', [
                'type' => KFCM::DIVIDER,
            ]);
            $this->add_group_control( KFGCIS::get_type(), [
                'name'    => 'image_size',
                'default' => 'full',
            ]);
            $this->add_control('layout', [
                'label'   => esc_html__( 'Layout', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'options' => [
                    'kfw-testimonial-style-1' => [
                        'title' => esc_html__('Grid Style 1', 'onnat-extra' ),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-1-icon'
                    ],
                    'kfw-testimonial-style-2' => [
                        'title' => esc_html__('Grid Style 2', 'onnat-extra' ),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-2-icon'
                    ],
                    'kfw-testimonial-style-3' => [
                        'title' => esc_html__('Grid Style 3', 'onnat-extra' ),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-3-icon'
                    ],
                    'kfw-testimonial-style-4' => [
                        'title' => esc_html__('Grid Style 4', 'onnat-extra' ),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-4-icon'
                    ],
                ],
                'default' => 'kfw-testimonial-style-4',
                'toggle'  => false
            ]);
            $this->add_control('quote_icon_type',[
                'label'   => esc_html__( 'Quote Icon Type', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'options' => [
                    'blank' => [
                        'title' => esc_html__('Blank', 'onnat-extra'),
                        'icon'  => '',
                    ],
                    'default' => [
                        'title' => esc_html__('Default', 'onnat-extra'),
                        'icon'  => 'eicon-blockquote',
                    ],
                    'icon'  => [
                        'title' => esc_html__('Icon', 'onnat-extra'),
                        'icon'  => 'eicon-plus-circle-o',
                    ],
                    'image' => [
                        'title' => esc_html__('Image', 'onnat-extra'),
                        'icon'  => 'eicon-image',
                    ],
                ],
                'default' => 'default',
                'toggle'  => false,
            ]);
            $this->add_control( 'quote_icon_icon', [
                'label'       => esc_html__( 'Quote Icon', 'onnat-extra' ),
                'label_block' => false,
                'type'        => KFCM::ICONS,
                'skin'        => 'inline',
                'default'   => [
					'value'   => 'fas fa-quote-left',
					'library' => 'fa-solid',
				],
                'condition'   => [
                    'quote_icon_type' => 'icon'
                ],
            ]);
            $this->add_control( 'quote_icon_image', [
                'label'     => esc_html__( 'Quote Image', 'onnat-extra' ),
                'type'      => KFCM::MEDIA,
                'dynamic'   => [ 'active' => true ],
                'condition' => [
                    'quote_icon_type' => 'image'
                ],
            ]);
            $this->add_control( 'quote_badge_image', [
                'label'     => esc_html__( 'Badge Image', 'onnat-extra' ),
                'type'      => KFCM::MEDIA,
                'dynamic'   => [ 'active' => true ],
                'condition' => [
                    'layout' => 'kfw-testimonial-style-4'
                ],
            ]);
            $this->add_control('hr_item_settings', [
                'type' => KFCM::DIVIDER,
            ]);
			$this->add_control('item_heading',[
				'label' => esc_html__( 'ITEM SETTINGS', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
			]);
			$this->add_control('use_rating',[
                'label'        => esc_html__( 'Show Rating?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes',
			]);
			$this->add_control('use_role',[
                'label'        => esc_html__( 'Show Role?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes',
			]);
			$this->add_control('use_avatar',[
                'label'        => esc_html__( 'Show Avatar?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes',
			]);
		$this->end_controls_section();
    }

    public function _register_settings_section() {
		$this->start_controls_section( 'section_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
            $this->add_responsive_control('cols', [
                'label'              => esc_html__( 'Columns', 'onnat-extra' ),
                'type'               => KFCM::CHOOSE,
                'toggle'             => false,
                'frontend_available' => true,
                'desktop_default'    => 4,
                'tablet_default'     => 3,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => [ 'title' => esc_html__('1 Column', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-icon' ],
                    '2' => [ 'title' => esc_html__('2 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-2-icon' ],
                    '3' => [ 'title' => esc_html__('3 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-3-icon' ],
                    '4' => [ 'title' => esc_html__('4 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-4-icon' ],
                ],
            ]);
            $this->add_responsive_control('col_gap',[
				'label'              => esc_html__( 'Item Gap', 'onnat-extra' ),
				'type'               => KFCM::SLIDER,
				'frontend_available' => true,
				'range'              => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'default'   => [
                    'size' => 20,
                ],
            ]);
			$this->add_responsive_control('slide_to_scroll',[
                'label'              => esc_html__( 'Slides To Scroll', 'onnat-extra' ),
                'type'               => KFCM::NUMBER,
                'min'                => 1,
                'max'                => 20,
                'step'               => 1,
                'default'            => 1,
                'frontend_available' => true,
			]);
			$this->add_control( 'loop', [
                'label'              => esc_html__( 'Enable Loop?', 'onnat-extra' ),
                'type'               => KFCM::SWITCHER,
                'return_value'       => 'yes',
                'default'            => 'yes',
                'frontend_available' => true,
            ]);
			$this->add_control( 'hr_1', [
				'type' => KFCM::DIVIDER,
			]);
            $this->add_control('autoplay_settings_heading',[
                'label' => esc_html__( 'Autoplay Settings', 'onnat-extra' ),
                'type'  => KFCM::HEADING,
            ]);
            $this->add_control('autoplay', [
                'label'              => esc_html__( 'Enable Autoplay?', 'onnat-extra' ),
                'type'               => KFCM::SWITCHER,
                'return_value'       => 'yes',
                'frontend_available' => true,
            ]);
            $this->add_control('autoplay_speed',[
                'label'              => esc_html__('Autoplay Speed (ms)', 'onnat-extra' ),
                'type'               => KFCM::SLIDER,
                'frontend_available' => true,
                'size_units'         => [],
                'range'              => [
                    'min' => 1000,
                    'max'  => 15000,
                    'step' => 100
                ],
                'default'    => [
                    'unit' => '',
                    'size' => 1000
                ],
                'condition'  => [
                    'autoplay' => 'yes'
                ],
            ]);
            $this->add_control( 'pause', [
                'label'              => esc_html__( 'Pause on Hover?', 'onnat-extra' ),
                'type'               => KFCM::SWITCHER,
                'return_value'       => 'yes',
                'frontend_available' => true,
                'default'            => 'yes',
                'condition'          => [
                    'autoplay' => 'yes'
                ],
            ]);
            $this->add_control( 'pause_on_interaction', [
                'label'              => esc_html__( 'Pause on Interaction?', 'onnat-extra' ),
                'type'               => KFCM::SWITCHER,
                'return_value'       => 'yes',
                'default'            => 'yes',
                'frontend_available' => true,
                'condition'          => [
                    'autoplay' => 'yes'
                ],
            ]);
			$this->add_control( 'hr_2', [
				'type' => KFCM::DIVIDER,
			]);
            $this->add_control( 'nav_settings_heading',[
                'label' => esc_html__( 'Navigation Settings', 'onnat-extra' ),
                'type'  => KFCM::HEADING,
            ]);
            $this->add_control( 'arrows', [
                'label'              => esc_html__( 'Enable Arrows?', 'onnat-extra' ),
                'type'               => KFCM::SWITCHER,
                'return_value'       => 'yes',
                'frontend_available' => true,
            ]);
            $this->add_control( 'mobile_arrows', [
                'label'              => esc_html__( 'Remove Arrows on Mobile?', 'onnat-extra' ),
                'type'               => KFCM::SWITCHER,
                'return_value'       => 'yes',
                'frontend_available' => true,
                'condition'          => [
                    'arrows' => 'yes'
                ],
            ]);
            $this->add_control( 'arrow_position', [
                'label'     => esc_html__( 'Position', 'onnat-extra' ),
                'type'      => KFCM::CHOOSE,
                'options'   => [
                    'default'       => [
                        'title' => esc_html__( 'Default', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left'
                    ],
                    'top-left'      => [
                        'title' => esc_html__( 'Top Left', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-45'
                    ],
                    'top-center'    => [
                        'title' => esc_html__( 'Top Center', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-90'
                    ],
                    'top-right'     => [
                        'title' => esc_html__( 'Top Right', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-135'
                    ],
                    'bottom-left'   => [
                        'title' => esc_html__( 'Bottom Left', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-315'
                    ],
                    'bottom-center' => [
                        'title' => esc_html__( 'Bottom Center', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-right kfw-ctrl-rotate-90'
                    ],
                    'bottom-right'  => [
                        'title' => esc_html__( 'Bottom Right', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-right kfw-ctrl-rotate-45'
                    ],
                    'custom'        => [
                        'title' => esc_html__( 'Custom', 'onnat-extra' ),
                        'icon'  => 'eicon-map-pin'
                    ],
                ],
                'default'   => 'bottom-center',
                'condition' => [
                    'arrows' => 'yes'
                ],
                'toggle'             => false,
                'frontend_available' => true,
            ]);
            $this->add_control( 'custom_nav_d_color', [
                'label'     => esc_html__( 'Nav Disabled Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => [
                    'arrows'         => 'yes',
                    'arrow_position' => 'custom'
                ],
                'selectors' => [
                    '.kfw-js-swiper-{{ID}}-nav-next, .kfw-js-swiper-{{ID}}-nav-prev'                                                   => 'cursor:pointer !important;',
                    '.kfw-js-swiper-{{ID}}-nav-next.swiper-button-disabled, .kfw-js-swiper-{{ID}}-nav-prev.swiper-button-disabled'     => 'cursor: text !important;',
                    '.kfw-js-swiper-{{ID}}-nav-next.swiper-button-disabled *, .kfw-js-swiper-{{ID}}-nav-prev.swiper-button-disabled *' => 'color:{{VALUE}}; opacity:0.5;',
                ]
            ]);
            $this->add_control( 'left_arrow', [
                'label'     => esc_html__( 'Next Arrow', 'onnat-extra' ),
                'type'      => KFCM::ICONS,
                'default'   => [
                    'value'   => 'fas fa-arrow-right',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'arrows'          => 'yes',
                    'arrow_position!' => 'custom',
                ],
            ]);
            $this->add_control( 'right_arrow', [
                'label'     => esc_html__( 'Prev Arrow', 'onnat-extra' ),
                'type'      => KFCM::ICONS,
                'default'   => [
                    'value'   => 'fas fa-arrow-left',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'arrows'          => 'yes',
                    'arrow_position!' => 'custom',
                ],
            ]);
			$this->add_control( 'hr_3', [
				'type' => KFCM::DIVIDER,
			]);
			$this->add_control( 'dots', [
                'label'              => esc_html__( 'Show Dots?', 'onnat-extra' ),
                'type'               => KFCM::SWITCHER,
                'return_value'       => 'yes',
                'default'            => 'yes',
                'frontend_available' => true,
			]);
		$this->end_controls_section();
    }

	public function _register_nav_style_section() {
		$this->start_controls_section( 'section_nav_style',[
			'label'     => esc_html__( 'Navigation', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [
				'arrows'          => 'yes',
				'arrow_position!' => 'custom'
			],
		]);
			$this->start_controls_tabs( 'tabs_nav_style', [
				'condition' => [
					'arrows'          => 'yes',
					'arrow_position!' => 'custom'
				],
			]);
				$this->start_controls_tab( 'tabs_nav_normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'nav_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_bg_color', [
						'label'     => esc_html__('Background Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-bg-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'hr_nav_style_1', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'     => 'nav_border',
						'selector' => '{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap div'
					]);
					$this->add_control( 'hr_nav_style_3', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'nav_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'default'    => [
							'top'      => '',
							'right'    => '',
							'bottom'   => '',
							'left'     => '',
							'unit'     => 'px',
							'isLinked' => false
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						]
					]);
					$this->add_control( 'hr_nav_style_4', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'nav_arrow_size',[
						'label'      => esc_html__('Size', 'onnat-extra' ),
						'type'       => KFCM::SLIDER,
						'size_units' => [ 'px' ],
						'range'      => [
							'px' => [
								'min' => 10,
								'max' => 200,
							],
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap div' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',

							'{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap.kfw-testimonial-carousel-nav-pos-top-left,
                            {{WRAPPER}} .kfw-testimonial-carousel-nav-wrap.kfw-testimonial-carousel-nav-pos-top-center,
                            {{WRAPPER}} .kfw-testimonial-carousel-nav-wrap.kfw-testimonial-carousel-nav-pos-top-right'          => 'top:calc(({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}/2)*-1);',

							'{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap.kfw-testimonial-carousel-nav-pos-bottom-left,
                            {{WRAPPER}} .kfw-testimonial-carousel-nav-wrap.kfw-testimonial-carousel-nav-pos-bottom-center,
                            {{WRAPPER}} .kfw-testimonial-carousel-nav-wrap.kfw-testimonial-carousel-nav-pos-bottom-right' => 'bottom:calc(({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}/2)*-1);',
						],
					]);
					$this->add_responsive_control( 'nav_arrow_icon_size', [
						'label'      => esc_html__('Icon Size', 'onnat-extra' ),
						'type'       => KFCM::SLIDER,
						'size_units' => [ 'px' ],
						'range'      => [
							'px' => [
								'min' => 0,
								'max' => 200,
							],
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap .kfw-elementor-icon-wrap' => 'font-size: {{SIZE}}{{UNIT}};'
						],
					]);
					$this->add_control( 'hr_nav_style_5', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'nav_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap div'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_nav_hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'nav_h_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-hover-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_h_bg_color', [
						'label'     => esc_html__('Background Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-bg-hover-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_h_border_color', [
						'label'     => esc_html__('Border Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap div:hover' => 'border-color:{{VALUE}};',
						],
						'condition' => [
							'nav_border_border!' => '',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'nav_h_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap div:hover'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_nav_disabled', [
					'label' => esc_html__( 'Disabled', 'onnat-extra' ),
				]);
					$this->add_control( 'nav_d_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-disabled-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_d_bg_color', [
						'label'     => esc_html__('Background Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-disabled-bg-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_d_border_color', [
						'label'     => esc_html__('Border Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap .swiper-button-disabled' => 'border-color:{{VALUE}};',
						],
						'condition' => [
							'nav_border_border!' => '',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'nav_d_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-testimonial-carousel-nav-wrap .swiper-button-disabled'
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function _register_dot_style_section() {
		$this->start_controls_section( 'section_dot_style',[
			'label'     => esc_html__( 'Dot', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [
				'dots' => 'yes'
			],
		]);
			$this->start_controls_tabs( 'tabs_dot_style', [
				'condition' => [
					'dots' => 'yes'
				],
			]);
				$this->start_controls_tab( 'tabs_dot_normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'dot_color_settings', [
						'label'        => esc_html__('Colors', 'onnat-extra'),
						'type'         => KFCM::POPOVER_TOGGLE,
						'return_value' => 'yes',
					]);
					$this->start_popover();
						$this->add_control( 'dot_color', [
							'label'     => esc_html__('Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'selectors' => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'background:{{VALUE}};',
							],
						]);
						$this->add_control( 'active_dot_color', [
							'label'     => esc_html__('Active Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'selectors' => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active, {{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active:hover' => 'background:{{VALUE}};',
							],
						]);
					$this->end_popover();
					$this->add_control( 'hr_dot_style_1', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'dot_padding',[
						'label'      => esc_html__('Padding', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'default'    => [
							'top'      => '',
							'right'    => '',
							'bottom'   => '',
							'left'     => '',
							'unit'     => 'px',
							'isLinked' => false
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
					$this->add_responsive_control( 'dot_margin',[
						'label'      => esc_html__('Margin', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
					$this->add_control( 'hr_dot_style_2', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_control( 'dot_size_settings_heading',[
						'label' => esc_html__( 'Size Settings', 'onnat-extra' ),
						'type'  => KFCM::HEADING,
					]);
						$this->add_responsive_control( 'dot_width',[
							'label'      => esc_html__('Width', 'onnat-extra' ),
							'type'       => KFCM::SLIDER,
							'size_units' => [ 'px' ],
							'range'      => [
								'px' => [
									'min' => 10,
									'max' => 100,
								],
							],
							'selectors'  => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'width:{{SIZE}}{{UNIT}};',
							],
						]);
						$this->add_responsive_control( 'dot_height',[
							'label'      => esc_html__('Height', 'onnat-extra' ),
							'type'       => KFCM::SLIDER,
							'size_units' => [ 'px' ],
							'range'      => [
								'px' => [
									'min' => 10,
									'max' => 100,
								],
							],
							'selectors'  => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'height:{{SIZE}}{{UNIT}};',
							],
						]);
						$this->add_responsive_control( 'dot_border_radius', [
							'label'      => esc_html__('Border Radius', 'onnat-extra' ),
							'type'       => KFCM::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'default'    => [
								'top'      => '',
								'right'    => '',
								'bottom'   => '',
								'left'     => '',
								'unit'     => 'px',
								'isLinked' => false
							],
							'selectors'  => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
							]
						]);
						$this->add_control( 'hr_dot_style_3', [
							'type' => KFCM::DIVIDER,
						]);
						$this->add_responsive_control( 'dot_space_between',[
							'label'      => esc_html__('Space Between', 'onnat-extra' ),
							'type'       => KFCM::SLIDER,
							'selectors'  => [
								'{{WRAPPER}}' => '--kfw-swiper-dots-space-between: {{SIZE}}{{UNIT}};',
							],
						]);
					$this->add_control( 'hr_dot_style_4', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'dot_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_dot_hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'h_dot_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet:hover' => 'background:{{VALUE}};',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'dot_h_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet:hover'
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

    public function _register_type_style_section() {
        $this->start_controls_section( 'section_quote_wrap_style', [
            'label' => esc_html__( 'Testimonial Type', 'onnat-extra' ),
            'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'     => 'wrap_bg',
                'types'    => ['classic', 'gradient'],
                'exclude'  => [ 'image'],
                'selector' => '{{WRAPPER}} .kfw-testimonial-item',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'wrap_border',
                'selector'  => '{{WRAPPER}} .kfw-testimonial-item'
            ]);
            $this->add_responsive_control( 'wrap_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'wrap_box_shadow',
                'selector'  => '{{WRAPPER}} .kfw-testimonial-item'
            ]);
            $this->add_responsive_control( 'wrap_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'wrap_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control('type3_hr', [
				'type'      => KFCM::DIVIDER,
				'condition' => [
                    'layout' => 'kfw-testimonial-style-3'
                ],
            ]);
			$this->add_control('type3_heading',[
				'label'     => esc_html__( 'TYPE 3 SETTINGS', 'onnat-extra' ),
				'type'      => KFCM::HEADING,
				'condition' => [
                    'layout' => 'kfw-testimonial-style-3'
                ],
			]);
            $this->add_responsive_control( 'type3_margin', [
                'label'      => esc_html__('Header Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px' ],
                'default'    => [
					'top'      => '20',
					'right'    => '0',
					'bottom'   => '-175',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
                ],
                'condition'  => [
                    'layout' => 'kfw-testimonial-style-3'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-style-3 .kfw-testimonial-header-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control('swiper_hr', [
				'type' => KFCM::DIVIDER,
            ]);
			$this->add_control('swiper_heading',[
				'label' => esc_html__( 'SWIPPER SETTINGS', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
			]);
			$this->add_responsive_control( 'swiper_padding', [
				'label'              => esc_html__('Padding', 'onnat-extra' ),
				'type'               => KFCM::DIMENSIONS,
				'size_units'         => [ 'px', 'em', '%' ],
				'allowed_dimensions' => 'vertical',
				'placeholder'        => [
					'top'    => '',
					'right'  => 'auto',
					'bottom' => '',
					'left'   => 'auto',
				],
				'selectors'          => [
                    '{{WRAPPER}} .kfw-ele-widget-testimonial-carousel-main .kfw-swiper' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
    }

    public function _register_quote_default_icon_style_section() {
        $condition = [
            'quote_icon_type' => 'default'
        ];
        $this->start_controls_section( 'section_quote_default_icon_style', [
            'label'     => esc_html__( 'Quote Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
		]);
            $this->add_control( 'quote_d_icon_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $condition,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-quote-default-type span' => 'color:{{VALUE}};' ],
            ]);
            $this->add_responsive_control( 'quote_d_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-quote-default-type span' => 'font-size: {{SIZE}}{{UNIT}};'
                ],
            ]);
            $this->add_responsive_control('quote_d_icon_v_offset',[
				'label'     => esc_html__( 'Vertical Offset', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'range'     => [
					'px' => [
                        'min'  => -999,
                        'max'  => 999,
                        'step' => 5,
					],
				],
				'condition' => $condition,
				'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-quote-wrap.kfw-testimonial-quote-default-type' => 'top:{{SIZE}}{{UNIT}};'
                ],
                'condition'      => $condition,
            ]);
			$this->add_responsive_control('quote_d_icon_h_offset',[
				'label'     => esc_html__( 'Horizontal Offset', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'condition' => $condition,
				'range'     => [
					'px' => [
                        'min'  => -999,
                        'max'  => 999,
                        'step' => 5,
					],
				],
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-quote-wrap.kfw-testimonial-quote-default-type' => 'left:{{SIZE}}{{UNIT}};'
                ],
            ]);
			$this->add_responsive_control( 'quote_d_icon_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-quote-default-type' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'quote_d_icon_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-quote-default-type' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
		$this->end_controls_section();
    }

    public function _register_quote_icon_style_section() {
        $condition = [
            'quote_icon_type'         => 'icon',
            'quote_icon_icon[value]!' => '',
        ];
        $this->start_controls_section( 'section_quote_icon_style', [
            'label'     => esc_html__( 'Quote Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
		]);
            $this->add_control( 'quote_icon_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $condition,
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-quote-icon-type .kfw-elementor-icon-wrap'     => 'color:{{VALUE}};',
                    '{{WRAPPER}} .kfw-testimonial-quote-icon-type .kfw-elementor-icon-wrap svg' => 'fill:{{VALUE}};'
                ],
            ]);
            $this->add_responsive_control( 'quote_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-quote-icon-type i,{{WRAPPER}} .kfw-testimonial-quote-icon-type svg' => 'font-size: {{SIZE}}{{UNIT}};'
                ],
            ]);
            $this->add_responsive_control('quote_icon_v_offset',[
				'label'     => esc_html__( 'Vertical Offset', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'range'     => [
					'px' => [
                        'min'  => -999,
                        'max'  => 999,
                        'step' => 5,
					],
				],
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-quote-wrap.kfw-testimonial-quote-icon-type' => 'top:{{SIZE}}{{UNIT}};'
                ],
                'condition' => $condition,
            ]);
			$this->add_responsive_control('quote_icon_h_offset',[
				'label'     => esc_html__( 'Horizontal Offset', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'range'     => [
					'px' => [
                        'min'  => -999,
                        'max'  => 999,
                        'step' => 5,
					],
				],
				'condition' => $condition,
				'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-quote-wrap.kfw-testimonial-quote-icon-type' => 'left:{{SIZE}}{{UNIT}};'
                ],
            ]);
			$this->add_responsive_control( 'quote_icon_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-quote-wrap.kfw-testimonial-quote-icon-type' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'quote_icon_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-quote-wrap.kfw-testimonial-quote-icon-type' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
		$this->end_controls_section();
    }

    public function _register_quote_image_style_section() {
        $condition = [
			'quote_icon_type'        => 'image',
			'quote_icon_image[url]!' => ''
		];

        $this->start_controls_section( 'section_quote_img_style', [
            'label'     => esc_html__( 'Quote Image', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
		]);
            $this->add_responsive_control( 'quote_img_size', [
                'label'      => esc_html__('Image Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-quote-image-type img' => 'max-width: {{SIZE}}{{UNIT}};'
                ],
            ]);
            $this->add_responsive_control('quote_img_v_offset',[
                'label'     => esc_html__( 'Vertical Offset', 'onnat-extra' ),
                'type'      => KFCM::SLIDER,
                'range'     => [
					'px' => [
                        'min'  => -999,
                        'max'  => 999,
                        'step' => 5,
					],
                ],
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-quote-wrap.kfw-testimonial-quote-image-type' => 'top:{{SIZE}}{{UNIT}};'
                ],
                'condition' => $condition,
            ]);
            $this->add_responsive_control('quote_img_h_offset',[
                'label'     => esc_html__( 'Horizontal Offset', 'onnat-extra' ),
                'type'      => KFCM::SLIDER,
                'range'     => [
					'px' => [
                        'min'  => -999,
                        'max'  => 999,
                        'step' => 5,
					],
                ],
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-quote-wrap.kfw-testimonial-quote-image-type' => 'left:{{SIZE}}{{UNIT}};'
                ],
                'condition' => $condition,
            ]);
            $this->add_responsive_control( 'quote_img_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-quote-image-type' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'quote_img_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-quote-image-type' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
    }

	public function _register_avatar_style_section() {
        $condition = [
            'use_avatar!' => ''
        ];

		$this->start_controls_section( 'section_avatar_style', [
            'label'     => esc_html__( 'Avatar', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition,
		]);
            $this->add_responsive_control( 'avatar_size', [
                'label'      => esc_html__('Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-img-wrap img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'avatar_bg',
                'types'     => ['classic', 'gradient'],
                'exclude'   => [ 'image'],
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-img-wrap',
            ]);
            $this->add_control('avatar_bg_rotate',[
                'label'     => esc_html__( 'Background Rotate', 'onnat-extra' ),
                'type'      => KFCM::SLIDER,
                'default'   => [
                    'size' => 0,
                    'unit' => 'deg',
                ],
                'range'     => [
                    'deg' => [
                        'max' => 360,
                        'min' => -360,
                    ],
                ],
                'condition' => [
                    'use_avatar!'          => '',
                    'avatar_bg_background' => [ 'classic', 'gradient' ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-img-wrap' => 'transform: rotate({{SIZE}}{{UNIT}});',
                ],
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'avatar_border',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-img-wrap'
            ]);
            $this->add_responsive_control( 'avatar_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-img-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .kfw-testimonial-img-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'avatar_box_shadow',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-img-wrap'
            ]);
            $this->add_responsive_control( 'avatar_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-img-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'avatar_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-img-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
    }

    public function _register_name_style_section() {
		$this->start_controls_section( 'section_name_style', [
			'label' => esc_html__( 'Name', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'name_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-testimonial-name',
            ]);
            $this->add_responsive_control( 'name_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'name_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'name_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-name' => 'color: {{VALUE}};' ],
            ]);
            $this->add_group_control( KFGCTS::get_type(), [
                'name'     => 'name_txt_shadow',
                'selector' => '{{WRAPPER}} .kfw-testimonial-name',
            ]);
            $this->add_group_control( KFGCTST::get_type(), [
                'name'     => 'name_txt_stroke',
                'selector' => '{{WRAPPER}} .kfw-testimonial-name',
            ]);
		$this->end_controls_section();
    }

    public function _register_role_style_section() {
        $role_condition = [
            'use_role!' => ''
        ];

		$this->start_controls_section( 'section_role_style', [
            'label'     => esc_html__( 'Role', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $role_condition,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'      => 'role_typo',
                'label'     => esc_html__( 'Typography', 'onnat-extra' ),
                'selector'  => '{{WRAPPER}} .kfw-testimonial-role',
                'condition' => $role_condition,
            ]);
            $this->add_responsive_control( 'role_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $role_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-role' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'role_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $role_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-role' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'role_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $role_condition,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-role' => 'color: {{VALUE}};' ],
            ]);
            $this->add_group_control( KFGCTS::get_type(), [
                'name'      => 'role_txt_shadow',
                'condition' => $role_condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-role',
            ]);
            $this->add_group_control( KFGCTST::get_type(), [
                'name'      => 'role_txt_stroke',
                'condition' => $role_condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-role',
            ]);
		$this->end_controls_section();
    }

    public function _register_content_style_section() {
		$this->start_controls_section( 'section_content_style', [
			'label' => esc_html__( 'Content', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'content_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-testimonial-comment',
            ]);
            $this->add_responsive_control( 'content_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-comment' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'content_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-comment' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'content_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-comment' => 'color: {{VALUE}};' ],
            ]);
            $this->add_group_control( KFGCTS::get_type(), [
                'name'     => 'content_txt_shadow',
                'selector' => '{{WRAPPER}} .kfw-testimonial-comment',
            ]);
            $this->add_group_control( KFGCTST::get_type(), [
                'name'     => 'content_txt_stroke',
                'selector' => '{{WRAPPER}} .kfw-testimonial-comment',
            ]);
		$this->end_controls_section();
    }

    public function _register_rating_style_section() {
        $rating_condition = [
            'use_rating!' => ''
        ];

		$this->start_controls_section( 'section_rating_style', [
            'label'     => esc_html__( 'Rating', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $rating_condition,
		]);
			$this->add_responsive_control( 'rating_margin', [
                'label'              => esc_html__('Margin', 'onnat-extra' ),
                'type'               => KFCM::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
				'allowed_dimensions' => [
                    'top',
                    'right',
                    'bottom',
                ],
				'placeholder'        => [
                    'top'    => '',
                    'right'  => '',
                    'bottom' => '',
                    'left'   => 'auto',
                ],
				'condition'          => $rating_condition,
				'selectors'          => [
					'{{WRAPPER}} .kfw-testimonial-rating' => 'margin-top: {{TOP}}{{UNIT}}; margin-bottom: {{BOTTOM}}{{UNIT}}; margin-right: {{RIGHT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'rating_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $rating_condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-rating' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
            $this->add_control( 'rating_active_color', [
                'label'     => esc_html__('Active Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $rating_condition,
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-rating span:before' => 'color:{{VALUE}};',
                ],
            ]);
            $this->add_control( 'rating_deactive_color', [
                'label'     => esc_html__('Inactive Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $rating_condition,
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-rating:before' => 'color:{{VALUE}};',
                ],
            ]);
		$this->end_controls_section();
    }

	/**
	 * Generate setting json
	 */
	protected function _generate_setting_json( array $settings ) {

		$cols = [
			'widescreen'   => 3,
			'desktop'      => 2,
			'laptop'       => 2,
			'tablet'       => 2,
			'tablet_extra' => 2,
			'mobile'       => 1,
			'mobile_extra' => 1,
		];

		$options = [
			'autoHeight'     => true,
			'loop'           => $settings['loop'] === 'yes' ? true : false,
			'slidesPerView'  => 1,
			'slidesPerGroup' => 1,
			'spaceBetween'   => 20
		];

		/**
		 * Break Points
		 */
            $breakpoints            = \Elementor\Plugin::$instance->breakpoints->get_breakpoints();
            $options['breakpoints'] = [];

            $options['breakpoints'][1440] = [
                "device"         => 'desktop',
                'slidesPerView'  => ( isset($settings["cols"]) && !empty( $settings["cols"]) ) ? (int)$settings["cols"] : $cols['desktop'],
                'slidesPerGroup' => ( isset($settings["slide_to_scroll"]) && !empty( $settings["slide_to_scroll"] ) ) ? (int)$settings["slide_to_scroll"] : 1,
                'spaceBetween'   => ( isset($settings["col_gap"]["size"]) && !empty( $settings["col_gap"]["size"] ) ) ? (int)$settings["col_gap"]["size"] : 20,
            ];

            foreach( $breakpoints as $breakpoint ) {
                $device = $breakpoint->get_label();
                $name   = $breakpoint->get_name();
                $value  = $breakpoint->get_value();

                if( 'widescreen' !== $name ) {
                    $col_key    = "cols_".$name;
                    $scroll_key = "slide_to_scroll_".$name;
                    $gap_key    = "col_gap_".$name;

                    if( isset( $settings[ $col_key ] ) ) {
                        $options['breakpoints'][ $value ] = [
                            "device"         => $device,
                            "slidesPerView"  => ( isset( $settings[ $col_key ] ) && !empty( $settings[ $col_key ] ) ) ? (int) $settings[ $col_key ] : $cols[$name],
                            "slidesPerGroup" => ( isset( $settings[ $scroll_key ] ) && !empty( $settings[ $scroll_key ] ) ) ? (int) $settings[ $scroll_key ] : 1,
                            "spaceBetween"   => ( isset( $settings[ $gap_key ]['size'] ) && !empty( $settings[ $gap_key ]['size'] ) ) ? (int) $settings[ $gap_key ]['size'] : 20,
                        ];
                    } else {
                        $options['breakpoints'][ $value ] = [
                            "device"         => $device,
                            "slidesPerView"  => $cols[$name],
                            "slidesPerGroup" => 1,
                            "spaceBetween"   => 20,
                        ];
                    }
                }
            }

        /**
         * Other Settings
         */
            if( $settings['autoplay'] === 'yes' ) {
                $options['pauseOnHover']  = $settings['pause'] === 'yes' ? true : false;
                $options['autoplay']['delay'] = isset( $settings['autoplay_speed']['size'] ) ? $settings['autoplay_speed']['size'] : 1000;
            } else {
                $options['pauseOnHover']  = false;
            }

            if( $settings['arrows'] === 'yes' ) {
                $options['navigation']['nextEl'] = '.kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-next';
                $options['navigation']['prevEl'] = '.kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-prev';
                $options['arrowPosition']        = $settings['arrow_position'];
                $options['hideArrowsOnMobile']   = $settings['mobile_arrows'] === 'yes' ? true : false;
            }

            if( $settings['dots'] === 'yes' ) {
                $options['pagination']['type']      = 'bullets';
                $options['pagination']['el']        = '.kfw-js-swiper-'.esc_attr( $this->get_id() ).'-pagination';
                $options['pagination']['clickable'] = true;
            }

		return wp_json_encode( $options );
	}

	public function _message( $message, $echo = true ) {
		$return = sprintf( '
			<div class="elementor-alert elementor-alert-info" role="alert">
				<span class="elementor-alert-description">%s</span>
			</div>',
			$message
		);

		if( $echo ) {
			echo $return;
			return;
		}

		return $return;
	}

	/**
	 * Get attachment image src.
	 */
	public static function _get_image_src( $attachment_id, $image_size_key, array $settings ) {
        return KFGCIS::get_attachment_image_src( $attachment_id, $image_size_key, $settings );
	}

	public static function _get_image_html( $settings ) {
		return KFGCIS::get_attachment_image_html( $settings );
	}

	public function _get_image_title( $attachment ) {
		if ( empty( $attachment['id'] ) ) {
			return '';
		}

		return get_the_title( $attachment['id'] );
	}

	public function _get_image_alt( $instance ) {
		if ( empty( $instance['id'] ) ) {
			// For `Insert From URL` images.
			return isset( $instance['alt'] ) ? trim( strip_tags( $instance['alt'] ) ) : '';
		}

		$attachment_id = $instance['id'];
		if ( ! $attachment_id ) {
			return '';
		}

		$attachment = get_post( $attachment_id );
		if ( ! $attachment ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		if ( ! $alt ) {
			$alt = $attachment->post_excerpt;
			if ( ! $alt ) {
				$alt = $attachment->post_title;
			}
		}
		return trim( strip_tags( $alt ) );
	}

	public function _render_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

        if( !empty( $icon ) ) {
            echo '<span class="kfw-elementor-icon-wrap">';
                KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
            echo '</span>';
		}
	}

    public function _render_img( $settings = [] ) {
        if( !empty( $settings['url'] ) ) {
            $image_src = $settings['url'];

			$image_title = $this->_get_image_title( $settings );
			$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

			$image_alt = $this->_get_image_alt( $settings );
			$image_alt = empty( $image_alt ) ? $image_title : $image_title;

            echo '<span class="kfw-elementor-icon-wrap">';
                echo '<img alt="'. esc_attr( $image_alt ) .'" title="'. esc_attr( $image_title ) .'" src="'. esc_url( $image_src ) .'"/>';
            echo '</span>';
        }
    }

    public function _style_1( $items, $settings ) {
        foreach( $items as $index => $item ) {

            /**
             * Avatar
             */
                $image_src = $this->_get_image_src( $item['avatar']['id'], 'image_size', $settings );
                $image_src = empty($image_src) ? $item['avatar']['url'] : $image_src;

            $item_wrapper = $this->get_repeater_setting_key( 'item', 'kfw-items', $index );
            $this->add_render_attribute( $item_wrapper, [
                'id'    => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class' => array_filter([
					'swiper-slide',
                    'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                    ( 'yes' === $settings['use_avatar'] ) ? '' : 'kfw-has-no-avatar',
                    ( empty( $image_src ) ) ? 'kfw-has-no-avatar' : '',
                    'kfw-testimonial-item',
                ])
            ]);

            echo '<div '.$this->get_render_attribute_string( $item_wrapper ).'>';

                /**
                 * Quote Icon Wrap
                 */
                if( $settings['quote_icon_type'] !== 'blank'  ) {
                    $icon_attr = $this->get_repeater_setting_key( 'icon-item', 'kfw-items', $index );
                    $this->add_render_attribute( $icon_attr, [
                        'class' => [
                            'kfw-testimonial-quote-wrap',
                            'kfw-testimonial-quote-'.esc_attr( $settings['quote_icon_type'] ) . '-type'
                        ],
                    ] );

                    echo '<div '.$this->get_render_attribute_string($icon_attr).'>';
                        if( $settings['quote_icon_type'] === 'icon' ) {
                            $this->_render_icon( $settings['quote_icon_icon'] );
                        } else if( $settings['quote_icon_type'] === 'default' ) {
                            echo '<span class="kfw-elementor-icon-wrap"> <span class="kinfw-icon kinfw-icon-onnat-quote"></span> </span>';
                        } else if( $settings['quote_icon_type'] === 'image' ) {
                            $this->_render_img( $settings['quote_icon_image'] );
                        }
                    echo '</div>';
                }

                /**
                 * Header
                 */
                echo '<div class="kfw-testimonial-header-wrap">';

                    if( 'yes' === $settings['use_avatar'] ) {

                        if( !empty( $image_src ) ) {
                            echo '<div class="kfw-testimonial-img-wrap">';
                                $image_title = $this->_get_image_title( $item['avatar'] );
                                $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                                $image_alt = $this->_get_image_alt( $item['avatar'] );
                                $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                                $image_attr = $this->get_repeater_setting_key( 'image-item', 'kfw-items', $index );
                                $this->add_render_attribute( $image_attr, [
                                    'class' => 'kfw-testimonial-avatar kfw-image-is-loading',
                                    'alt'   => esc_attr( $image_alt ),
                                    'title' => esc_attr( $image_title ),
                                    'src'   => esc_url( $image_src ),
                                ]);

                                echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                            echo '</div>';
                        }
                    }

                    echo '<div class="kfw-testimonial-header">';
                        echo '<div class="kfw-testimonial-name">'. esc_html( $item['name'] ) . '</div>';
                        if( 'yes' === $settings['use_role'] ) {
                            echo '<div class="kfw-testimonial-role">'. esc_html( $item['role'] ) . '</div>';
                        }
                    echo '</div>';

                    if( 'yes' === $settings['use_rating'] ) {
                        echo '<div class="kfw-testimonial-rating"><span class="kfw-testimonial-rating-inner"></span></div>';
                    }

                echo '</div>';

                /**
                 * Content
                 */
                echo '<div class="kfw-testimonial-comment">';
                    echo esc_html( $item['content'] );
                echo '</div>';

            echo '</div>';
        }
    }

    public function _style_3( $items, $settings ) {
        foreach( $items as $index => $item ) {

            /**
             * Avatar
             */
                $image_src = $this->_get_image_src( $item['avatar']['id'], 'image_size', $settings );
                $image_src = empty($image_src) ? $item['avatar']['url'] : $image_src;

            $item_wrapper = $this->get_repeater_setting_key( 'item', 'kfw-items', $index );
            $this->add_render_attribute( $item_wrapper, [
                'id'    => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class' => array_filter([
					'swiper-slide',
                    'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                    ( 'yes' === $settings['use_avatar'] ) ? '' : 'kfw-has-no-avatar',
                    ( empty( $image_src ) ) ? 'kfw-has-no-avatar' : '',
                    'kfw-testimonial-item',
                ])
            ]);

            echo '<div '.$this->get_render_attribute_string( $item_wrapper ).'>';

                /**
                 * Quote Icon Wrap
                 */
                    if( $settings['quote_icon_type'] !== 'blank'  ) {
                        $icon_attr = $this->get_repeater_setting_key( 'icon-item', 'kfw-items', $index );
                        $this->add_render_attribute( $icon_attr, [
                            'class' => [
                                'kfw-testimonial-quote-wrap',
                                'kfw-testimonial-quote-'.esc_attr( $settings['quote_icon_type'] ) . '-type'
                            ],
                        ] );

                        echo '<div '.$this->get_render_attribute_string($icon_attr).'>';
                            if( $settings['quote_icon_type'] === 'icon' ) {
                                $this->_render_icon( $settings['quote_icon_icon'] );
                            } else if( $settings['quote_icon_type'] === 'default' ) {
                                echo '<span class="kfw-elementor-icon-wrap"> <span class="kinfw-icon kinfw-icon-onnat-quote"></span> </span>';
                            } else if( $settings['quote_icon_type'] === 'image' ) {
                                $this->_render_img( $settings['quote_icon_image'] );
                            }
                        echo '</div>';
                    }

                /**
                 * Rating
                 */
                    if( 'yes' === $settings['use_rating'] ) {
                        echo '<div class="kfw-testimonial-rating"><span class="kfw-testimonial-rating-inner"></span></div>';
                    }

                /**
                 * Content
                 */
                    echo '<div class="kfw-testimonial-comment">';
                        echo esc_html( $item['content'] );
                    echo '</div>';

                /**
                 * Header
                 */
                    echo '<div class="kfw-testimonial-header-wrap">';

                        if( 'yes' === $settings['use_avatar'] ) {

                            if( !empty( $image_src ) ) {
                                echo '<div class="kfw-testimonial-img-wrap">';
                                    $image_title = $this->_get_image_title( $item['avatar'] );
                                    $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                                    $image_alt = $this->_get_image_alt( $item['avatar'] );
                                    $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                                    $image_attr = $this->get_repeater_setting_key( 'image-item', 'kfw-items', $index );
                                    $this->add_render_attribute( $image_attr, [
                                        'class' => 'kfw-testimonial-avatar kfw-image-is-loading',
                                        'alt'   => esc_attr( $image_alt ),
                                        'title' => esc_attr( $image_title ),
                                        'src'   => esc_url( $image_src ),
                                    ]);

                                    echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                                echo '</div>';
                            }
                        }

                        echo '<div class="kfw-testimonial-header">';
                            echo '<div class="kfw-testimonial-name">'. esc_html( $item['name'] ) . '</div>';
                            if( 'yes' === $settings['use_role'] ) {
                                echo '<div class="kfw-testimonial-role">'. esc_html( $item['role'] ) . '</div>';
                            }
                        echo '</div>';

                    echo '</div>';

            echo '</div>';
        }
    }

    public function _style_4( $items, $settings ) {
        foreach( $items as $index => $item ) {
            /**
             * Avatar
             */
            $image_src = $this->_get_image_src( $item['avatar']['id'], 'image_size', $settings );
            $image_src = empty($image_src) ? $item['avatar']['url'] : $image_src;

            $item_wrapper = $this->get_repeater_setting_key( 'item', 'kfw-items', $index );
            $this->add_render_attribute( $item_wrapper, [
                'id'    => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class' => array_filter([
					'swiper-slide',
                    'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                    ( 'yes' === $settings['use_avatar'] ) ? '' : 'kfw-has-no-avatar',
                    ( empty( $image_src ) ) ? 'kfw-has-no-avatar' : '',
                    'kfw-testimonial-item',
                ])
            ]);

            echo '<div '.$this->get_render_attribute_string( $item_wrapper ).'>';
                /**
                 * Badge & Rating
                 */
                $badge = array_filter( $settings['quote_badge_image'] );
                if( 'yes' === $settings['use_rating'] || isset( $badge['url'] ) ) {
                    echo '<div class="kfw-testimonial-rating-wrap">';
                        if( isset( $badge['url'] ) ) {
                            $badge_src   = $badge['url'];
                            $badge_title = $this->_get_image_title( $badge );
                            $badge_title = empty( $badge_title ) ? $this->get_title() : $badge_title;
                
                            $badge_alt = $this->_get_image_alt( $badge );
                            $badge_alt = empty( $badge_alt ) ? $badge_alt : $badge_alt;

                            echo '<img alt="'. esc_attr( $badge_alt ) .'" title="'. esc_attr( $badge_title ) .'" src="'. esc_url( $badge_src ) .'"/>';
                        }

                        if( 'yes' === $settings['use_rating'] ) {
                            echo '<div class="kfw-testimonial-rating"><span class="kfw-testimonial-rating-inner"></span></div>';
                        }
                    echo '</div>';
                }

                /**
                 * Content
                 */
                echo '<div class="kfw-testimonial-comment">';
                    echo esc_html( $item['content'] );
                echo '</div>';

                /**
                 * Bottom Section 
                 */
                echo '<div class="kfw-testimonial-bottom">';
                    /**
                     * Header
                     */
                    echo '<div class="kfw-testimonial-header-wrap">';
                        if( 'yes' === $settings['use_avatar'] ) {

                            if( !empty( $image_src ) ) {
                                echo '<div class="kfw-testimonial-img-wrap">';
                                    $image_title = $this->_get_image_title( $item['avatar'] );
                                    $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                                    $image_alt = $this->_get_image_alt( $item['avatar'] );
                                    $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                                    $image_attr = $this->get_repeater_setting_key( 'image-item', 'kfw-items', $index );
                                    $this->add_render_attribute( $image_attr, [
                                        'class' => 'kfw-testimonial-avatar kfw-image-is-loading',
                                        'alt'   => esc_attr( $image_alt ),
                                        'title' => esc_attr( $image_title ),
                                        'src'   => esc_url( $image_src ),
                                    ]);

                                    echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                                echo '</div>';
                            }
                        }

                        echo '<div class="kfw-testimonial-header">';
                            echo '<div class="kfw-testimonial-name">'. esc_html( $item['name'] ) . '</div>';
                            if( 'yes' === $settings['use_role'] ) {
                                echo '<div class="kfw-testimonial-role">'. esc_html( $item['role'] ) . '</div>';
                            }
                        echo '</div>';
                    echo '</div>';

                    /**
                     * Quote Icon Wrap
                     */
                    if( $settings['quote_icon_type'] !== 'blank'  ) {
                        $icon_attr = $this->get_repeater_setting_key( 'icon-item', 'kfw-items', $index );
                        $this->add_render_attribute( $icon_attr, [
                            'class' => [
                                'kfw-testimonial-quote-wrap',
                                'kfw-testimonial-quote-'.esc_attr( $settings['quote_icon_type'] ) . '-type'
                            ],
                        ] );

                        echo '<div '.$this->get_render_attribute_string($icon_attr).'>';
                            if( $settings['quote_icon_type'] === 'icon' ) {
                                $this->_render_icon( $settings['quote_icon_icon'] );
                            } else if( $settings['quote_icon_type'] === 'default' ) {
                                echo '<span class="kfw-elementor-icon-wrap"> <span class="kinfw-icon kinfw-icon-onnat-quote"></span> </span>';
                            } else if( $settings['quote_icon_type'] === 'image' ) {
                                $this->_render_img( $settings['quote_icon_image'] );
                            }
                        echo '</div>';
                    }                
                echo '</div>';
            echo '</div>';
        }
    }

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-testimonial-carousel");
		include $render;
    }
}