<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extend_FontFlow_KinForce_Icons' ) ) {

	/**
	 * Define the KinForce Icons icon library.
     *
	 */
    class KinForce_Extend_FontFlow_KinForce_Icons {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {
            add_filter( 'elementor/icons_manager/additional_tabs', [ $this,'load'] );
        }

        public function load( $additional_tabs ) {

            $icons = [
                'alert-circle',
                'alert-triangle',
                'arrows-circle-down',
                'arrows-circle-left',
                'arrows-circle-right',
                'arrows-circle-solid-down',
                'arrows-circle-solid-left',
                'arrows-circle-solid-right',
                'arrows-circle-solid-up',
                'arrows-circle-up',
                'arrows-corner-left-up',
                'arrows-corner-right-up',
                'arrows-long-down',
                'arrows-long-left',
                'arrows-long-right',
                'arrows-long-up',
                'arrows-simple-down-left',
                'arrows-simple-down-right',
                'arrows-simple-down',
                'arrows-simple-left',
                'arrows-simple-right',
                'arrows-simple-up-left',
                'arrows-simple-up-right',
                'arrows-simple-up',
                'brand-android',
                'brand-apple',
                'brand-codepen',
                'brand-css3',
                'brand-digg',
                'brand-dribbble',
                'brand-dropbox',
                'brand-drupal',
                'brand-facebook',
                'brand-figma',
                'brand-flickr',
                'brand-foursquare',
                'brand-github',
                'brand-google',
                'brand-html5',
                'brand-instagram',
                'brand-joomla',
                'brand-jsfiddle',
                'brand-linkedin',
                'brand-linux',
                'brand-microsoft',
                'brand-pinterest',
                'brand-reddit',
                'brand-rss-solid',
                'brand-skype',
                'brand-spotify',
                'brand-stack-overflow',
                'brand-stumbleupon',
                'brand-trello',
                'brand-tumblr',
                'brand-twitch',
                'brand-twitter',
                'brand-vimeo',
                'brand-wordpress',
                'brand-x-twitter',
                'brand-yahoo',
                'brand-youtube',
                'chevron-circle-solid-down',
                'chevron-circle-solid-left',
                'chevron-circle-solid-right',
                'chevron-circle-solid-up',
                'chevron-simple-down',
                'chevron-simple-left',
                'chevron-simple-right',
                'chevron-simple-up',
                'chevrons-down',
                'chevrons-left',
                'chevrons-right',
                'chevrons-up',
                'comment-multiple',
                'comment-off',
                'comment-single',
                'hand-point-up-regular',
                'hand-point-up-solid',
                'heart-regular',
                'heart-solid',
                'link-external',
                'link-regular',
                'math-cross',
                'math-minus',
                'math-percent',
                'math-plus',
                'misc-award',
                'misc-bars',
                'misc-bookmark',
                'misc-calendar',
                'misc-camera',
                'misc-clock',
                'misc-coffee',
                'misc-download',
                'misc-edit',
                'misc-eye-off',
                'misc-eye',
                'misc-file-text',
                'misc-file',
                'misc-film',
                'misc-folder',
                'misc-gift',
                'misc-globe',
                'misc-headphones',
                'misc-home',
                'misc-image',
                'misc-info',
                'misc-layers',
                'misc-lock',
                'misc-log-in',
                'misc-log-out',
                'misc-mail',
                'misc-map-pin',
                'misc-map',
                'misc-maximize',
                'misc-menu-dots',
                'misc-mic',
                'misc-music',
                'misc-phone-call',
                'misc-play',
                'misc-power',
                'misc-printer',
                'misc-scissors',
                'misc-search',
                'misc-send',
                'misc-share',
                'misc-sort-up-solid',
                'misc-trash',
                'misc-unlock',
                'misc-upload',
                'misc-video',
                'misc-zoom-in',
                'misc-zoom-out',
                'more-horizontal',
                'more-vertical',
                'quote-left',
                'quote-right',
                'shopping-bag',
                'shopping-cart',
                'shopping-woo-product-external',
                'shopping-woo-product-grouped',
                'shopping-woo-product-simple',
                'shopping-woo-product-variable',
                'star-regular',
                'star-solid',
                'tag-multiple',
                'tag-single',
                'thumbs-down',
                'thumbs-up',
                'tick-circle',
                'tick-simple',
                'tick-square',
                'user-multiple',
                'user-single',
            ];

            $additional_tabs[ 'fontflow-kinfwicons' ] = [
                'name'          => 'fontflow-kinfwicons',
                'label'         => esc_html__( 'FontFlow - KinForce Icons', 'onnat-extra' ),
                'labelIcon'     => 'fas fa-chevron-right',
                'ver'           => FCIFE_CONST_VERSION,
                'prefix'        => 'fontflow-kinfw-',
                'displayPrefix' => 'fontflow-kinfw',
                'url'           => KFE_CONST_URL . 'libraries/fontflow/assets/css/kinfwicons/fontflow-kinfw.min.css',
                'enqueue'       => [ KFE_CONST_URL . 'libraries/fontflow/assets/css/kinfwicons/fontflow-kinfw.min.css' ],
                'icons'         => $icons
            ];

            return $additional_tabs;
        }

    }

}

if( !function_exists( 'kf_extend_fontflow_kinforce_icons' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extend_fontflow_kinforce_icons() {

        return KinForce_Extend_FontFlow_KinForce_Icons::get_instance();
    }
}

kf_extend_fontflow_kinforce_icons();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */