<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_CPT_Team_Member' ) ) {

	/**
	 * Define the team member custom post type.
	 */
    class KinForce_Extra_Plugin_CPT_Team_Member {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'init', [ $this, 'init' ] );
            /**
             * Filter to modify the checkbox to radio button
             */
            add_filter( 'kinfw-filter/plugin/radio-buttons-for-taxonomies', [ $this, 'update_tax_metabox' ] );
            add_filter( 'kinfw-filter/plugin/radio-buttons-for-taxonomies/no-term-kinfw-team-group', '__return_true' );

            add_filter( 'theme_kinfw-team-member_templates', [ $this, 'page_templates' ] );

            add_filter( 'kinfw-filter/theme/metabox/template/post-type', [ $this, 'add_template_metabox' ] );

            add_filter( 'enter_title_here', [ $this, 'post_type_title_placeholder' ], 10, 2 );

            add_action( 'kinfw-action/theme/meta-boxes/our/cpt/loaded', [ $this, 'add_extra_metabox' ] );
        }

        public function init() {

            /**
             * Register Custom Post Type
             */
                $team_cpt_slug   = 'kinfw-team-member';
                $team_group_slug = 'kinfw-team-group';

                $labels = [
                    'name'                  => esc_html__( 'Team Members', 'onnat-extra' ),
                    'singular_name'         => esc_html__( 'Team Member', 'onnat-extra' ),
                    'menu_name'             => esc_html__( 'Team Members', 'onnat-extra' ),
                    'name_admin_bar'        => esc_html__( 'Team Member', 'onnat-extra' ),
                    'add_new'               => esc_html__( 'Add New Member', 'onnat-extra' ),
                    'add_new_item'          => esc_html__( 'Add New Team Member', 'onnat-extra' ),
                    'new_item'              => esc_html__( 'New Template', 'onnat-extra' ),
                    'edit_item'             => esc_html__( 'Edit Template', 'onnat-extra' ),
                    'view_item'             => esc_html__( 'View Template', 'onnat-extra' ),
                    'all_items'             => esc_html__( 'All Team Members', 'onnat-extra' ),
                    'search_items'          => esc_html__( 'Search Templates', 'onnat-extra' ),
                    'parent_item_colon'     => esc_html__( 'Parent Templates:', 'onnat-extra' ),
                    'not_found'             => esc_html__( 'No Templates found.', 'onnat-extra' ),
                    'not_found_in_trash'    => esc_html__( 'No Templates found in Trash.', 'onnat-extra' ),
                    'featured_image'        => esc_html__( 'Team Member Image', 'onnat-extra' ),
                    'set_featured_image'    => esc_html__( 'Set Team Member Image', 'onnat-extra' ),
                    'remove_featured_image' => esc_html__( 'Remove Team Member Image', 'onnat-extra' ),
                    'use_featured_image'    => esc_html__( 'Use as Team Member Image', 'onnat-extra' ),
                ];

                $args   = [
                    'label'               => esc_html__( 'Team Member', 'onnat-extra' ),
                    'labels'              => $labels,
                    'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
                    'hierarchical'        => false,
                    'public'              => true,
                    'show_ui'             => true,
                    'show_in_admin_bar'   => true,
                    'show_in_menu'        => true,
                    'show_in_nav_menus'   => true,
                    'menu_icon'           => 'dashicons-businessman',
                    'can_export'          => false,
                    'has_archive'         => false,
                    'exclude_from_search' => false,
                    'publicly_queryable'  => true,
                    'capability_type'     => 'page',
                    'show_in_rest'        => true,
                    'rewrite'             => [ 'slug' => esc_attr($team_cpt_slug) ],
                ];

                register_post_type( 'kinfw-team-member', $args );

            /**
             * Register Custom Taxonomy
             */
                $labels   = [
                    'name'                       => _x( 'Team Groups', 'Taxonomy General Name', 'onnat-extra' ),
                    'singular_name'              => _x( 'Team Group', 'Taxonomy Singular Name', 'onnat-extra' ),
                    'menu_name'                  => __( 'Team Group', 'onnat-extra' ),
                    'all_items'                  => __( 'All Team Groups', 'onnat-extra' ),
                    'parent_item'                => __( 'Parent Team Group', 'onnat-extra' ),
                    'parent_item_colon'          => __( 'Parent Team Group:', 'onnat-extra' ),
                    'new_item_name'              => __( 'New Team Group', 'onnat-extra' ),
                    'add_new_item'               => __( 'Add New Team Group', 'onnat-extra' ),
                    'edit_item'                  => __( 'Edit Team Group', 'onnat-extra' ),
                    'update_item'                => __( 'Update Team Group', 'onnat-extra' ),
                    'view_item'                  => __( 'View Team Group', 'onnat-extra' ),
                    'separate_items_with_commas' => __( 'Separate items with commas', 'onnat-extra' ),
                    'add_or_remove_items'        => __( 'Add or remove Team Groups', 'onnat-extra' ),
                    'choose_from_most_used'      => __( 'Choose from the most used', 'onnat-extra' ),
                    'popular_items'              => __( 'Popular Team Groups', 'onnat-extra' ),
                    'search_items'               => __( 'Search Team Groups', 'onnat-extra' ),
                    'not_found'                  => __( 'Not Found', 'onnat-extra' ),
                    'no_terms'                   => __( 'No Team Groups', 'onnat-extra' ),
                    'items_list'                 => __( 'Team Groups list', 'onnat-extra' ),
                    'items_list_navigation'      => __( 'Team Groups list navigation', 'onnat-extra' ),
                ];

                $tax_args = [
                    'labels'            => $labels,
                    'hierarchical'      => false,
                    'public'            => true,
                    'show_ui'           => true,
                    'show_admin_column' => true,
                    'query_var'         => true,
                    'rewrite'           => [ 'slug' => esc_attr($team_group_slug) ],
                ];

                register_taxonomy( 'kinfw-team-group', [ 'kinfw-team-member' ], $tax_args );
        }

        public function update_tax_metabox( $taxonomies ) {
            array_push( $taxonomies, 'kinfw-team-group' );

            return $taxonomies;
        }

        public function page_templates( $post_templates ) {
            $post_templates['theme_global_template']  = esc_html__('- Global Theme Option -','onnat-extra');

            return $post_templates;
        }

        public function add_template_metabox( $post_types ) {
            array_push( $post_types, "kinfw-team-member" );
            return $post_types;
        }

        public function post_type_title_placeholder( $title_placeholder, $post ) {
            if ($post->post_type == 'kinfw-team-member') {
                $title_placeholder = esc_html__('Add Team Member Name', 'onnat-extra' );
            }

            return $title_placeholder;
        }

        public function add_extra_metabox() {
            CSF::createMetabox( '_kinfw_cpt_team_member_options', [
                'title'     => esc_html__( 'Team Member Options', 'onnat-extra' ),
                'post_type' => [ 'kinfw-team-member' ],
                'context'   => 'normal',
                'priority'  => 'default'
            ] );

            CSF::createSection( '_kinfw_cpt_team_member_options', [
                'title'  => esc_html__( 'General', 'onnat-extra' ),
                'fields' => [
                    [
                        'type'    => 'number',
                        'id'      => 'experience',
                        'title'   => esc_html__( 'Experience', 'onnat-extra'),
                        'unit'        => esc_html__('Years', 'onnat-extra' ),
                        'default' => 2
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'phone',
                        'title'   => esc_html__( 'Phone', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'email',
                        'title'   => esc_html__( 'Email', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'fax',
                        'title'   => esc_html__( 'Fax', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'      => 'link',
                        'id'        => 'website',
                        'title'     => esc_html__( 'Website', 'onnat-extra'),
                        'add_title' => esc_html__( 'Add Website', 'onnat-extra'),
                        'default'   => [],
                    ],
                ]
            ] );

            CSF::createSection( '_kinfw_cpt_team_member_options', [
                'title'  => esc_html__( 'Social Links', 'onnat-extra' ),
                'fields' => [
                    [
                        'type'    => 'text',
                        'id'      => 'facebook',
                        'title'   => esc_html__( 'Facebook', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'twitter',
                        'title'   => esc_html__( 'Twitter', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'linkedin',
                        'title'   => esc_html__( 'LinkedIn', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'youtube',
                        'title'   => esc_html__( 'Youtube', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'instagram',
                        'title'   => esc_html__( 'Instagram', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'flickr',
                        'title'   => esc_html__( 'Flickr', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'pinterest',
                        'title'   => esc_html__( 'Pinterest', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'xing',
                        'title'   => esc_html__( 'Xing', 'onnat-extra'),
                        'default' => ''
                    ],
                ]
            ] );
        }

    }
}

if( !function_exists( 'kf_extra_plugin_cpt_team_member' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_cpt_team_member() {

        return KinForce_Extra_Plugin_CPT_Team_Member::get_instance();
    }
}

kf_extra_plugin_cpt_team_member();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */