<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Framework' ) ) {

	/**
	 * Define the local codestar plugin load.
	 */
    class KinForce_Extra_Plugin_Framework {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

			add_action( 'plugins_loaded', [ $this, 'load_codestar' ] );
			
			$this->load();

            do_action( 'kinfw-action/plugin/framework/loaded' );

        }

		/**
		 * Load inbuilt codestar plugin.
		 */
		public function load_codestar() {

            if( !class_exists( 'CSF' ) ) {

                require_once KFE_CONST_DIR . 'libraries/codestar-framework/codestar-framework.php';
            }

		}

		public function load() {

			/**
			 * Header Custom Post Type
			 */
			require_once KFE_CONST_DIR . 'libraries/framework/class-cpt-header.php';

			/**
			 * Footer Custom Post Type
			 */
			require_once KFE_CONST_DIR . 'libraries/framework/class-cpt-footer.php';

			/**
			 * Blog Post Style Custom Post Type
			 */
			require_once KFE_CONST_DIR . 'libraries/framework/class-cpt-blog-post-style.php';			

			/**
			 * Mega Menu
			 */

				/**
				 * Mega Menu Custom Post Type
				 */
				require_once KFE_CONST_DIR . 'libraries/framework/class-cpt-mega-menu.php';

				require_once KFE_CONST_DIR . 'libraries/framework/mega-menu/class-mega-menu.php';

			/**
			 * Service
			 */
			require_once KFE_CONST_DIR . 'libraries/framework/class-cpt-service.php';

			/**
			 * Team Member
			 */
			require_once KFE_CONST_DIR . 'libraries/framework/class-cpt-team-member.php';

			/**
			 * Project
			 */
			require_once KFE_CONST_DIR . 'libraries/framework/class-cpt-project.php';			

		}

    }

}

if( !function_exists( 'kf_extra_plugin_framework' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_framework() {

        return KinForce_Extra_Plugin_Framework::get_instance();
    }
}

kf_extra_plugin_framework();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */