<?php
/**
 * Plugin Name: Onnat Extra
 * Plugin URI:  http://onnat.kinforce.net
 * Description: This plugin is the companion for the KinForce's Onnat WordPress theme, it runs and adds its enhacements only if the KinForce's WordPress theme is installed and active. ✨🎉✨
 * Version:     1.0.1
 * Author:      KinForce 🎖️
 * Author URI:  http://themeforest.net/user/kinforce
 * Tested up to:       6.7
 * Requires at least:  5.6
 * Text Domain: onnat-extra
 * Domain Path: /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if( !class_exists( 'KinForce_Onnat_Extra_Plugin' ) ) {

	/**
	 * The KinForce Onnat Extra plugin class.
	 */
    final class KinForce_Onnat_Extra_Plugin {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            $this->define_constants();
            $this->load_dependencies();

			// Register activation and deactivation hook.
			register_activation_hook( __FILE__, [ $this, 'activate_plugin' ] );
			register_deactivation_hook( __FILE__, [ $this, 'deactivate_plugin' ] );

			add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ], 999  );

            do_action( 'kinfw-action/plugin/loaded' );

        }

		/**
		 * Define plugin required constants
		 */
		private function define_constants() {

			$template  = get_template();
			$theme_obj = wp_get_theme( $template );

			$this->define( 'KFE_CONST_SERVER_SOFTWARE', $_SERVER['SERVER_SOFTWARE'] );

            $this->define( 'KFE_CONST_FILE', __FILE__ );

			if( ! function_exists('get_plugin_data') ){
				require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
			}

			/**
			 * We've add 3 args to provide WordPress 6.7.1 compatibility.
			 * 1. $plugin_file - string - Absolute path to the main plugin file.
			 * 2. $markup - bool - If the returned data should have HTML markup applied.
			 * 3. $translate - bool - If the returned data should be translated.
			 */
			$plugin_data = get_plugin_data( KFE_CONST_FILE, true, false );

            $this->define( 'KFE_CONST_PLUGIN_NAME', $plugin_data['Name'] );
            $this->define( 'KFE_CONST_SAN_PLUGIN_NAME', sanitize_title( $plugin_data['Name'] ) );
            $this->define( 'KFE_CONST_SAN_THEME', sanitize_title( $theme_obj->get( 'Name' ) ) );
			$this->define( 'KFE_CONST_THEME_DOC', sprintf( esc_url( 'https://docs.kinforce.net/%s/' ), KFE_CONST_SAN_THEME ) );
            $this->define( 'KFE_CONST_VERSION', $plugin_data['Version'] );
            $this->define( 'KFE_CONST_DIR', trailingslashit( plugin_dir_path( KFE_CONST_FILE ) ) );
			$this->define( 'KFE_CONST_URL', trailingslashit( plugin_dir_url( KFE_CONST_FILE ) ) );
			$this->define( 'KFE_CONST_BASENAME', plugin_basename( KFE_CONST_FILE ) );
            $this->define( 'KFE_CONST_DEBUG_SUFFIX', ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min' ) );

        }

		/**
		 * Define constant if not already set.
		 */
		private function define( $name, $value ) {

			if( !defined( $name ) ) {

				define( $name, $value );

            }

        }

		/**
		 * Load the required dependencies for this plugin.
		 */
		private function load_dependencies() {

            if( !$this->check_requirement() ) {
                return;
            }

			/**
             * Include internationalization functionality of the plugin.
             */
			require_once KFE_CONST_DIR . 'libraries/i18n/class-i18n.php';

			/**
			 * Include framework
			 */
			require_once KFE_CONST_DIR . 'libraries/framework/class-framework.php';

			/**
			 * Elementor
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/class-elementor.php';

			/**
			 * Shortcode
			 */
			require_once KFE_CONST_DIR . 'libraries/shortcode/class-shortcodes.php';

			/**
			 * Radio Buttons for Taxonomies
			 */
			require_once KFE_CONST_DIR . 'libraries/radio-buttons-for-taxonomies/class-radio-buttons-for-taxonomies.php';

			/**
			 * Extend Fontflow Plugin
			 */
			require_once KFE_CONST_DIR . 'libraries/fontflow/class-fontflow.php';

			/**
             * Unyson Demo Content Importer
             * Load necessary files only when the demo content theme is activated.
             */
            if( $this->check_demo_data_theme() ) {

                require_once KFE_CONST_DIR . 'libraries/demo-content-importer/class-demo-content-importer.php';
            }

        }

		private function check_active_theme() {

			$template  = get_template();
			$theme_obj = wp_get_theme( $template );
			$author    = $theme_obj->get( 'Author' );

			if( $author !== "KinForce" ) {

				return false;
			}

			return true;

		}

		private function check_demo_data_theme() {

            $theme_obj = wp_get_theme();
            $author    = $theme_obj->get( 'Author' );
            $domain    = $theme_obj->get( 'TextDomain' );

            if( 'onnat-demo-child' === $domain && 'KinForce' === $author  ) {
                return true;
            }

            return false;

        }

		/**
		 * Check whether basic provision reached.
		 */
		private function check_requirement() {

			add_filter( 'use_widgets_block_editor', '__return_false' );

			if( !$this->check_active_theme() ) {

				return false;
			}

			return true;
        }

        /**
         * Enqueue scripts.
         */
		public function enqueue_scripts() {

            $localize = [
                'ajax'      => esc_url( admin_url('admin-ajax.php') ),
            ];


            wp_localize_script( 'jquery', 'KIN_FW_EXTRA_OBJ', [
                'pluginName'    => KFE_CONST_PLUGIN_NAME,
                'pluginSanName' => KFE_CONST_SAN_PLUGIN_NAME,
                'pluginVersion' => KFE_CONST_VERSION,
            ] );

			wp_localize_script( 'jquery', 'kfe_plugin_L10n', array_unique( apply_filters( 'kinfw-filter/plugin/L10n', $localize ) ) );

            wp_register_script( 'kfe-plugin',
				KFE_CONST_URL . 'assets/js/function'. KFE_CONST_DEBUG_SUFFIX . '.js',
                [ 'jquery' ],
                KFE_CONST_VERSION,
                true
            );

			wp_enqueue_script( 'kfe-plugin' );

		}


		/**
		 * The code that runs during plugin activation.
		 */
		public static function activate_plugin() {
		}

		/**
		 * The code that runs during plugin deactivation.
		 */
		public static function deactivate_plugin() {
		}

    }
}

if( !function_exists( 'kf_onnat_extra_plugin' ) ) {

    /**
     * Returns instance of the Onnat Extra plugin class.
     */
    function kf_onnat_extra_plugin() {

        return KinForce_Onnat_Extra_Plugin::get_instance();
    }
}

kf_onnat_extra_plugin();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */